var api = new ScormAPI();

function updateUI() {
  document.getElementById('completeButton').disabled =
    api.getValue('cmi.completion_status') === 'completed';

  const interactions = api.getValue('cmi.interactions._count');
  document.getElementById('set-1').disabled = interactions >= 1;
  document.getElementById('set-1000').disabled = interactions >= 1000;
  document.getElementById('set-2000').disabled = interactions >= 2000;
}

function start() {
  api.initialize(window);

  // set completion if unset
  if (api.getValue('cmi.completion_status') == 'unknown') {
    api.setValue('cmi.completion_status', 'incomplete');
  }

  document.getElementById('scoreValue').value = api.getValue('cmi.score.raw');

  updateUI();
}

function complete() {
  api.setValue('cmi.completion_status', 'completed');
  updateUI();
}

function handleUnload() {
  if (api.terminated) {
    return;
  }

  // suspend if the module is incomplete
  if (api.getValue('cmi.completion_status') !== 'completed') {
    api.setValue('cmi.exit', 'suspend');
  }

  terminate();
}

function exit() {
  if (api.getValue('cmi.completion_status') !== 'completed') {
    api.setValue('cmi.exit', 'suspend');
    api.setValue('adl.nav.request', 'suspendAll');
  } else {
    api.setValue('cmi.exit', '');
    api.setValue('adl.nav.request', 'exitAll');
  }

  terminate();
}

function terminate() {
  api.setValue('cmi.session_time', 'PT10S');
  api.terminate();
}

function recordTest(score) {
  complete();

  api.setValue('cmi.score.raw', score);
  api.setValue('cmi.score.min', '0');
  api.setValue('cmi.score.max', '100');

  api.setValue('cmi.score.scaled', score / 100);

  if (score >= 70) {
    api.setValue('cmi.success_status', 'passed');
  } else {
    api.setValue('cmi.success_status', 'failed');
  }
}

function submitValue() {
  recordTest(Number(document.getElementById('scoreValue').value));
}

function setInteractions(count) {
  for (var i = 0; i < count; i++) {
    api.setValue('cmi.interactions.' + i + '.id', 'abcdefghi' + i);
  }

  updateUI();
}

document.addEventListener('DOMContentLoaded', start);
window.addEventListener('beforeunload', handleUnload);
window.addEventListener('pagehide', handleUnload);
window.addEventListener('unload', handleUnload);
