/**
 * This file is part of Totara Enterprise Extensions.
 *
 * Copyright (C) 2021 onwards Totara Learning Solutions LTD
 *
 * Totara Enterprise Extensions is provided only to Totara
 * Learning Solutions LTD's customers and partners, pursuant to
 * the terms and conditions of a separate agreement with Totara
 * Learning Solutions LTD or its affiliate.
 *
 * If you do not have an agreement with Totara Learning Solutions
 * LTD, you may not access, use, modify, or distribute this software.
 * Please contact [licensing@totaralearning.com] for more information.
 *
 * @author Alvin Smith <alvin.smith@totaralearning.com>
 * @author Simon Tegg <simon.tegg@totaralearning.com>
 * @module mod_approval
 */
import {
  MY_APPLICATIONS,
  APPLICATIONS_FROM_OTHERS,
} from 'mod_approval/constants';
import { createMachine } from 'tui_xstate/xstate';
import * as selectors from 'mod_approval/application/index/table/selectors';
import * as actions from 'mod_approval/application/index/table/actions';
import * as guards from 'mod_approval/application/index/table/guards';
import * as services from 'mod_approval/application/index/table/services';
import makeState from 'mod_approval/application/index/table/state';

export const tabs = [APPLICATIONS_FROM_OTHERS, MY_APPLICATIONS];

export default function applicationTableMachine({ canApprove }) {
  const state = makeState({ canApprove });

  const queries = {
    [MY_APPLICATIONS]: true,
    [APPLICATIONS_FROM_OTHERS]: true,
  };

  const options = {
    actions,
    guards,
    selectors,
    services,
    queries,
  };

  return createMachine(state, options);
}
