/**
 * This file is part of Totara Enterprise Extensions.
 *
 * Copyright (C) 2021 onwards Totara Learning Solutions LTD
 *
 * Totara Enterprise Extensions is provided only to Totara
 * Learning Solutions LTD's customers and partners, pursuant to
 * the terms and conditions of a separate agreement with Totara
 * Learning Solutions LTD or its affiliate.
 *
 * If you do not have an agreement with Totara Learning Solutions
 * LTD, you may not access, use, modify, or distribute this software.
 * Please contact [licensing@totaralearning.com] for more information.
 *
 * @author Simon Tegg <simon.tegg@totaralearning.com>
 * @module mod_approval
 */

import { MY, OTHERS } from 'mod_approval/constants';

export function mapQueryParamsToContext(params) {
  const context = {
    notify: params.notify,
    notifyType: params.notify_type,
    return_label: params.return_label,
    return_url: params.return_url,
    fromDashboard: Boolean(params.from_dashboard),
    backQueryParams: {},
  };

  if (context.fromDashboard) {
    Object.keys(params).forEach(key => {
      if (
        key.includes(`${MY}.`) ||
        key.includes(`${OTHERS}.`) ||
        key === 'tab'
      ) {
        context.backQueryParams[key] = params[key];
      }
    });
  }

  return context;
}
