<?php
/*
 * This file is part of Totara Learn
 *
 * Copyright (C) 2018 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Brendan Cox <brendan.cox@totaralearning.com>
 * @package tool_totara_sync
 */

namespace tool_totara_sync\task;
use totara_sync_element_jobassignment;

class jobassignment extends \core\task\scheduled_task {

    /**
     * Get a descriptive name for this task (shown to admins).
     *
     * @return string
     */
    public function get_name() {
        return get_string('jobassignmentsynctask', 'tool_totara_sync');
    }

    /**
     * Sync job assignments with external sources
     */
    public function execute() {
        global $CFG;
        require_once($CFG->dirroot . '/admin/tool/totara_sync/elements/jobassignment.php');

        if (!get_config('totara_sync', 'element_jobassignment_enabled')) {
            return;
        }

        $element = new totara_sync_element_jobassignment();
        $element->run_sync();
    }
}