<?php
/*
 * This file is part of Totara Learn
 *
 * Copyright (C) 2017 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Stefenie Pickston <stefenie.pickston@totara.com>
 * @package tool_totara_sync
 */

global $CFG;

use core\model\encrypted_config_plugin;
use totara_oauth2\model\client_provider;
use core\cipher\manager;

require_once($CFG->dirroot . '/admin/tool/totara_sync/sources/source_user_database.php');
require_once($CFG->dirroot . '/admin/tool/totara_sync/sources/classes/source.user.class.php');
require_once($CFG->dirroot . '/admin/tool/totara_sync/admin/forms.php');

class tool_totara_sync_database_trait_test extends \core_phpunit\testcase {

    public function test_encrypt_database_field_stores_encrypted_value_user() {
        $plugin = 'totara_sync_source_user_database';
        $fieldname = 'database_dbpass';
        $value = 'supersecretpassword';

        // Encrypt and store the password
        encrypted_config_plugin::set_config_value('totara_sync_source_user_database', 'database_dbpass', $value);

        // Retrieve using the model
        $stored = encrypted_config_plugin::get_config_value($plugin, $fieldname);

        $this->assertEquals($value, $stored, 'The decrypted value should match the original.');
    }

    public function test_encrypt_database_field_stores_encrypted_value_org() {
        $plugin = 'totara_sync_source_org_database';
        $fieldname = 'database_dbpass';
        $value = 'supersecretpassword';

        // Encrypt and store the password
        encrypted_config_plugin::set_config_value('totara_sync_source_org_database', 'database_dbpass', $value);

        // Retrieve using the model
        $stored = encrypted_config_plugin::get_config_value($plugin, $fieldname);

        $this->assertEquals($value, $stored, 'The decrypted value should match the original.');
    }

    public function test_encrypt_database_field_stores_encrypted_value_pos() {
        $plugin = 'totara_sync_source_pos_database';
        $fieldname = 'database_dbpass';
        $value = 'supersecretpassword';

        // Encrypt and store the password
        encrypted_config_plugin::set_config_value('totara_sync_source_pos_database', 'database_dbpass', $value);

        // Retrieve using the model
        $stored = encrypted_config_plugin::get_config_value($plugin, $fieldname);

        $this->assertEquals($value, $stored, 'The decrypted value should match the original.');
    }

    public function test_forms_output_decrypts_password_value() {
        $value = 'anothersecretpassword';

        $data = new stdClass();
        $data->database_dbtype = 'mysqli';
        $data->database_dbname = 'testdb';
        $data->database_dbhost = 'localhost';
        $data->database_dbuser = 'testuser';
        $data->database_dbport = '0';
        $data->database_dbpass = $value;
        $data->database_dbtable = 'users';
        $data->database_dateformat = 'Y-m-d';

        $traitConsumer = new totara_sync_source_user_database();
        $traitConsumer->set_config('database_dbtype', $data->{'database_dbtype'});
        $traitConsumer->set_config('database_dbname', $data->{'database_dbname'});
        $traitConsumer->set_config('database_dbhost', $data->{'database_dbhost'});
        $traitConsumer->set_config('database_dbuser', $data->{'database_dbuser'});
        $traitConsumer->set_config('database_dbport', $data->{'database_dbport'});
        $traitConsumer->set_config('database_dbtable', $data->{'database_dbtable'});
        $traitConsumer->set_config('database_dateformat', $data->{'database_dateformat'});

        // Encrypt and store the password
        encrypted_config_plugin::set_config_value('totara_sync_source_user_database', 'database_dbpass', $data->database_dbpass);

        // Prepare form
        $form = new totara_sync_source_settings_form(null, [
            'source' => $traitConsumer,
            'elementname' => 'user'
        ]);

        // Call set_data and check password.
        $form->set_data(get_config("totara_sync_source_user_database"));

        $this->getMockBuilder('totara_sync_source_settings_form');
        $reflection = new ReflectionClass('totara_sync_source_settings_form');
        $property = $reflection->getProperty('_form');
        $property->setAccessible(true);
        $moodle_form = $property->getValue($form);

        $this->assertEquals('anothersecretpassword', $moodle_form->getElement('database_dbpass')->getValue());
    }

    public function test_plain_text_password() {
        $traitConsumer = new totara_sync_source_user_database();
        $traitConsumer->set_config('database_dbpass', 'anothersecretpassword');

        $manager = new manager();
        self::assertFalse($manager->is_encrypted_value($traitConsumer->get_config('database_dbpass')));
    }
}
