@availability @availability_audience @totara @javascript
Feature: Adding audience membership activity access restriction
  In order to control student access to activities
  As a teacher
  I need to set date conditions which prevent student access

  Background:
    Given the following "courses" exist:
      | fullname | shortname | format | enablecompletion |
      | Course 1 | C1        | topics | 1                |
    And the following "users" exist:
      | username | email         |
      | teacher1 | t@example.com |
      | student1 | s@example.com |
    And the following "course enrolments" exist:
      | user     | course | role           |
      | teacher1 | C1     | editingteacher |
      | student1 | C1     | student        |
    And the following "cohorts" exist:
        | name      | idnumber | contextlevel | reference |
        | Audience1 | aud1     | System       |           |
        | Audience2 | aud2     | System       |           |
    And the following "cohort members" exist:
        | user     | cohort |
        | student1 | aud1   |

  Scenario: Test audience condition prevents student access
    # Basic setup.
    Given I log in as "admin"
    And I am on "Course 1" course homepage with editing mode on

    # Add a page.
    And I add a "Page" to section "1"
    And I set the following fields to these values:
      | Name         | Test Page 1      |
      | Description  | Some description |
      | Page content | page content     |
    And I expand all fieldsets
    And I click on "Add restriction..." "button"
    And I click on "Audience" "button" in the "Add restriction..." "dialogue"
    And I click on ".availability-item .availability-eye" "css_element"
    And I set the field "Member of Audience" to "Audience1"
    And I press key "13" in the field "Member of Audience"
    And I press "Save and return to course"

    # Add a Page with a grade condition for 'any grade'.
    And I add a "Page" to section "2"
    And I set the following fields to these values:
      | Name         | Test Page 2            |
      | Description  | Some other description |
      | Page content | more page content      |
    And I expand all fieldsets
    And I click on "Add restriction..." "button"
    And I click on "Audience" "button" in the "Add restriction..." "dialogue"
    And I click on ".availability-item .availability-eye" "css_element"
    And I set the field "Member of Audience" to "Audience2"
    And I press key "13" in the field "Member of Audience"
    And I press "Save and return to course"

    # Log in as student
    When I log out
    And I log in as "student1"
    And I am on "Course 1" course homepage

    Then I should see "Test Page 1" in the "region-main" "region"
    And I should not see "Test Page 2" in the "region-main" "region"

  Scenario: Editing teacher can set audience condition when adding an activity
    When I log in as "teacher1"
    And I am on "Course 1" course homepage with editing mode on

    # Add a page.
    And I add a "Page" to section "1"
    And I set the following fields to these values:
      | Name         | Test Page 1      |
      | Description  | Some description |
      | Page content | page content     |
    And I expand all fieldsets
    And I click on "Add restriction..." "button"
    And I click on "Audience" "button" in the "Add restriction..." "dialogue"
    And I click on ".availability-item .availability-eye" "css_element"
    And I set the field "Member of Audience" to "Audience1"
    And I press key "13" in the field "Member of Audience"
    Then I should see "Audience1" in the ".form-autocomplete-selection" "css_element"

    # Verify it was actually saved
    When I press "Save and display"
    And I follow "Edit settings"
    And I expand all fieldsets
    Then I should see "Audience1" in the ".form-autocomplete-selection" "css_element"

  Scenario: Editing teacher can set audience condition when editing settings of an existing activity
    When I log in as "teacher1"
    And I am on "Course 1" course homepage with editing mode on

    # Add a page.
    And I add a "Page" to section "1"
    And I set the following fields to these values:
      | Name         | Test Page 1      |
      | Description  | Some description |
      | Page content | page content     |
    And I press "Save and display"

    # Edit settings for the page activity
    And I follow "Edit settings"
    And I expand all fieldsets
    And I click on "Add restriction..." "button"
    And I click on "Audience" "button" in the "Add restriction..." "dialogue"
    And I click on ".availability-item .availability-eye" "css_element"
    And I set the field "Member of Audience" to "Audience1"
    And I press key "13" in the field "Member of Audience"
    Then I should see "Audience1" in the ".form-autocomplete-selection" "css_element"

    # Verify it was actually saved
    When I press "Save and display"
    And I follow "Edit settings"
    And I expand all fieldsets
    Then I should see "Audience1" in the ".form-autocomplete-selection" "css_element"

  @javascript
  Scenario: Editing teacher is able to edit the audience availability within course section after added
    When I log in as "teacher1"
    And I am on "Course 1" course homepage with editing mode on
    And I edit the section "1"
    And I follow "Restrict access"
    And I click on "Add restriction..." "button"
    And I click on "Member of Audience" "button"
    And I set the field "Member of Audience" to "Audience1"
    And I press key "13" in the field "Member of Audience"
    And I press "Save changes"
    And I edit the section "1"
    And I follow "Restrict access"
    And I should see "Audience1"
    And I set the field "Member of Audience" to "Audience2"
    And I press key "13" in the field "Member of Audience"
    And I press "Save changes"
    When I edit the section "1"
    And I follow "Restrict access"
    Then I should see "Audience2"

  @javascript
  Scenario: Editing teacher is able to delete the audience availability within course's section
    When I log in as "teacher1"
    And I am on "Course 1" course homepage with editing mode on
    And I edit the section "1"
    And I follow "Restrict access"
    And I click on "Add restriction..." "button"
    And I click on "Member of Audience" "button"
    And I set the field "Member of Audience" to "Audience2"
    And I press key "13" in the field "Member of Audience"
    And I press "Save changes"
    And I edit the section "1"
    And I follow "Restrict access"
    When I click on "Delete" "link"
    And I press "Save changes"
    And I edit the section "1"
    And I follow "Restrict access"
    Then I should not see "Audience2"