<?php
/*
 * This file is part of Totara Learn
 *
 * Copyright (C) 2018 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Sam Hemelryk <sam.hemelryk@totaralearning.com>
 * @package block_course_overview
 */


defined('MOODLE_INTERNAL') || die();

global $CFG;
require_once($CFG->dirroot . '/user/tests/userdata_plugin_preferences_testcase.php');

/**
 * @group totara_userdata
 */
class block_course_overview_userdata_preferences_test extends core_user_userdata_plugin_preferences_testcase {

    protected function get_preferences_class(): string {
        return \block_course_overview\userdata\preferences::class;
    }

    protected function get_preferences(): array {
        return [
            'course_overview_number_of_courses' => [5, 20],
            'course_overview_course_sortorder' => [6, 15],
            'course_overview_course_order' => ['6,15,30', '5,10'],
            'region_1_forum' => [true, false],
            'region_1_quiz' => [true, false],
            'region_4_forum' => [true, false],
        ];
    }

}
