<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2019 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Kian Nguyen <kian.nguyen@totaralearning.com>
 * @package container_course
 */
defined('MOODLE_INTERNAL') || die();

class container_course_create_sections_test extends \core_phpunit\testcase {
    /**
     * @return void
     */
    public function test_create_course_with_8_sections(): void {
        global $DB;
        $course = $this->getDataGenerator()->create_course(['numsections' => 8]);

        // Including section zero.
        $this->assertCount(9, $DB->get_records('course_sections', ['course' => $course->id]));
    }

    /**
     * @return void
     */
    public function test_create_course_with_error_sections(): void {
        $this->getDataGenerator()->create_course(['numsections' => 'abcde']);
        $this->assertDebuggingCalled("Property 'numsections' needs to be an integer");
    }
}