<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Lists the course categories
 *
 * @copyright 1999 Martin Dougiamas  http://dougiamas.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @package course
 */

require_once("../config.php");
require_once($CFG->dirroot. '/course/lib.php');
require_once($CFG->libdir. '/coursecatlib.php');

$categoryid = optional_param('categoryid', 0, PARAM_INT); // Category id
if (!$categoryid) {
    if ($CFG->catalogtype === 'enhanced') {
        redirect(new moodle_url('/totara/coursecatalog/courses.php'));
    } elseif ($CFG->catalogtype === 'totara') {
        redirect(new moodle_url('/totara/catalog/index.php'));
    } elseif ($CFG->catalogtype === 'explore') {
        redirect(new moodle_url('/totara/catalog/explore.php'));
    }
}

if ($CFG->forcelogin) {
    require_login();
}

$site = get_site();

$category = null;
if ($categoryid) {
    $category = coursecat::get($categoryid);
    if ($category->issystem) {
        // Totara: provide the ability to navigate away base on the category.
        $hook = new \core_course\hook\course_category_index_view($categoryid);
        $hook->execute();

        // It is from the system, so user should not be able to manage it.
        throw new \coding_exception("Category not found");
    }

    $PAGE->set_category_by_id($categoryid);
    $PAGE->set_url(new moodle_url('/course/index.php', array('categoryid' => $categoryid)));
    $PAGE->set_pagetype('course-index-category');
} else {
    // Check if there is only one category, if so use that.
    if (!empty($USER->tenantid) or coursecat::count_all() == 1) {
        $category = coursecat::get_default();

        $categoryid = $category->id;
        $PAGE->set_category_by_id($categoryid);
        $PAGE->set_pagetype('course-index-category');
    } else {
        $PAGE->set_context(context_system::instance());
    }

    $PAGE->set_url('/course/index.php');
}

$PAGE->set_pagelayout('coursecategory');
/** @var core_course_renderer $courserenderer */
$courserenderer = $PAGE->get_renderer('core', 'course');

if ($category and !$category->is_uservisible()) {
    throw new moodle_exception('unknowncategory');
}
$PAGE->set_totara_menu_selected('\totara_coursecatalog\totara\menu\courses');
$PAGE->set_heading($site->fullname);

echo $OUTPUT->header();
echo $OUTPUT->skip_link_target();
echo $OUTPUT->page_main_heading(get_string('courses', 'core'));

echo $courserenderer->course_category($categoryid);

// Trigger event, course category viewed.
$eventparams = array('context' => $PAGE->context, 'objectid' => $categoryid);
$event = \core\event\course_category_viewed::create($eventparams);
$event->trigger();

echo $OUTPUT->footer();
