@totara @core_course @javascript
Feature: Course progress and completion can be manually reset for individual learners.

  Background:
    Given I am on a totara site
    And the following "users" exist:
      | username    | email                | firstname | lastname |
      | learner1       | learner1@example.com    | User      | One      |
      | learner2       | learner2@example.com    | User      | Two      |
      | learner3       | learner3@example.com    | User      | Three    |
      | learner4       | learner4@example.com    | User      | Four    |
      | editing_trainer    | editing_trainer@example.com | Teacher   | One      |
    And the following "courses" exist:
      | fullname | shortname | enablecompletion |
      | Course 1 | c1        | 1                |
      | Course 2 | c2        | 1                |
    And the following "programs" exist in "totara_program" plugin:
      | fullname  | shortname |
      | Program 1 | P1        |
    And the following "program assignments" exist in "totara_program" plugin:
      | user     | program  |
      | learner1    | P1       |
      | learner3    | P1       |
    And the following "activities" exist:
      | activity | name   | intro                    | course | idnumber | completion |
      | label    | label1 | Click to complete activity | c1     | label1   | 1          |
      | label    | label2 | Click to complete course | c1     | label2   | 1          |
      | label    | label3 | Click to complete course | c2     | label3   | 1          |
    And the following "course enrolments" exist:
      | user     | course | role           |
      | learner1    | c1     | student        |
      | learner2    | c1     | student        |
      | learner3    | c1     | student        |
      | learner4    | c1     | student        |
      | learner2    | c2     | student        |
      | learner3    | c2     | student        |
      | editing_trainer | c1     | editingteacher |
      | editing_trainer | c2     | editingteacher |

    # Add Course 2 to Program 1.
    And I log in as "admin"
    And I go to edit the program "P1"
    And I switch to "Content" tab
    And I click on "Add course set" "button"
    And I click on "Add courses" "button"
    And I toggle the adder picker entry with "Course 2 Miscellaneous" for "Courses"
    And I save my selections and close the adder
    And I press "Save"

    # Set activities to complete in both courses
    And I am on "Course 1" course homepage with editing mode on
    And I navigate to "Course completion" node in "Course administration"
    And I expand all fieldsets
    And I set the field "Completion requirements" to "Course is complete when ALL conditions are met"
    And I set the field "Label - Click to complete activity" to "1"
    And I set the field "Label - Click to complete course" to "1"
    And I press "Save changes"
    And I am on "Course 2" course homepage with editing mode on
    And I navigate to "Course completion" node in "Course administration"
    And I expand all fieldsets
    And I set the field "Completion requirements" to "Course is complete when ALL conditions are met"
    And I set the field "Label - Click to complete course" to "1"
    And I press "Save changes"

    # Ensure an exact set of permissions for learner and editing trainer.
      # Course 1: editing trainer can reset individual but not buk
      # Course 2: editing trainer can reset bulk but not individual
      # Editing trainer can view reports and edit completions
    And the following "permission overrides" exist:
      | capability                                   | permission | role           | contextlevel | reference |
      | totara/core:archivemycourseprogress          | Allow      | student        | Course       |        c1 |
      | totara/core:archiveenrolledcourseprogress    | Prevent       | editingteacher | Course       |        c1 |
      | totara/core:archiveusercourseprogress        | Allow      | editingteacher | Course       |        c1 |
      | moodle/site:viewreports                      | Allow      | editingteacher | Course       |        c1 |
      | totara/completioneditor:editcoursecompletion | Allow      | editingteacher | Course       |        c1 |
      | totara/core:archivemycourseprogress          | Allow      | student        | Course       |        c2 |
      | totara/core:archiveenrolledcourseprogress    | Allow      | editingteacher | Course       |        c2 |
      | totara/core:archiveusercourseprogress        | Prevent       | editingteacher | Course       |        c2 |
      | moodle/site:viewreports                      | Allow      | editingteacher | Course       |        c2 |
      | totara/completioneditor:editcoursecompletion | Allow      | editingteacher | Course       |        c2 |
    And I log out

    # User One completes both courses.
    When I log in as "learner1"
    And I am on "Course 1" course homepage
    And I set the field "Manual completion of Click to complete activity" to "1"
    And I set the field "Manual completion of Click to complete course" to "1"
    And I am on "Course 2" course homepage
    And I set the field "Manual completion of Click to complete course" to "1"
    And I log out

    # User Two completes both courses
    When I log in as "learner2"
    And I am on "Course 1" course homepage
    And I set the field "Manual completion of Click to complete activity" to "1"
    And I set the field "Manual completion of Click to complete course" to "1"
    And I am on "Course 2" course homepage
    And I set the field "Manual completion of Click to complete course" to "1"
    And I log out

    # User Three only completes the first activity of course 1.
    When I log in as "learner3"
    And I am on "Course 1" course homepage
    And I set the field "Manual completion of Click to complete activity" to "1"
    And I log out

  Scenario: I can archive my own course progress after completing a course.
    Given I log in as "learner1"
    And I am on "Course 1" course homepage
    And the field "Manual completion of Click to complete activity" matches value "1"
    And the field "Manual completion of Click to complete course" matches value "1"
    When I navigate to "Reset this course" node in "Course administration"
    And I click on "Continue" "button"
    Then I should see "Your progress in this course and completion state have been archived and reset"
    And the field "Manual completion of Click to complete course" matches value "0"

    # Try resetting progress again.
    When I navigate to "Reset this course" node in "Course administration"
    Then I should see "You have not completed this course"
    And I click on "Ok" "button"

  Scenario: I cannot archive my own course progress when enrolled via program
    Given I log in as "learner1"
    And I am on "Course 2" course homepage
    And the field "Manual completion of Click to complete course" matches value "1"
    And I set the field "Manual completion of Click to complete course" to "1"
    When I navigate to "Reset this course" node in "Course administration"
    Then I should see "Courses which are a part of a Program or Certification can not be manually archived."
    And I click on "Ok" "button"

  Scenario: I can archive my own course progress while the course is in progress.
    Given I log in as "learner3"
    And I am on "Course 1" course homepage
    And the field "Manual completion of Click to complete activity" matches value "1"
    And the field "Manual completion of Click to complete course" matches value "0"
    When I navigate to "Reset this course" node in "Course administration"
    And I click on "Continue" "button"
    Then I should see "Your progress in this course and completion state have been archived and reset"
    And the field "Manual completion of Click to complete course" matches value "0"

    # Try resetting progress again.
    When I navigate to "Reset this course" node in "Course administration"
    Then I should see "You have not completed this course"
    And I click on "Ok" "button"

  Scenario: I cannot archive my own course progress before starting the course.
    Given I log in as "learner4"
    And I am on "Course 1" course homepage
    And the field "Manual completion of Click to complete activity" matches value "0"
    And the field "Manual completion of Click to complete course" matches value "0"
    When I navigate to "Reset this course" node in "Course administration"
    Then I should see "You have not completed this course"
    And I click on "Ok" "button"

  Scenario: I can archive my own course progress when manually enrolled on a course that happens to be part of a program
    Given I log in as "learner2"
    And I am on "Course 2" course homepage
    When I navigate to "Reset this course" node in "Course administration"
    And I click on "Continue" "button"
    Then I should see "Your progress in this course and completion state have been archived and reset"
    And the field "Manual completion of Click to complete course" matches value "0"

  Scenario: I can archive course progress for specific users.
    Given I log in as "editing_trainer"
    And I am on "Course 1" course homepage
    And I navigate to "Course completion" node in "Course administration > Reports"

    # Can reset completed course completion
    And I follow "Reset course completion for User One"
    And I click on "Continue" "button"
    Then I should see "Progress and completion state have been archived and reset for User One in this course."
    And I should not see "Completed" in the "User One" "table_row"
    And I should see "Completed" in the "User Three" "table_row"

    # Try resetting progress again.
    When I follow "Reset course completion for User One"
    Then I should see "User One"
    And I should see "has not completed this course"
    And I click on "Ok" "button"

    # Can reset in-progress course completion.
    And I follow "Reset course completion for User Three"
    And I click on "Continue" "button"
    Then I should see "Progress and completion state have been archived and reset for User Three in this course."
    And I should not see "Completed" in the "User Three" "table_row"

    # Cannot reset not-started course completion.
    When I follow "Reset course completion for User Four"
    Then I should see "User Four"
    And I should see "has not completed this course"
    And I click on "Ok" "button"

    # Cannot reset program course completion for program-enrolled users.
    When I am on "Course 2" course homepage
    And I navigate to "Course completion" node in "Course administration > Reports"
    Then I should see "User One"
    And I should not see "Reset course completion for User One"

    #Can reset program course completion for manually-enrolled users (not program assigned)
    When I am on "Course 2" course homepage
    And I navigate to "Course completion" node in "Course administration > Reports"
    Then I should see "User Two"
    # Self reset works, but individual reset does not.
    # And I see "Reset course completion for User Two"
