<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Class for migration Users.
 *
 * @package    bi_intellidata
 * @author     IntelliBoard
 * @copyright  2020 intelliboard.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
namespace bi_intellidata\entities\quizquestionanswers;



/**
 * Class for migration Users.
 *
 * @package    bi_intellidata
 * @author     IntelliBoard
 * @copyright  2020 intelliboard.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class qasmigration extends \bi_intellidata\entities\migration {

    public $entity      = '\bi_intellidata\entities\quizquestionanswers\quizquestionattemptsteps';
    public $table       = 'question_attempt_steps';
    public $tablealias  = 'qas';

    /**
     * @param false $count
     * @param null $condition
     * @param array $conditionparams
     * @param null $timestart
     * @return array
     */
    public function get_sql($count = false, $condition = null, $conditionparams = [], $timestart = null) {

        $select = ($count) ?
            "SELECT COUNT(" . $this->tablealias . ".id) as recordscount" :
            "SELECT qas.id, qas.questionattemptid, qas.state, qas.fraction, qas.timecreated";

        $sql = "$select
                FROM {" . $this->table . "} " . $this->tablealias;

        return $this->set_condition($condition, $conditionparams, $sql, []);
    }
}