<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2023 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Angela Kuznetsova <angela.kuznetsova@totara.com>
 * @package bi_intellidata
 */

namespace bi_intellidata\watcher;

use bi_intellidata\helpers\TrackingHelper;
use bi_intellidata\services\tracking_service;

class after_require_login_watcher {
    /**
     * @return void
     */
    public static function allow_tracking(): void {
        if (TrackingHelper::tracking_enabled()) {
            $tracking = new tracking_service();
            $tracking->track();
        }
    }
}