<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2021 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Angela Kuznetsova <angela.kuznetsova@totaralearning.com>
 * @package mod_approval
 */

namespace mod_approval\formatter\application;

use core\webapi\formatter\formatter;
use mod_approval\form_schema\form_schema;

/**
 * Class application_formatter
 *
 * @package mod_approval\formatter\application
 */
class application_form_schema_formatter extends formatter {

    protected function get_map(): array {
        return [
            'form_schema' => function ($value) {
                $schema = form_schema::from_json($value);
                $schema->resolve_lang_strings();

                return $schema->to_json();
            },
            'form_data' => null,
            'file_item_id' => null,
        ];
    }
}
