<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2021 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * @note Automatically cleaned: 2024-09-24
 * @author Chris Snyder <chris.snyder@totaralearning.com>
 * @package mod_approval
 */

$string['access_check_error:application'] = 'Cannot access this application';
$string['access_check_error:application_submission'] = 'Cannot deal with application submission';
$string['access_check_error:assignment'] = 'Cannot access this workflow assignment';
$string['access_check_error:manage_workflows'] = 'Access denied to manage the workflows';
$string['access_check_error:workflow'] = 'Cannot access this workflow';
$string['action'] = 'Action';
$string['actions'] = "Actions";
$string['active'] = 'Active';
$string['activity'] = 'Activity';
$string['activity_name_restore_suffix'] = ' - Copy';
$string['add_action'] = 'Add action';
$string['add_approvers_name'] = 'Add {$a} approver(s):';
$string['add_assignment'] = 'Add assignment';
$string['add_form_header'] = 'Add form';
$string['add_stage'] = 'Add stage';
$string['add_stage_type_label'] = 'What type of task would you like to assign to this stage?';
$string['add_transition'] = 'Add transition';
$string['add_workflow_type_header'] = 'Add workflow type';
$string['adding_approval_level'] = 'Adding approval level...';
$string['admin_category_approval_workflows'] = 'Approval workflows';
$string['all_applications'] = 'All applications';
$string['applicant'] = 'Applicant';
$string['applications_report'] = 'Applications';
$string['applicant_x'] = 'Applicant: {$a}';
$string['application_created_by'] = 'Created by {$a->profileAnchor} on {$a->dateTime}';
$string['application_edit_page_title'] = 'Edit {$a->title} for {$a->applicant}';
$string['application_finished_message'] = 'This application is completed on {$a}, and there are no further actions.';
$string['application_form_response_report_title'] = '{$a->title} - application form responses';
$string['application_id'] = 'Application ID';
$string['application_is_in:'] = 'Application is in:';
$string['application_info'] = 'Application info';
$string['application_last_updated_by'] = 'Submitted by {$a->submitterProfileAnchor} on {$a->submittedDateTime}, last updated by {$a->updaterProfileAnchor} on {$a->updatedDateTime}';
$string['application_own_edit_page_title'] = 'Edit {$a->title}';
$string['application_own_view_page_title'] = '{$a->title}';
$string['application_rejected_message'] = '{$a->profileAnchor} rejected the application';
$string['application_submitted_by'] = 'Submitted by {$a->profileAnchor} on {$a->dateTime}';
$string['application_title'] = 'Application title';
$string['application_type'] = 'Application type';
$string['application_view_page_title'] = '{$a->title} for {$a->applicant}';
$string['application_withdrawn_message'] = '{$a->profileAnchor} withdrew the application';
$string['applications_awaiting_response'] = 'Applications awaiting your response';
$string['applications_empty'] = "You don't currently have any applications";
$string['applications_from_others'] = 'Applications from others';
$string['approval:activate_workflow'] = 'Publish/activate draft workflows';
$string['approval:add_workflow_approval_level'] = 'Add approval levels';
$string['approval:approve_application_any'] = 'Approve applications';
$string['approval:approve_application_applicant'] = 'Approve applications where they are the applicant';
$string['approval:approve_application_owner'] = 'Approve applications where they are the owner';
$string['approval:approve_application_user'] = "Approve user's applications";
$string['approval:approve_pending_application_any'] = 'Approve pending applications';
$string['approval:approve_pending_application_applicant'] = 'Approve pending applications where they are the applicant';
$string['approval:approve_pending_application_owner'] = 'Approve pending applications where they are the owner';
$string['approval:approve_pending_application_user'] = "Approve user's pending applications";
$string['approval:archive_workflow'] = 'Archive active workflows';
$string['approval:attach_file_to_application_any'] = 'Upload files to applications';
$string['approval:attach_file_to_application_applicant'] = 'Upload files to applications where they are the applicant';
$string['approval:attach_file_to_application_owner'] = 'Upload files to applications where they are the owner';
$string['approval:attach_file_to_application_user'] = "Upload files to user's applications";
$string['approval:backdate_application_any'] = 'Backdate applications';
$string['approval:backdate_application_applicant'] = 'Backdate applications where they are the applicant';
$string['approval:backdate_application_owner'] = 'Backdate applications where they are the owner';
$string['approval:backdate_application_user'] = "Backdate user's applications";
$string['approval:backdate_pending_application_any'] = 'Backdate pending applications';
$string['approval:clone_applicant_application_applicant'] = 'Clone self-created applications where they are the applicant';
$string['approval:clone_applicant_application_user'] = "Create user's self-created applications";
$string['approval:clone_application_any'] = 'Clone applications';
$string['approval:clone_application_applicant'] = 'Clone applications where they are the applicant';
$string['approval:clone_application_user'] = "Clone user's applications";
$string['approval:clone_workflow'] = 'Clone existing workflows';
$string['approval:create_activity'] = 'Create approval workflow assignments';
$string['approval:create_application_any'] = 'Create applications';
$string['approval:create_application_applicant'] = 'Create applications where they are the applicant';
$string['approval:create_application_user'] = "Create user's applications";
$string['approval:create_workflow'] = 'Create workflows';
$string['approval:create_workflow_from_template'] = 'Create workflows from templates';
$string['approval:create_workflow_template'] = 'Save workflows as templates';
$string['approval:delete_draft_application_any'] = 'Delete draft applications';
$string['approval:delete_draft_application_applicant'] = 'Delete draft applications where they are the applicant';
$string['approval:delete_draft_application_owner'] = 'Delete draft applications where they are the owner';
$string['approval:delete_draft_application_user'] = "Delete user's draft applications";
$string['approval:delete_workflow'] = 'Delete workflows that are draft, active or archived';
$string['approval:delete_workflow_approval_level'] = 'Delete approval level';
$string['approval:edit_active_workflow'] = 'Edit active workflows';
$string['approval:edit_draft_application_any'] = 'Edit draft applications';
$string['approval:edit_draft_application_applicant'] = 'Edit draft applications where they are the applicant';
$string['approval:edit_draft_application_owner'] = 'Edit draft applications where they are the owner';
$string['approval:edit_draft_application_user'] = "Edit user's draft applications";
$string['approval:edit_draft_workflow'] = 'Edit draft workflows';
$string['approval:edit_first_approval_level_application_any'] = 'Edit first approval level applications';
$string['approval:edit_first_approval_level_application_applicant'] = 'Edit first approval level applications where they are the applicant';
$string['approval:edit_first_approval_level_application_owner'] = 'Edit first approval level applications where they are the owner';
$string['approval:edit_first_approval_level_application_user'] = "Edit user's first approval level applications";
$string['approval:edit_first_approval_level_pending_application_any'] = 'Edit first approval level pending applications';
$string['approval:edit_first_approval_level_pending_application_user'] = "Edit user's first approval level pending applications";
$string['approval:edit_full_application_any'] = 'Edit full form on applications';
$string['approval:edit_full_application_applicant'] = 'Edit full form on applications where they are the applicant';
$string['approval:edit_full_application_owner'] = 'Edit full form on applications where they are the owner';
$string['approval:edit_full_application_user'] = "Edit user's full form on applications";
$string['approval:edit_in_approvals_application_any'] = 'Edit in-approvals applications';
$string['approval:edit_in_approvals_application_applicant'] = 'Edit in-approvals applications where they are the applicant';
$string['approval:edit_in_approvals_application_owner'] = 'Edit in-approvals applications where they are the owner';
$string['approval:edit_in_approvals_application_user'] = "Edit user's in-approvals applications";
$string['approval:edit_in_approvals_pending_application_any'] = 'Edit pending submitted applications';
$string['approval:edit_in_approvals_pending_application_user'] = "Edit user's pending submitted applications";
$string['approval:edit_submitted_application_any'] = 'Edit submitted applications';
$string['approval:edit_submitted_application_applicant'] = 'Edit submitted applications where they are the applicant';
$string['approval:edit_submitted_application_user'] = "Edit user's submitted applications";
$string['approval:edit_unsubmitted_application_any'] = 'Edit unsubmitted applications';
$string['approval:edit_unsubmitted_application_applicant'] = 'Edit unsubmitted applications where they are the applicant';
$string['approval:edit_unsubmitted_application_owner'] = 'Edit unsubmitted applications where they are the owner';
$string['approval:edit_unsubmitted_application_user'] = "Edit user's unsubmitted applications";
$string['approval:edit_without_invalidating_approvals_any'] = 'Edit applications without invalidating exist approvals';
$string['approval:edit_without_invalidating_approvals_applicant'] = 'Edit applications where they are the applicant without invalidating exist approvals';
$string['approval:edit_without_invalidating_approvals_owner'] = 'Edit applications where they are the owner without invalidating exist approvals';
$string['approval:edit_without_invalidating_approvals_user'] = "Edit user's applications without invalidating exist approvals";
$string['approval:edit_workflow'] = 'Edit workflow';
$string['approval:edit_workflow_template'] = 'Edit templates';
$string['approval:manage_activity'] = 'Manage approval workflow assignments';
$string['approval:manage_individual_workflow_approvers'] = 'Manage individual approvers';
$string['approval:manage_lookup_tables'] = 'Manage form plugin lookup tables';
$string['approval:manage_relationship_workflow_approvers'] = 'Manage relationship approvers';
$string['approval:manage_workflow_assignment_overrides'] = 'Manage assignment overrides';
$string['approval:manage_workflow_form_view'] = 'Manage formviews';
$string['approval:manage_workflow_notifications'] = 'Manage notifications';
$string['approval:manage_workflow_stages'] = 'Manage stages (create, edit, reorder, clone, delete)';
$string['approval:manage_workflow_transitions'] = 'Manage transitions';
$string['approval:manage_workflows'] = 'Manage workflows';
$string['approval:move_application_between_workflows'] = 'Move applications to a different workflows';
$string['approval:post_comment_on_application_any'] = 'Post comments on applications';
$string['approval:post_comment_on_application_applicant'] = 'Post comments on applications where they are the applicant';
$string['approval:post_comment_on_application_owner'] = 'Post comments on applications where they are the owner';
$string['approval:post_comment_on_application_user'] = "Post comments on user's applications";
$string['approval:post_comment_on_pending_application_any'] = 'Post comments on pending applications';
$string['approval:post_comment_on_pending_application_user'] = "Post comments on user's pending applications";
$string['approval:reorder_workflow_approval_level'] = 'Change approval level order';
$string['approval:superedit_pending_application_any'] = 'Super-edit pending applications';
$string['approval:view_application_any'] = 'View applications';
$string['approval:view_application_applicant'] = 'View applications where they are the applicant';
$string['approval:view_application_owner'] = 'View applications where they are the owner';
$string['approval:view_application_user'] = "View user's applications";
$string['approval:view_comment_on_application_any'] = 'View comments on applications';
$string['approval:view_comment_on_application_applicant'] = 'View comments on applications where they are the applicant';
$string['approval:view_comment_on_application_owner'] = 'View comments on applications where they are the owner';
$string['approval:view_comment_on_application_user'] = "View comments on user's applications";
$string['approval:view_draft_application_any'] = 'View draft applications';
$string['approval:view_draft_application_applicant'] = 'View draft applications where they are the applicant';
$string['approval:view_draft_application_owner'] = 'View draft applications where they are the owner';
$string['approval:view_draft_application_user'] = "View user's draft applications";
$string['approval:view_draft_in_dashboard_application_any'] = 'View draft applications in the dashboard';
$string['approval:view_draft_in_dashboard_application_applicant'] = 'View draft applications in the dashboard where they are the applicant';
$string['approval:view_draft_in_dashboard_application_user'] = "View user's draft applications in the dashboard";
$string['approval:view_in_dashboard_application_any'] = 'View applications in the dashboard';
$string['approval:view_in_dashboard_application_applicant'] = 'View applications in the dashboard where they are the applicant';
$string['approval:view_in_dashboard_application_user'] = "View user's applications in the dashboard";
$string['approval:view_in_dashboard_pending_application_any'] = 'View pending applications in the dashboard';
$string['approval:view_in_dashboard_pending_application_user'] = "View user's pending applications in the dashboard";
$string['approval:view_manage_activities'] = 'Access the approval workflow assignment management interface';
$string['approval:view_pending_application_any'] = 'View pending applications';
$string['approval:view_pending_application_user'] = "View user's pending applications";
$string['approval:view_workflow_applications_report'] = "View workflow's applications report";
$string['approval:withdraw_in_approvals_application_any'] = 'Withdraw in-approvals applications';
$string['approval:withdraw_in_approvals_application_applicant'] = 'Withdraw in-approvals applications where they are the applicant';
$string['approval:withdraw_in_approvals_application_owner'] = 'Withdraw in-approvals applications where they are the owner';
$string['approval:withdraw_in_approvals_application_user'] = "Withdraw user's in-approvals applications";
$string['approval:withdraw_unsubmitted_application_any'] = 'Withdraw unsubmitted applications';
$string['approval:withdraw_unsubmitted_application_applicant'] = 'Withdraw unsubmitted applications where they are the applicant';
$string['approval:withdraw_unsubmitted_application_owner'] = 'Withdraw unsubmitted applications where they are the owner';
$string['approval:withdraw_unsubmitted_application_user'] = "Withdraw user's unsubmitted applications";
$string['approval_date'] = "Approval date";
$string['approval_level'] = 'Approval level';
$string['approval_level_name'] = "Level name";
$string['approval_level_summary'] = 'Level {$a->level}: {$a->name}. Approver type: {$a->approver_type}.';
$string['approval_override'] = 'Approval override';
$string['approval_override_role_assignment_report_warning_message'] = 'To view the workflow override role assignment report, you must select a <a href="{$a}">workflow</a>.';
$string['approval_step'] = "Approval step";
$string['approvalform_plugins'] = 'Approval form plugins';
$string['approvalform_plugins_list'] = 'Manage approval form plugins';
$string['approvals'] = 'Approvals';
$string['approvals_feature'] = 'Approvals';
$string['approvals_overrides'] = 'Approvals overrides';
$string['approve'] = 'Approve';
$string['approve_enrolments'] = 'Approve enrolments';
$string['approve_enrolments_help'] = 'Users must submit an application and be approved to enrol in a course. Applications and approvals are managed with approval workflows.';
$string['approver_level_approver_type_label'] = '{$a} approver type';
$string['approver_name'] = 'Approver name';
$string['approvers'] = 'Approvers';
$string['approvers_empty'] = 'No approver levels and approvers at this stage';
$string['approvers_report'] = 'Approvers';
$string['approvers_report_title'] = '{$a->title} - Manage approvers report';
$string['approvers_modal_title'] = '{$a} overrides';
$string['archive'] = 'Archive';
$string['archive_overrides_warning_message'] = 'Are you sure you want to archive the approval overrides for this organisation?';
$string['archive_overrides_warning_title'] = 'Archive approval overrides';
$string['archive_workflow_warning_message'] = '<p>Are you sure you want to archive the workflow?</p><p><strong>Once archived</strong>: <ul><li>In-flight applications will continue until completed.</li><li>No new applications can be created</li></ul></p>';
$string['archive_workflow_warning_title'] = 'Archive workflow';
$string['assign'] = 'Assign';
$string['assign_roles'] = 'Assign roles';
$string['assign_roles_where'] = 'Where would you like to assign the role?';
$string['assigned_to'] = 'Assigned to';
$string['assignment_name'] = 'Assignment name';
$string['assignment_type'] = 'Assignment type';
$string['back_to_applications'] = 'Back to applications';
$string['back_to_approvals'] = 'Back to approvals';
$string['back_to_workflow'] = 'Back to {$a}';
$string['back_to_workflows'] = 'Back to all approval workflows';
$string['build_role_maps_now'] = 'Build role map';
$string['button_add'] = 'Add';
$string['button_add_approval_level'] = 'Add approval level';
$string['button_add_override'] = 'Add override';
$string['button_add_workflow_stage'] = 'Add workflow stage';
$string['button_back'] = 'Back';
$string['button_cancel'] = 'Cancel';
$string['button_clone'] = 'Clone';
$string['button_configure_overrides'] = 'Configure approval overrides';
$string['button_create'] = 'Create';
$string['button_new_application'] = 'New application';
$string['button_new_workflow'] = 'New workflow';
$string['button_next'] = 'Next';
$string['cachedef_capability_map'] = 'Dashboard capability map status';
$string['cachedef_role_map'] = 'Dashboard role map status';
$string['cannotdeletecohort'] = "This audience is currently set as an assignment for the approval workflow. To delete this audience, you'll need to change the assignment from the approval workflow first.";
$string['cannotdeleteorganisation'] = "This organisation is currently set as an assignment for the approval workflow. To delete this organisation, you'll need to change the assignment from the approval workflow first.";
$string['cannotdeleteorganisationframework'] = 'At least one organisation in this framework is currently set as an assignment for the approval workflow. To delete this framework, you\'ll need to change the assignment from the approval workflow first.';
$string['cannotdeleteposition'] = "This position is currently set as an assignment for the approval workflow. To delete this position, you'll need to change the assignment from the approval workflow first.";
$string['cannotdeletepositionframework'] = 'At least one position in this framework is currently set as an assignment for the approval workflow. To delete this framework, you\'ll need to change the assignment from the approval workflow first.';
$string['checking_uniqueness'] = 'Checking uniqueness';
$string['choose_form'] = 'Choose a form';
$string['clone'] = 'Clone';
$string['clone_application'] = 'Clone application';
$string['clone_workflow'] = 'Duplicate workflow';
$string['clone_workflow_warning_message'] = 'Would you like to make a copy of \'{$a}\'?';
$string['clone_workflow_warning_title'] = 'Duplicate workflow';
$string['comments'] = 'Comments';
$string['complete_section'] = 'Complete {$a}';
$string['confirm_changes'] = 'Confirm changes';
$string['confirm_changes_detail'] = 'You have made changes to the application that are already approved. Once saved, the changes made have to be approved again. Are you sure you want to save the request?';
$string['confirm_changes_detail_outside_approvals'] = 'You have made changes to the application. Are you sure you want to save the changes?';
$string['confirm_delete_approval_level'] = 'Are you sure you want to delete \'{$a}\'? Once deleted, all associated settings will be erased.';
$string['confirm_publish_workflow_version_blocked_message'] = 'Unable to to publish \'{$a}\' due to the following reasons:';
$string['confirm_publish_workflow_version_warning_message'] = 'Are you sure you want to publish \'{$a}\'?';
$string['confirm_publish_workflow_version_warning_title'] = 'Publish workflow';
$string['confirm_submit'] = 'Submit application';
$string['confirm_submit_detail'] = 'Are you sure you want to submit the application? Once submitted, the application will be visible to others.';
$string['create_new'] = 'Create new application';
$string['create_new_on_behalf'] = 'Create new application on behalf';
$string['create_workflow'] = 'Create workflow';
$string['created_by'] = 'Created by';
$string['created_on'] = 'Created on';
$string['csv_file_delimiter'] = 'CSV file delimiter';
$string['csv_file_delimiter:auto'] = 'Automatic';
$string['csv_file_delimiter:colon'] = 'Colon (:)';
$string['csv_file_delimiter:comma'] = 'Comma (,)';
$string['csv_file_delimiter:semicolon'] = 'Semi-colon (;)';
$string['csv_file_delimiter:tab'] = 'Tab (\t)';
$string['csv_file_encoding'] = 'CSV file encoding';
$string['csv_text_file'] = 'CSV text file';
$string['current_approval_level_approvers'] = '{$a} approvers';
$string['dashboard_title'] = 'Applications';
$string['date_error_expiration'] = 'The expiration date should be a future date.';
$string['date_error_training_end'] = 'The training end date cannot be before the training start date.';
$string['date_error_training_start'] = 'The training start date should be a future date.';
$string['date_error_training_start_after_end'] = 'The training start date cannot be after the training end date.';
$string['default'] = 'Default';
$string['default_workflow_finished_stage_name'] = 'End';
$string['default_workflow_start_stage_name'] = 'Start';
$string['delete'] = 'Delete';
$string['delete_approval_level'] = 'Delete approval level';
$string['delete_form'] = 'Delete form';
$string['delete_form_warning'] = 'Are you sure you want to delete \'{$a}\' form?';
$string['delete_stage'] = 'Delete stage';
$string['delete_stage_warning_message'] = 'Are you sure you want to delete \'{$a}\'? Once deleted, all the associated settings will be erased, and it might affect the flow of this workflow.';
$string['delete_warning_message_1'] = 'Are you sure you want to delete the application \'{$a}\'?';
$string['delete_warning_message_2'] = 'This will permanently delete all contents associated with this application and this cannot be restored.';
$string['delete_warning_title'] = 'Delete application';
$string['delete_workflow_type'] = 'Delete workflow type';
$string['delete_workflow_type_warning'] = 'Are you sure you want to delete \'{$a}\' workflow type?';
$string['delete_workflow_warning_message_1'] = 'Are you sure you want to delete the workflow \'{$a}\'?';
$string['delete_workflow_warning_message_applications'] = 'The workflow and {$a->applications_count} related applications will be deleted, including all draft, pending, archived or completed applications.';
$string['delete_workflow_warning_message_assignments'] = 'The workflow, {$a->assignment_overrides_count} assignment overrides, and {$a->applications_count} related applications will be deleted, including all draft, pending, archived or completed applications.';
$string['delete_workflow_warning_title'] = 'Delete workflow';
$string['deleteconfirm'] = 'Delete';
$string['deleting_approval_level'] = 'Deleting approval level...';
$string['disable_plugin'] = 'Disable {$a}';
$string['edit'] = 'Edit';
$string['edit_override_approvers'] = 'Edit override approvers';
$string['edit_transition_title'] = 'Edit default transition for \'{$a}\'';
$string['edit_x'] = 'Edit {$a}';
$string['email'] = 'Email';
$string['embedded_application_form_responses_export'] = 'Application form responses export';
$string['embedded_override_role_assignment'] = 'Override role assignment';
$string['empty_select_option_hint'] = 'Select...';
$string['enable_plugin'] = 'Enable {$a}';
$string['enableapproval_workflows'] = 'Enable Approval Workflows';
$string['enableapproval_workflows_desc'] = 'When enabled, Approval Workflows features will be accessible.';
$string['entity_value_error'] = 'Invalid value detected';
$string['error:add_user'] = 'You must add a user to the override';
$string['error:approve_application'] = 'Could not approve the application';
$string['error:archive_overrides'] = 'Could not archive the overrides';
$string['error:archive_workflow'] = 'Could not archive the workflow';
$string['error:cannot_create_application_on_behalf'] = 'It is not possible for you to create an application for this person.';
$string['error:clone_application'] = 'Could not clone the application';
$string['error:clone_workflow'] = 'Could not clone the workflow';
$string['error:create_application'] = 'Could not create application';
$string['error:csv_role_missing'] = 'The system role is missing, please check \'Define roles\' under site administration';
$string['error:csv_workflow_missing'] = 'Unable to process the assignments due to error: Can not find workflow record in database';
$string['error:delete_application'] = 'Could not delete application';
$string['error:delete_workflow'] = 'Could not delete workflow';
$string['error:edit_application'] = 'You do not have permission to edit this application';
$string['error:edit_workflow_details'] = 'Could not save changes';
$string['error:form_inuse'] = 'Form is used by one or more workflows and cannot be deleted';
$string['error:form_name_value_too_long'] = 'Form title can only be upto {$a} characters in length';
$string['error:generic'] = 'An error occurred';
$string['error:missing_workflow_message'] = 'Missing workflow';
$string['error:no_plugins_enabled'] = 'Form plugin is disabled.';
$string['error:publish_workflow_version'] = 'Could not publish the workflow';
$string['error:reject_application'] = 'Could not reject the application';
$string['error:save_application'] = 'Could not save the application';
$string['error:submit_application'] = 'Could not submit the application';
$string['error:unarchive_workflow'] = 'Could not unarchive the workflow';
$string['error:view_application'] = 'You do not have permission to view this application';
$string['error:view_workflow'] = 'You do not have permission to view this workflow';
$string['error:withdraw_application'] = 'Could not withdraw the application';
$string['error:workflow_id_error'] = 'Something went wrong. Please try again later.';
$string['error:workflow_id_not_unique'] = 'You should enter a unique ID.';
$string['error:workflow_not_available_message'] = 'Selected workflow is not available';
$string['error:workflow_not_core_enrol'] = 'Selected workflow is not suitable for enrolment approval';
$string['error:workflow_type_inuse'] = 'Workflow type is assigned to one or more workflows and cannot be deleted';
$string['error:workflow_type_name_value_too_long'] = 'Workflow type name can only be upto {$a} characters in length';
$string['event_all_approvals_granted'] = 'Application fully-approved at stage';
$string['event_application_completed'] = 'Application completed';
$string['event_application_deleted'] = 'Application deleted';
$string['event_approvals_invalidated'] = 'Existing approvals invalidated due to rejection or withdrawal';
$string['event_form_version_updated'] = 'Form version updated';
$string['event_form_version_updated_description'] = "The user with id '{\$a->userid}' updated the form_version with id '{\$a->form_version_id}', which belongs to the '{\$a->plugin_name}' form with id '{\$a->form_id}', to version '{\$a->version}'";
$string['event_level_approved'] = 'Application approved';
$string['event_level_rejected'] = 'Application rejected';
$string['event_level_started'] = 'Application entered new level';
$string['event_stage_all_approved'] = 'Application fully-approved at stage';
$string['event_stage_ended'] = 'Application ended current stage';
$string['event_stage_started'] = 'Application entered new stage';
$string['event_stage_submitted'] = 'Application submitted';
$string['event_stage_withdrawn'] = 'Application withdrawn';
$string['event_workflow_archived'] = 'Workflow archived';
$string['event_workflow_archived_description'] = "The user with id '{\$a->userid}' has archived the workflow version with id '{\$a->workflow_version_id}' on the workflow with id '{\$a->workflow_id}'";
$string['event_workflow_assignment_archived'] = 'Workflow assignment archived';
$string['event_workflow_assignment_archived_description'] = "The user with id '{\$a->userid}' has archived the assignment with id '{\$a->assignment_id}' on the workflow with id '{\$a->workflow_id}'";
$string['event_workflow_assignment_created'] = 'Workflow assignment created';
$string['event_workflow_assignment_created_description'] = "The user with id '{\$a->userid}' has created an assignment with id '{\$a->assignment_id}' on the workflow with id '{\$a->workflow_id}'";
$string['event_workflow_assignment_deleted'] = 'Workflow assignment deleted';
$string['event_workflow_assignment_deleted_description'] = "The user with id '{\$a->userid}' has deleted the assignment with id '{\$a->assignment_id}' on the workflow with id '{\$a->workflow_id}'";
$string['event_workflow_cloned'] = 'Workflow cloned';
$string['event_workflow_cloned_description'] = "The user with id '{\$a->userid}' has cloned the workflow with id '{\$a->old_workflow_id}' into a new workflow with id '{\$a->new_workflow_id}'";
$string['event_workflow_created'] = 'Workflow created';
$string['event_workflow_created_description'] = "The user with id '{\$a->userid}' has created an approval workflow with id '{\$a->workflow_id}'";
$string['event_workflow_deleted'] = 'Workflow deleted';
$string['event_workflow_deleted_description'] = "The user with id '{\$a->userid}' deleted the workflow with id '{\$a->workflow_id}'";
$string['event_workflow_edited'] = 'Workflow details edited';
$string['event_workflow_edited_description'] = "The user with id '{\$a->userid}' edited the details of the workflow with id '{\$a->workflow_id}'";
$string['event_workflow_stage_approval_level_created'] = 'Workflow stage approval level created';
$string['event_workflow_stage_approval_level_created_description'] = "The user with id '{\$a->userid}' created an approval level with id '{\$a->approval_level_id}' in the workflow stage with id '{\$a->stage_id}' on the workflow version with id '{\$a->workflow_version_id}'";
$string['event_workflow_stage_approval_level_deleted'] = 'Workflow stage approval level deleted';
$string['event_workflow_stage_approval_level_deleted_description'] = "The user with id '{\$a->userid}' deleted the approval level with id '{\$a->approval_level_id}' in the workflow stage with id '{\$a->stage_id}' on the workflow version with id '{\$a->workflow_version_id}'";
$string['event_workflow_stage_approval_level_reordered_description'] = "The user with id '{\$a->userid}' reordered the approval levels in the workflow stage with id '{\$a->stage_id}' on the workflow version with id '{\$a->workflow_version_id}'";
$string['event_workflow_stage_approval_levels_reordered'] = 'Workflow stage approval levels reordered';
$string['event_workflow_stage_assignment_approvers_for_level_changed'] = 'Approvers on assignment changed';
$string['event_workflow_stage_assignment_approvers_for_level_changed_description'] = "The user with id '{\$a->userid}' has updated the approvers for assignment with id '{\$a->assignment_id}' on the approval level with id '{\$a->approval_level_id}'";
$string['event_workflow_stage_created'] = 'Workflow stage created';
$string['event_workflow_stage_created_description'] = "The user with id '{\$a->userid}' created the stage with id '{\$a->stage_id}' on the workflow version with id '{\$a->workflow_version_id}'";
$string['event_workflow_stage_deleted'] = 'Workflow stage deleted';
$string['event_workflow_stage_deleted_description'] = "The user with id '{\$a->userid}' deleted the stage with id '{\$a->stage_id}' on the workflow version with id '{\$a->workflow_version_id}'";
$string['event_workflow_stage_edited'] = 'Workflow stage name changed';
$string['event_workflow_stage_edited_description'] = "The user with id '{\$a->userid}' changed the name of the stage with id '{\$a->stage_id}'";
$string['event_workflow_stage_form_views_updated'] = 'Workflow stage formviews updated';
$string['event_workflow_stage_form_views_updated_description'] = "The user with id '{\$a->userid}' updated the formviews of the stage with id '{\$a->stage_id}' on the workflow version with id '{\$a->workflow_version_id}'";
$string['event_workflow_version_archived'] = 'Workflow version archived';
$string['event_workflow_version_archived_description'] = "The user with id '{\$a->userid}' has archived the workflow version with id '{\$a->workflow_version_id}' on the workflow with id '{\$a->workflow_id}'";
$string['event_workflow_version_published'] = 'Workflow version published';
$string['event_workflow_version_published_description'] = "The user with id '{\$a->userid}' published the workflow version with id '{\$a->workflow_version_id}' on the workflow with id '{\$a->workflow_id}'";
$string['event_workflow_version_unarchived'] = 'Workflow version unarchived';
$string['event_workflow_version_unarchived_description'] = "The user with id '{\$a->userid}' unarchived the workflow version with id '{\$a->workflow_version_id}' on the workflow with id '{\$a->workflow_id}'";
$string['field_visibility_editable'] = 'Editable';
$string['field_visibility_editable_and_required'] = 'Editable and required';
$string['field_visibility_hidden'] = 'Hidden';
$string['field_visibility_options_for_x_name_value'] = 'Visibility options for {$a->name}, {$a->value} selected';
$string['field_visibility_read_only'] = 'Read only';
$string['field_visibility_visible'] = 'Visible';
$string['filter_active'] = 'Active';
$string['filter_all'] = 'All';
$string['filter_applications'] = 'Filter applications';
$string['filter_approved'] = 'Approved';
$string['filter_audience'] = 'Audience';
$string['filter_draft'] = 'Draft';
$string['filter_finished'] = 'Completed';
$string['filter_in_progress'] = 'In progress';
$string['filter_na'] = 'N/A';
$string['filter_organization'] = 'Organisation';
$string['filter_overrides'] = 'Filter overrides';
$string['filter_pending'] = 'Pending';
$string['filter_position'] = 'Position';
$string['filter_rejected'] = 'Rejected';
$string['filter_withdrawn'] = 'Withdrawn';
$string['for_yourself'] = 'For yourself';
$string['form'] = 'Form';
$string['form_created'] = 'Created';
$string['form_instances'] = 'Forms';
$string['form_name'] = 'Form title';
$string['form_name_label'] = 'Form title';
$string['form_plugin_name'] = 'Approval form plugin';
$string['form_plugin_name_label'] = 'Form plugin';
$string['form_plugin_schema_version_label'] = 'Plugin schema version';
$string['form_preview'] = 'Form preview';
$string['form_sections'] = 'Form sections';
$string['form_title_label'] = 'Form title';
$string['form_validated_message'] = 'Form validated';
$string['form_verion_form_version_label'] = 'Form schema version';
$string['form_version_updated'] = 'Form version updated';
$string['formviews'] = 'Formviews';
$string['hidden'] = 'Hidden';
$string['individuals_for_approver_level_taglist'] = 'Individuals for {$a}';
$string['info:up_to_date_with_plugin'] = 'Form schema version matches plugin schema version, all up to date';
$string['information_not_available_reason'] = "If you don’t see some applications, please try again later. It may take some time for some of the applications to be ready.";
$string['information_not_available_reason_build_in_queue'] = 'Building the role maps, this might take some time.';
$string['information_not_available_reason_for_admin'] = 'Some applications might be missing. The applications won’t be visible until the next role map build at {$a}.';
$string['inherited'] = 'Inherited';
$string['inherited_from'] = 'Inherited from';
$string['interactions_feature'] = 'Interactions';
$string['invalid_application'] = 'Invalid application';
$string['invalid_assignment'] = 'Invalid assignment';
$string['invalid_workflow'] = 'Invalid workflow';
$string['item_selected_x'] = 'Item selected: {$a}';
$string['keep_approvals'] = 'Save the changes without resetting approval';
$string['last_modified'] = 'Last modified';
$string['level_1'] = 'Level 1';
$string['level_approvers'] = '{$a} approvers';
$string['level_x'] = 'Level {$a}';
$string['loading'] = 'Loading';
$string['manage_approval_forms'] = 'Manage approval forms';
$string['manage_approval_workflows'] = 'Manage approval workflows';
$string['manage_approval_workflows_types'] = 'Manage workflow types';
$string['menu_application'] = 'Applications';
$string['menu_root'] = 'Approval';
$string['menu_title_workflow_dashboard'] = 'Approval Workflows';
$string['model_application_action_status_approvals_reset'] = 'Approvals reset';
$string['model_application_action_status_approved'] = 'Approved';
$string['model_application_action_status_edited'] = 'Edited';
$string['model_application_action_status_rejected'] = 'Rejected';
$string['model_application_action_status_submitted'] = 'Submitted';
$string['model_application_action_status_withdrawn'] = 'Withdrawn';
$string['model_application_activity_type_approvals_reset'] = 'Approval progress reset';
$string['model_application_activity_type_approvals_reset_desc'] = '{$a->stage} approval progress reset';
$string['model_application_activity_type_comment_created'] = 'Comment created';
$string['model_application_activity_type_comment_created_desc'] = '{$a->user} commented on the application';
$string['model_application_activity_type_comment_deleted'] = 'Comment deleted';
$string['model_application_activity_type_comment_deleted_desc'] = '{$a->user} deleted a comment';
$string['model_application_activity_type_comment_replied'] = 'Comment replied';
$string['model_application_activity_type_comment_replied_desc'] = '{$a->user} replied to a comment';
$string['model_application_activity_type_comment_updated'] = 'Comment updated';
$string['model_application_activity_type_comment_updated_desc'] = '{$a->user} edited a comment';
$string['model_application_activity_type_creation'] = 'Application created';
$string['model_application_activity_type_creation_desc_clone'] = '{$a->user} created application from {$a->source}';
$string['model_application_activity_type_creation_desc_clone_deleted'] = '{$a->user} created application from (deleted application)';
$string['model_application_activity_type_creation_desc_new'] = '{$a->user} created application';
$string['model_application_activity_type_edited'] = 'Edited';
$string['model_application_activity_type_edited_desc'] = '{$a->user} edited the application';
$string['model_application_activity_type_finished'] = 'Completed';
$string['model_application_activity_type_finished_desc'] = 'Application completed';
$string['model_application_activity_type_level_approved'] = 'Approved';
$string['model_application_activity_type_level_approved_desc'] = '{$a->user} approved the application';
$string['model_application_activity_type_level_ended'] = 'Level completed';
$string['model_application_activity_type_level_ended_desc'] = '{$a->stage} {$a->level} completed';
$string['model_application_activity_type_level_rejected'] = 'Rejected';
$string['model_application_activity_type_level_rejected_desc'] = '{$a->user} rejected the application';
$string['model_application_activity_type_level_started'] = 'Level started';
$string['model_application_activity_type_level_started_desc'] = 'Awaiting {$a->level} approval';
$string['model_application_activity_type_notification_sent'] = 'Notification sent';
$string['model_application_activity_type_notification_sent_desc'] = '{$a->resolver_title} notification sent to {$a->recipient_name}';
$string['model_application_activity_type_stage_all_approved'] = 'All approvals granted';
$string['model_application_activity_type_stage_all_approved_desc'] = '{$a->stage} all approvals granted';
$string['model_application_activity_type_stage_ended'] = 'Stage completed';
$string['model_application_activity_type_stage_ended_desc'] = '{$a->stage} completed';
$string['model_application_activity_type_stage_started'] = 'Stage started';
$string['model_application_activity_type_stage_started_desc'] = 'Application in {$a->stage}';
$string['model_application_activity_type_stage_submitted'] = 'Form submitted';
$string['model_application_activity_type_stage_submitted_desc'] = '{$a->user} submitted the application';
$string['model_application_activity_type_uploaded'] = 'File uploaded';
$string['model_application_activity_type_uploaded_desc'] = '{$a->user} uploaded a file';
$string['model_application_activity_type_withdrawn'] = 'Withdrawn';
$string['model_application_activity_type_withdrawn_desc'] = '{$a->user} withdrew the application';
$string['model_assignment_approver_type_relationship'] = 'Relationship';
$string['model_assignment_approver_type_user'] = 'Individual';
$string['model_assignment_type_cohort'] = 'Audience';
$string['model_assignment_type_context'] = 'Context';
$string['model_assignment_type_organisation'] = 'Organisation';
$string['model_assignment_id'] = 'Assignment ID';
$string['model_assignment_name'] = 'Assignment name';
$string['model_assignment_type'] = 'Assignment type';
$string['model_assignment_type_position'] = 'Position';
$string['model_state_error'] = 'Generic failure: {$a}';
$string['model_status_active'] = 'Active';
$string['model_status_archived'] = 'Archived';
$string['model_status_draft'] = 'Draft';
$string['modulename'] = 'Approval workflow';
$string['modulenameplural'] = 'Approval workflows';
$string['more_actions'] = 'More actions';
$string['more_actions_for_stage_x'] = 'More actions for stage \'{$a}\'';
$string['move_to'] = 'Move to';
$string['move_x'] = 'Move {$a}';
$string['next_stage'] = 'Next';
$string['no_applications'] = 'You don\'t currently have any applications.';
$string['no_applications_from_others'] = 'You don\'t currently have any applications from others.';
$string['no_applications_match'] = 'No applications match your search.';
$string['no_approvals_match'] = 'There are no approval levels matching your search.';
$string['no_approvers'] = 'There are no approver levels and approvers in this stage.';
$string['no_approvers_on_level'] = 'There are no {$a} approvers.';
$string['no_forms_match'] = 'No forms match your search.';
$string['no_item_selected'] = 'No item selected';
$string['no_workflows_match'] = 'No workflows match your search.';
$string['notification:capability_maps_regenerated'] = 'Dashboard permissions refeshed';
$string['notification:level_approved_for_applicant_body'] = 'Your [application:type] Application ID: [application:id_number] has been approved at [approval_level:name] in [workflow_stage:name]. Go to [recipient:application_dashboard] if you want to view the status of your [application:type].';
$string['notification:level_approved_for_applicant_subject'] = 'Application has been approved at [approval_level:name]';
$string['notification:level_approved_for_applicant_title'] = 'Application approved (at Level)';
$string['notification:level_approved_resolver_title'] = 'Level approved';
$string['notification:level_base_all_levels'] = 'All levels';
$string['notification:level_base_approval_level'] = 'Approval level';
$string['notification:level_rejected_for_applicant_body'] = 'Your [application:type] Application ID: [application:id_number] has been denied at [approval_level:name] in [workflow_stage:name]. Go to [recipient:application_dashboard] if you want to view the status of your [application:type].';
$string['notification:level_rejected_for_applicant_subject'] = 'Application has been denied at [approval_level:name]';
$string['notification:level_rejected_for_applicant_title'] = 'Application denied (at Level)';
$string['notification:level_rejected_resolver_title'] = 'Level denied';
$string['notification:level_started_for_applicant_body'] = 'Your [application:type] Application ID: [application:id_number] is awaiting approval. Go to [recipient:application_dashboard] if you want to view the status of your [application:type].';
$string['notification:level_started_for_applicant_subject'] = 'Application is awaiting [approval_level:name]';
$string['notification:level_started_for_applicant_title'] = 'Application awaiting approval (at Level)';
$string['notification:level_started_for_approvers_body'] = 'There is a [application:type] Application ID: [application:id_number] awaiting your approval. Go to [recipient:approval_actions] if you want to view the status of your [application:type].';
$string['notification:level_started_for_approvers_subject'] = 'Application is awaiting [approval_level:name]';
$string['notification:level_started_for_approvers_title'] = 'Application awaiting approval (at Level)';
$string['notification:level_started_resolver_title'] = 'At start of level';
$string['notification:placeholder_group_applicant'] = 'Applicant {$a}';
$string['notification:placeholder_group_applicant_organisation'] = 'Applicant Organisation {$a}';
$string['notification:placeholder_group_application'] = 'Application {$a}';
$string['notification:placeholder_group_comment'] = 'Comment {$a}';
$string['notification:placeholder_group_level_approved'] = 'Level Approved {$a}';
$string['notification:placeholder_group_level_rejected'] = 'Level Rejected {$a}';
$string['notification:placeholder_group_level_started'] = 'Level Started {$a}';
$string['notification:placeholder_group_recipient'] = 'Recipient {$a}';
$string['notification:placeholder_group_stage_all_approved'] = 'Approved Stage {$a}';
$string['notification:placeholder_group_stage_ended'] = 'Stage Ended {$a}';
$string['notification:placeholder_group_stage_related'] = 'Related Stage {$a}';
$string['notification:placeholder_group_stage_started'] = 'Stage Started {$a}';
$string['notification:placeholder_group_stage_submitted'] = 'Submitted Stage {$a}';
$string['notification:placeholder_group_stage_withdrawn'] = 'Withdrawn Stage {$a}';
$string['notification:recipient_all_approvers'] = 'All approvers';
$string['notification:recipient_applicant'] = 'Applicant';
$string['notification:recipient_level_approvers'] = 'Level approvers';
$string['notification:role_maps_regenerated'] = 'Dashboard role maps regenerated';
$string['notification:stage_all_approved_for_applicant_body'] = 'Your [application:type] Application ID: [application:id_number] has been fully approved in [workflow_stage:name]. Go to [recipient:application_dashboard] if you want to view the status of your [application:type].';
$string['notification:stage_all_approved_for_applicant_subject'] = 'Application has been fully approved';
$string['notification:stage_all_approved_for_applicant_title'] = 'Application has been fully approved';
$string['notification:stage_all_approved_resolver_title'] = 'Stage fully approved';
$string['notification:stage_comment_created_resolver_title'] = 'Comment added';
$string['notification:stage_comment_updated_resolver_title'] = 'Comment updated';
$string['notification:stage_ended_for_applicant_body'] = 'Your [application:type] Application ID: [application:id_number] has completed [workflow_stage:name]. Go to [recipient:application_dashboard] if you want to view the status of your [application:type].';
$string['notification:stage_ended_for_applicant_subject'] = 'Application has completed [workflow_stage:name]';
$string['notification:stage_ended_for_applicant_title'] = 'Application has completed [workflow_stage:name]';
$string['notification:stage_ended_resolver_title'] = 'At end of stage';
$string['notification:stage_started_for_applicant_body'] = 'Your [application:type] Application ID: [application:id_number] has entered [workflow_stage:name]. Go to [recipient:application_dashboard] if you want to view the status of your [application:type].';
$string['notification:stage_started_for_applicant_subject'] = 'Application has entered [workflow_stage:name]';
$string['notification:stage_started_for_applicant_title'] = 'Application has entered [workflow_stage:name]';
$string['notification:stage_started_resolver_title'] = 'At start of stage';
$string['notification:stage_submitted_for_applicant_body'] = 'Your [application:type] Application ID: [application:id_number] has been submitted for supervisor approval. Go to [recipient:application_dashboard] if you want to view the status of your [application:type].';
$string['notification:stage_submitted_for_applicant_subject'] = 'Application has been submitted';
$string['notification:stage_submitted_for_applicant_title'] = 'Application has been submitted';
$string['notification:stage_submitted_resolver_title'] = 'Application submitted';
$string['notification:stage_withdrawn_for_applicant_body'] = 'Your [application:type] Application ID: [application:id_number] has been withdrawn. Go to [recipient:application_dashboard] if you want to view the status of your [application:type].';
$string['notification:stage_withdrawn_for_applicant_subject'] = 'Application has been withdrawn';
$string['notification:stage_withdrawn_for_applicant_title'] = 'Application has been withdrawn';
$string['notification:stage_withdrawn_resolver_title'] = 'Application withdrawn';
$string['notification:workflow_complete_resolver_title'] = 'Workflow Complete';
$string['notification_placeholder:application_current_approval_level'] = 'Approval Level';
$string['notification_placeholder:application_current_stage_name'] = 'Stage Name';
$string['notification_placeholder:application_id_number'] = 'Application ID Number';
$string['notification_placeholder:application_title'] = 'Title';
$string['notification_placeholder:application_title_linked'] = 'Title (with link)';
$string['notification_placeholder:application_type'] = 'Application Type';
$string['notification_placeholder:approval_level_name'] = 'Name';
$string['notification_placeholder:recipient_application_dashboard'] = 'Your Application Dashboard';
$string['notification_placeholder:recipient_application_dashboard_label'] = 'Link to Applications Dashboard';
$string['notification_placeholder:recipient_approval_actions'] = 'Your Pending Approvals Dashboard';
$string['notification_placeholder:recipient_approval_actions_label'] = 'Link to Pending Approvals Dashboard';
$string['notification_placeholder:workflow_stage_name'] = 'Name';
$string['notifications'] = 'Notifications';
$string['no_approvers_left'] = 'There are no approvers in this level.';
$string['notifications_title'] = 'Stage {$a} - Notifications';
$string['on_approved'] = 'On approved';
$string['on_behalf'] = 'On behalf';
$string['on_rejected'] = 'On rejected';
$string['on_reset'] = 'On reset';
$string['on_submitted'] = 'On submitted';
$string['on_withdrawn'] = 'On withdrawn';
$string['on_x'] = 'on {$a}';
$string['one_application_awaiting_response'] = 'There is {$a} application awaiting your response';
$string['one_user'] = '1 User';
$string['overall_progress'] = 'Overall progress';
$string['overall_progress_draft'] = 'Draft';
$string['overall_progress_finished'] = 'Completed';
$string['overall_progress_in_progress'] = 'In progress';
$string['overall_progress_rejected'] = 'Rejected';
$string['overall_progress_withdrawn'] = 'Withdrawn';
$string['override'] = 'Override';
$string['override_x'] = 'Override {$a}';
$string['pending'] = 'Pending:';
$string['pluginadministration'] = 'Approval workflow administration';
$string['pluginname'] = 'Approval workflow';
$string['plugintype_approvalform'] = 'Approval form plugins';
$string['preview_form'] = 'Preview form';
$string['previous_stage'] = 'Previous';
$string['print'] = 'Print';
$string['print_preview'] = 'Print preview';
$string['publish'] = 'Publish';
$string['query_results_none'] = 'Your query returned no items.';
$string['refresh_form_header'] = 'Refresh form schema from plugin';
$string['refresh_form_schema'] = 'Refresh form schema from plugin';
$string['refresh_form_schema_confirm'] = 'Are you sure you want to refresh the schema for \'{$a}\' form?';
$string['refresh_form_schema_warning'] = 'This form is used in one or more active or archived workflow definitions. New form keys will not be available for use in those workflows. Missing form keys may appear to cause data loss.';
$string['reject'] = 'Reject';
$string['reject_application'] = 'Reject application';
$string['rejection_reason'] = 'Please specify the reason for rejecting the application';
$string['relationships_for_approver_level_taglist'] = 'Relationships for {$a}';
$string['remove_interaction'] = 'Remove interaction';
$string['rename_approval_level'] = 'Rename approval level';
$string['rename_stage'] = 'Rename stage';
$string['reorder_levels'] = 'Re-order levels';
$string['request_complete_message'] = 'This application is completed on {$a}, and there are no further actions.';
$string['reset'] = 'Reset';
$string['respond'] = 'Respond';
$string['respond_to_application'] = 'Respond to application {$a->title} for {$a->user}';
$string['resubmit_application'] = 'Resubmit your application';
$string['save'] = 'Save';
$string['save_draft'] = 'Save as draft';
$string['schema_version'] = 'Form schema version';
$string['search_by_applicant'] = 'Search by applicant';
$string['search_by_form_name'] = 'Search by form name.';
$string['search_by_organisation'] = 'Search by organisation';
$string['search_by_workflow_name'] = 'Search by workflow name';
$string['section_title'] = '{$a->line} - {$a->label}';
$string['select_application_type'] = 'Select an application type';
$string['select_assignment'] = 'Select assignment';
$string['select_job_assignment'] = 'Select job assignment';
$string['select_person'] = 'Select a person';
$string['select_transition'] = 'Select transition';
$string['setting_check'] = 'Check me';
$string['setting_check_help'] = 'Check me for testing.';
$string['settings'] = 'Approval workflow settings';
$string['sort_by'] = 'Sort by';
$string['sort_by_org_name_asc'] = 'Assignment name (A-Z)';
$string['sort_by_org_name_desc'] = 'Assignment name (Z-A)';
$string['stage_name'] = 'Stage name';
$string['stage_number_name'] = 'Stage {$a->ordinal_number} - {$a->name}';
$string['stage_number_type'] = 'Stage {$a->ordinal_number} - {$a->type}';
$string['stage_rename'] = 'Rename';
$string['stage_start'] = 'Start of stage';
$string['stage_type_approvals'] = 'Approver';
$string['stage_type_finished'] = 'End';
$string['stage_type_form_submission'] = 'Applicant';
$string['stage_type_waiting'] = 'Waiting';
$string['stage_x'] = 'Stage {$a}';
$string['status'] = 'Status';
$string['status:'] = 'Status:';
$string['status_pending_level'] = 'Pending {$a}';
$string['status_pending_stage'] = 'Pending {$a}';
$string['submit'] = 'Submit';
$string['submitted_by_x'] = 'Submitted by {$a}';
$string['submitted_on'] = 'Submitted on';
$string['submitted_on_x'] = 'Submitted on {$a}';
$string['success:approve_application'] = 'Application approved successfully';
$string['success:archive_overrides'] = 'Overrides archived successfully';
$string['success:archive_workflow'] = 'Workflow archived successfully';
$string['success:clone_application'] = 'Application cloned successfully';
$string['success:clone_workflow'] = 'Workflow cloned successfully';
$string['success:create_draft_application'] = 'Draft application created successfully';
$string['success:create_override'] = 'Override created successfully. You may edit the approvers.';
$string['success:create_workflow'] = 'Workflow created successfully';
$string['success:delete_application'] = 'Application deleted successfully';
$string['success:delete_form'] = 'Form deleted successfully';
$string['success:delete_workflow'] = 'Workflow deleted successfully';
$string['success:delete_workflow_type'] = 'Workflow type deleted successfully';
$string['success:edit_workflow'] = 'Workflow updated successfully';
$string['success:publish_workflow_version'] = 'Workflow published successfully';
$string['success:reject_application'] = 'Application rejected successfully';
$string['success:rename_stage'] = 'Stage renamed successfully';
$string['success:role_map_scheduled_now'] = 'The role map task will run shortly';
$string['success:save_application'] = 'Application saved successfully';
$string['success:save_overrides'] = 'Overrides saved successfully';
$string['success:save_workflow'] = 'Successfully saved';
$string['success:submit_application'] = 'Application submitted successfully';
$string['success:unarchive_workflow'] = 'Workflow unarchived successfully';
$string['success:update_default_transition'] = 'Transition updated successfully';
$string['success:update_form'] = 'Form updated successfully';
$string['success:update_workflow_type'] = 'Workflow type updated successfully';
$string['success:withdraw_application'] = 'Application withdrawn successfully';
$string['task_role_map_regenerate_all'] = 'Regenerate role capability maps to optimise application dashboard loading';
$string['task_role_map_regenerate_all_not_found'] = 'The \'Regenerate role capability maps\' task is not configured on this site';
$string['timecreated'] = "Created at";
$string['timemodified'] = "Modified at";
$string['total_of'] = 'Showing {$a->count} of {$a->total} applications';
$string['total_of_n'] = 'Showing {$a->count} of {$a->total}';
$string['total_of_workflows'] = 'Showing {$a->count} of {$a->total} workflows';
$string['transition'] = 'Transition';
$string['transition_type'] = 'Transition type';
$string['type'] = 'Type';
$string['unarchive'] = 'Unarchive';
$string['unarchive_workflow_warning_message'] = 'Are you sure you want to unarchive the workflow? Once unarchived users will be able to create new applications in this workflow.';
$string['unarchive_workflow_warning_title'] = 'Unarchive workflow';
$string['unrecoverable_application_error_message'] = 'An unexpected error occurred while attempting to contact the server. Please refresh the page to continue.';
$string['unrecoverable_application_error_title'] = 'System Error';
$string['unsaved_changes_warning'] = 'Your unsaved changes will be lost.';
$string['untitled_cohort'] = 'Untitled audience';
$string['untitled_organisation'] = 'Untitled organisation';
$string['untitled_position'] = 'Untitled position';
$string['untitled_x'] = 'Untitled {$a}';
$string['update_form_header'] = 'Update form';
$string['update_workflow_type'] = 'Update workflow type';
$string['update_workflow_type_header'] = 'Update workflow type';
$string['upload_assignment_overrides'] = '{$a->name} - upload assignment overrides';
$string['upload_assignment_overrides_no_data'] = 'No valid data found in the CSV content, please double check your CSV file for a valid data. Back to <a href="{$a->url}">Upload assignment overrides</a>';
$string['upload_csv'] = 'Upload CSV';
$string['upload_csv_file_button'] = 'Import';
$string['upload_csv_info'] = 'Prepare a CSV file with a heading row and one or more data rows';
$string['upload_csv_info_help'] = 'All rows must have the following columns. The values for columns marked **\'optional\'** may be blank, but all columns must be included in each row.

- **\'idnumber\'** - Organisation idnumber that approvers are being assigned to
- **\'manager\'** - (optional) Username of the workflow manager for this organisation. Leave blank if no workflow manager for this specific organisation.
- **\'stage_1_level_1\'** - (optional) Username of the approver at this level for this organisation, if it is different from the parent organisation. Separate multiple usernames with a comma. Leave blank if this organisation should inherit the approver(s) for this level from a parent organisation or from the default assignment for this workflow.

You must include a **\'stage_X_level_Y\'** column for each approval level configured for this workflow. The levels configured for this workflow are:

{$a->level_list}

Any existing manager or approvers for a named organisation will be replaced to match the CSV.

Use the special code **{$a->remove_code}** in place of a username to remove all managers, or a level\'s approvers, from an override.';
$string['upload_csv_remove'] = 'Remove assignment(s)';
$string['user_data_item_applicant_active_applications'] = 'Applicant active and completed applications';
$string['user_data_item_approver_user'] = 'Individual Approver';
$string['user_data_item_applicant_draft_applications'] = 'Applicant draft applications';
$string['validate_form'] = 'Validate form';
$string['validate_form_info'] = 'This form is in preview mode, no data will be submitted when you click the button.';
$string['view_applications_report'] = 'View report';
$string['view_approvers_report_warning'] = 'To view the approvers report, you must select a <a href="{$a->url}">workflow</a>.';
$string['view_current_approval_level_approvers'] = 'View {$a} approvers';
$string['view_role_assignment_report'] = 'Override role assignments';
$string['view_application_info'] = 'View application info';
$string['view_workflow_info'] = 'View workflow info';
$string['visibility_of_section_x'] = 'Visibility of section \'{$a}\'';
$string['visible'] = 'Visible';
$string['warning:save_application_empty'] = "You have not entered any data into the application";
$string['warning:save_application_no_changes'] = 'You have not made any changes since your last save.';
$string['withdraw'] = 'Withdraw';
$string['withdraw_warning_message'] = 'Are you sure you want to withdraw the application?';
$string['withdraw_warning_title'] = 'Withdraw application';
$string['workflow'] = 'Workflow';
$string['workflow_dashboard_title'] = 'Manage approval workflows';
$string['workflow_default_id_number'] = 'workflow{$a}';
$string['workflow_description'] = 'Description';
$string['workflow_edit'] = 'Edit Approval Workflow';
$string['workflow_edit_details'] = 'Edit workflow details';
$string['workflow_edit_details_settings'] = 'Edit details';
$string['workflow_edit_error'] = 'Could not save changes';
$string['workflow_edit_saving'] = 'Saving...';
$string['workflow_heading_assigned_to'] = 'Assigned to';
$string['workflow_heading_assignment_type'] = 'Assignment Type';
$string['workflow_heading_id'] = 'ID';
$string['workflow_heading_type'] = 'Type';
$string['workflow_id'] = 'Workflow ID';
$string['workflow_info'] = 'Workflow info';
$string['workflow_id_number_help'] = 'This is the sequential number generated for each workflow. This can be changed later and it should be a unique value';
$string['workflow_name'] = 'Workflow name';
$string['workflow_override_role_assignment_title'] = '{$a} - Override role assignments';
$string['workflow_settings'] = 'Workflow settings';
$string['workflow_stages'] = 'Workflow stages';
$string['workflow_type_description_label'] = 'Description';
$string['workflow_type_name_label'] = 'Workflow type name';
$string['x_applications_awaiting_response'] = 'There are {$a} applications awaiting your response';
$string['x_users'] = '{$a} Users';
$string['xapplications'] = '{$a} applications';
$string['yescontinue'] = 'Continue';
$string['your_applications'] = 'Your applications';
$string['your_progress'] = 'Your progress';
$string['your_progress_approved'] = 'Approved';
$string['your_progress_na'] = 'N/A';
$string['your_progress_pending'] = 'Pending';
$string['your_progress_rejected'] = 'Rejected';

/**
 * Deprecated since 19.0
 */
$string['delete_workflow_warning_message_2'] = 'Once deleted, all applications in this workflow will be erased. This action cannot be undone.';
$string['notification:recipient_approvers'] = 'Approvers';
$string['approval:upload_approver_overrides'] = 'Upload approver overrides';
$string['application_report'] = 'Application';
$string['application_id:'] = 'Application ID:';
$string['application_type:'] = 'Application Type:';
$string['assignment_name:'] = 'Assignment name:';
$string['assignment_type:'] = 'Assignment type:';
$string['upload_csv_file'] = 'Upload a CSV file to add or replace organisation-based approver overrides on this workflow';
$string['upload_csv_file_help'] = 'Prepare a CSV file with a heading row and one or more data rows.

All rows must have the following columns. The values for columns marked **\'optional\'** may be blank, but all columns must be included in each row.

- **\'shortname\'** - Organisation shortname that approvers are being assigned to
- **\'manager\'** - (optional) Username of the workflow manager for this organisation. Leave blank if no workflow manager for this specific organisation.
- **\'stage_1_level_1\'** - (optional) Username of the approver at this level for this organisation, if it is different from the parent organisation. Separate multiple usernames with a comma. Leave blank if this organisation should inherit the approver(s) for this level from a parent organisation or from the default assignment for this workflow.

You must include a **\'stage_X_level_Y\'** column for each approval level configured for this workflow. The levels configured for this workflow are:

{$a->level_list}

Any existing manager or approvers for a named organisation will be replaced to match the CSV.

Use the special code **{$a->remove_code}** in place of a username to remove all managers, or a level\'s approvers, from an override.';
$string['workflow_name:'] = 'Workflow name:';
$string['view_approvers_report'] = 'View approvers report';
