<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2023 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Qingyang Liu <qingyang.liu@totara.com>
 * @package mod_facetoface
 */

namespace mod_facetoface\signup\condition;

/**
 * Class event_has_capacity_without_waitlist_enabled
 */
class event_has_capacity_without_waitlist_enabled extends event_has_capacity {
    /**
     * Is condition passing
     * @return bool
     */
    public function pass() : bool {
        $seminarevent = $this->signup->get_seminar_event();
        if ($seminarevent->get_allowoverbook()) {
            return true;
        }

        if ($seminarevent->get_free_capacity() > 0) {
            return true;
        }

        return false;
    }
}