<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2025 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Katherine Galano <katherine.galano@totara.com>
 * @package mod_feedback
 */

namespace mod_feedback;

use cm_info;

/**
 * Class manager for feedback
 *
 * @package    mod_feedback
 * @copyright  2024 Mikel Martín <mikel@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class manager {

    /**
     * Check if the current user can see other users if in groups
     *
     * @param cm_info $cm
     * @return bool
     */
    public static function can_see_others_in_groups(cm_info $cm): bool {
        $canaccessallgroups = has_capability('moodle/site:accessallgroups', $cm->context);
        if ($canaccessallgroups) {
            return true;
        }
        $course = $cm->get_course();
        $groupmode = groups_get_activity_groupmode($cm, $course);
        $usergroups = groups_get_user_groups($course->id);
        return $groupmode != SEPARATEGROUPS || !empty($usergroups['0']);
    }
}
