<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/** Automatically cleaned: 2024-09-24 */
$string['author'] = 'Author';
$string['cancellabel'] = 'Cancel';
$string['close'] = 'Close';
$string['confirmdialogbody'] = 'Please confirm that you wish to proceed. This action is not reversible.';
$string['confirmdialogheader'] = 'Confirm action';
$string['confirmlabel'] = 'Confirm';
$string['contentchanged'] = 'This content has changed since you last used it.';
$string['copyright'] = 'Rights of use';
$string['copyrighttitle'] = 'View copyright information for this content.';
$string['disablefullscreen'] = 'Disable fullscreen';
$string['download'] = 'Download';
$string['downloadtitle'] = 'Download this content as a H5P file.';
$string['embed'] = 'Embed';
$string['embedtitle'] = 'View the embed code for this content.';
$string['fullscreen'] = 'Fullscreen';
$string['h5p_disabled_warning'] = 'There are no content types installed. You can enable H5P Hub or upload an H5P file to install new content types.';
$string['h5p_disabled_warning_no_permission'] = 'There are no content types installed. You do not have permission to install or upload new content types.';
$string['h5pfile'] = 'H5P File';
$string['h5ptitle'] = 'Visit H5P.org to check out more cool content.';
$string['hideadvanced'] = 'Hide advanced';
$string['intro'] = 'Introduction';
$string['license'] = 'License';
$string['lookforupdates'] = 'Look for H5P updates';
$string['modulename'] = 'H5P';
$string['modulename_help'] = 'The H5P activity module enables you to create interactive content such as Interactive Videos, Question Sets, Drag and Drop Questions, Multi-Choice Questions, Presentations and much more.

In addition to being an authoring tool for rich content, H5P enables you to import and export H5P files for effective reuse and sharing of content.

User interactions and scores are tracked using xAPI and are available through the Totara Gradebook. Note that it is currently possible for people with programming skills to cheat in H5P interactions and obtain the full score without knowing the correct answers. H5Ps must not be used for exams or similar.

You add interactive H5P content by creating content using the built-in authoring tool or uploading H5P files found on other H5P enabled sites.';
$string['modulenameplural'] = 'H5Ps';
$string['nocopyright'] = 'No copyright information available for this content.';
$string['noh5ps'] = 'There\'s no H5P content available for this course.';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['removeoldlogentries'] = 'Remove old H5P log entries';
$string['removeoldmobileauthentries'] = 'Remove old H5P mobile auth entries';
$string['removetmpfiles'] = 'Remove old H5P temporary files';
$string['resizescript'] = 'Include this script on your website if you want dynamic sizing of the embedded content:';
$string['showadvanced'] = 'Show advanced';
$string['size'] = 'Size';
$string['source'] = 'Source';
$string['startingover'] = "You'll be starting over.";
$string['thumbnail'] = 'Thumbnail';
$string['title'] = 'Title';
$string['updatelibraries'] = 'Update All Libraries';
$string['userdataitemresponses'] = 'All user interactions and submitted responses';
$string['year'] = 'Year';

/**
 * Added by Totara
 */
$string['messageprovider:set_up_hvp'] = 'H5P installation content type setup instructions';
$string['notification_set_up_hvp_body_html'] = '<p>Totara now supports H5P interactive content in course activities.</p>
<p>To use this feature, you must first install some content types. To streamline the process, enable the H5P Hub in H5P settings.</p>
<p>By default, only the site administrator has the necessary permissions to install or update content types and libraries. However, these capabilities can be assigned to other roles as well.</p>
<p>To install H5P content types, just add an H5P activity to a course and you can then install recommended content types through the H5P Hub, or manually upload them.</p>
<p>{$a}</p>';
$string['notification_set_up_hvp_body_text'] = 'Totara now supports H5P interactive content in course activities.

To use this feature, you must first install some content types. To streamline the process, enable the H5P Hub in H5P settings.

By default, only the site administrator has the necessary permissions to install or update content types and libraries. However, these capabilities can be assigned to other roles as well.

To install H5P content types, just add an H5P activity to a course and you can then install recommended content types through the H5P Hub, or manually upload them.

Click here to set it up:

{$a}';
$string['notification_set_up_hvp_button'] = 'Set up H5P';
$string['notification_set_up_hvp_subject'] = 'H5P now available in Totara';

/**
 * Admin settings.
 */
$string['contentstatefrequency'] = 'Save content state frequency';
$string['contentstatefrequency_help'] = 'In seconds, how often do you wish the user to auto save their progress. Increase this number if you\'re having issues with many ajax requests';
$string['disablehubdescription'] = "
The H5P hub provides an interface for getting new content types and keeping existing content types up to date. Enabling this checkbox allows access to the H5P hub through the course creation process.  
<strong>Warning:</strong> H5P content types contain custom downloaded Javascript code that is not reviewed by Totara. Be sure that you trust a H5P activity before installing it.
Totara encourages use of selected activities that meet our accessibility and security standards. You can check compatibility through our documentation. 
By enabling the H5P hub, you accept these risks.  
";
$string['displayoptionalwaysshow'] = 'Always show';
$string['displayoptionauthoroff'] = 'Controlled by author, default is off';
$string['displayoptionauthoron'] = 'Controlled by author, default is on';
$string['displayoptiondownloadalways'] = 'Always';
$string['displayoptiondownloadnever'] = 'Never';
$string['displayoptiondownloadpermission'] = 'Only if user has permissions to export H5P';
$string['displayoptionnevershow'] = 'Never show';
$string['displayoptionpermissions'] = 'Show only if user has permissions to export H5P';
$string['displayoptionpermissionsembed'] = 'Show only if user has permissions to embed H5P';
$string['displayoptions'] = 'Display Options';
$string['empty'] = 'Empty';
$string['enableabout'] = 'About H5P button';
$string['enablecopyright'] = 'Copyright button';
$string['enabledlrscontenttypes'] = 'Enable LRS dependent content types';
$string['enabledlrscontenttypes_help'] = 'Makes it possible to use content types that rely upon a Learning Record Store to function properly, like the Questionnaire content type.';
$string['enabledownload'] = 'Allow download';
$string['enableembed'] = 'Embed button';
$string['enableframe'] = 'Display action bar and frame';
$string['enablehublabel'] = 'Use H5P Hub';
$string['enablesavecontentstate'] = 'Save content state';
$string['enablesavecontentstate_help'] = 'Automatically save the current state of H5P content for each user. This means that the user may pick up where he left off.';
$string['hide'] = 'Hide';
$string['hubsettingsheader'] = 'Content Types';
$string['reveal'] = 'Reveal';
$string['sendusagestatistics'] = 'Contribute usage statistics';
$string['sendusagestatistics_help'] = 'Usage statistics numbers will automatically be reported to help the developers better understand how H5P is used and to determine potential areas of improvement. Read more about which <a {$a}>data is collected on h5p.org</a>.';
$string['sitekey'] = 'Site Key';
$string['sitekeydescription'] = 'The site key is a secret that uniquely identifies this site with the Hub.';

/**
 * Admin menu.
 */
$string['contenttypecacheheader'] = 'Content Type Cache';
$string['libraries'] = 'H5P Libraries';
$string['settings'] = 'H5P Settings';

/**
 * Content type cache section.
 */
$string['ctcachebuttonlabel'] = 'Update content type cache';
$string['ctcacheconnectionfailed'] = "Couldn't communicate with the H5P Hub. Please try again later.";
$string['ctcachedescription'] = 'Making sure the content type cache is up to date will ensure that you can view, download and use the latest libraries. This is different from updating the libraries themselves.';
$string['ctcachelastupdatelabel'] = 'Last update';
$string['ctcacheneverupdated'] = 'Never';
$string['ctcachenolibraries'] = 'No content types were received from the H5P Hub. Please try again later.';
$string['ctcachesuccess'] = 'Library cache was successfully updated!';
$string['ctcachetaskname'] = 'Update content type cache';

/**
 * Upload libraries section.
 */
$string['disablefileextensioncheck'] = 'Disable file extension check';
$string['disablefileextensioncheckwarning'] = "Warning! Disabling the file extension check may have security implications as it allows for uploading of php files. That in turn could make it possible for attackers to execute malicious code on your site. Please make sure you know exactly what you're uploading.";
$string['onlyupdate'] = 'Only update existing libraries';
$string['options'] = 'Options';
$string['upload'] = 'Upload';
$string['uploadlibraries'] = 'Upload Libraries';

/**
 * Installed libraries section.
 */
$string['downloadfailed'] = 'Downloading the requested library failed.';
$string['installdenied'] = 'You do not have permission to install content types. Contact the administrator of your site.';
$string['installedlibraries'] = 'Installed Libraries';
$string['invalidcontenttype'] = 'The chosen content type is invalid.';
$string['invalidtoken'] = 'Invalid security token.';
$string['missingparameters'] = 'Missing parameters';
$string['nocontenttype'] = 'No content type was specified.';
$string['validatingh5pfailed'] = 'Validating h5p package failed.';
$string['validationfailed'] = 'The requested H5P was not valid';

/**
 * H5P library list headers on admin page.
 */
$string['librarylistactions'] = 'Actions';
$string['librarylistinstancedependencies'] = 'Instance dependencies';
$string['librarylistinstances'] = 'Instances';
$string['librarylistlibrarydependencies'] = 'Library dependencies';
$string['librarylistrestricted'] = 'Restricted';
$string['librarylisttitle'] = 'Title';

/**
 * H5P library page labels.
 */
$string['addlibraries'] = 'Add libraries';
$string['installedlibraries'] = 'Installed libraries';
$string['notapplicable'] = 'N/A';
$string['upgradelibrarycontent'] = 'Upgrade library content';

/**
 * Upgrade H5P content page.
 */
$string['enablejavascript'] = 'Please enable JavaScript.';
$string['upgrade'] = 'Upgrade H5P';
$string['upgradebuttonlabel'] = 'Upgrade';
$string['upgradedone'] = 'You have successfully upgraded {$a} content instance(s).';
$string['upgradeerror'] = 'An error occurred while processing parameters:';
$string['upgradeerrorcontent'] = 'Could not upgrade content %id:';
$string['upgradeerrordata'] = 'Could not load data for library %lib.';
$string['upgradeerrormissinglibrary'] = 'Missing required library %lib.';
$string['upgradeerrornotsupported'] = 'Parameters contain %used which is not supported.';
$string['upgradeerrorparamsbroken'] = 'Parameters are broken.';
$string['upgradeerrorscript'] = 'Could not load upgrades script for %lib.';
$string['upgradeerrortoohighversion'] = 'Parameters contain %used while only %supported or earlier are supported.';
$string['upgradeheading'] = 'Upgrade {$a} content';
$string['upgradeinprogress'] = 'Upgrading to %ver...';
$string['upgradeinvalidtoken'] = 'Error: Invalid security token!';
$string['upgradelibrarymissing'] = 'Error: Your library is missing!';
$string['upgrademessage'] = 'You are about to upgrade {$a} content instance(s). Please select upgrade version.';
$string['upgradenoavailableupgrades'] = 'There are no available upgrades for this library.';
$string['upgradenothingtodo'] = "There's no content instances to upgrade.";
$string['upgradereturn'] = 'Return';

/**
 * Results / report page.
 */
$string['ajaxfailed'] = 'Failed to load data.';
$string['currentpage'] = 'Page $current of $total';
$string['dataviewreportlabel'] = 'View Answers';
$string['empty'] = 'No results available';
$string['finished'] = 'Finished';
$string['invalidxapiresult'] = 'No xAPI results were found for the given content and user id combination';
$string['loadingdata'] = 'Loading data.';
$string['maxscore'] = 'Maximum Score';
$string['nextpage'] = 'Next page';
$string['noanswersubmitted'] = 'This user hasn\'t submitted an answer to the H5P yet';
$string['nodata'] = "There's no data available that matches your criteria.";
$string['previouspage'] = 'Previous page';
$string['reportingquestionsremaininglabel'] = 'questions remaining to grade';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Gradebook score:';
$string['reportingscoredelimiter'] = 'out of';
$string['reportingscorelabel'] = 'Score:';
$string['reportnotsupported'] = 'Not supported';
$string['reportsubmitgradelabel'] = 'Submit grade';
$string['score'] = 'Score';
$string['search'] = 'Search';
$string['user'] = 'User';
$string['viewreportlabel'] = 'Report';

/**
 * Editor.
 */
$string['action'] = 'Action';
$string['anunexpectedsave'] = 'Something unexpected happened. We were unable to save this content.';
$string['create'] = 'Create';
$string['editor'] = 'Editor';
$string['editor_help'] = '
Choose a content type from the list of available content types. You can install additional content types with H5P Hub if it is enabled, or upload additional content types with an H5P file.
';
$string['invalidlibrary'] = 'Invalid library';
$string['invalidparameters'] = 'Invalid Parameters';
$string['javascriptloading'] = 'Waiting for JavaScript...';
$string['maximumgrade'] = 'Maximum grade';
$string['maximumgradeerror'] = 'Please enter a valid positive integer as the max points available for this activity';
$string['missingcontentuserdata'] = 'Error: Could not find content user data';
$string['noparameters'] = 'No parameters';
$string['nosuchlibrary'] = 'No such library';
$string['olduploadoldcontent'] = "You're trying to upload content of an older version of H5P. Please upgrade the content on the server it originated from and try to upload again or turn on the H5P Hub to have this server upgrade it for your automaticall.";
$string['upload'] = 'Upload';

/**
 * Capabilities.
 */
$string['hvp:addinstance'] = 'Create new H5P activites';
$string['hvp:contenthubregistration'] = 'Register site with the H5P Content Hub';
$string['hvp:emailconfirmsubmission'] = 'Get a confirmation message when submitting';
$string['hvp:emailnotifysubmission'] = 'Get a notification message when an attempt is submitted';
$string['hvp:getcachedassets'] = 'Required for viewing H5P activities';
$string['hvp:getembedcode'] = 'View H5P embed code when \'controlled by permission\' option is set';
$string['hvp:getexport'] = 'Download .h5p file when \'controlled by permission\' option is set';
$string['hvp:installrecommendedh5plibraries'] = 'Install new safe H5P content types recommended by H5P.org';
$string['hvp:manage'] = 'Edit existing H5P activites';
$string['hvp:restrictlibraries'] = 'Restrict access to certain H5P content types';
$string['hvp:savecontentuserdata'] = 'Save the users\'s progress for H5P activities';
$string['hvp:saveresults'] = 'Save the results from completed H5P activities';
$string['hvp:share'] = 'Share content on the H5P OER Hub';
$string['hvp:updatelibraries'] = 'Install new H5P content types or update existing ones';
$string['hvp:userestrictedlibraries'] = 'Use restricted H5P content types';
$string['hvp:view'] = 'See and interact with H5P activities';
$string['hvp:viewallresults'] = 'View all results for completed H5P activites';
$string['hvp:viewresults'] = 'View own results for completed H5P activities';

/**
 * Capabilities error messages.
 */
$string['nopermissiontogettranslations'] = 'You do not have permissions to retrieve translations';
$string['nopermissiontorestrict'] = 'You do not have permission to restrict libraries.';
$string['nopermissiontosavecontentuserdata'] = 'You do not have permission to save content user data.';
$string['nopermissiontosaveresult'] = 'You do not have permission to save result for this content.';
$string['nopermissiontoupgrade'] = 'You do not have permission to upgrade libraries.';
$string['nopermissiontouploadcontent'] = 'You do not have permission to upload content here.';
$string['nopermissiontouploadfiles'] = 'You do not have permission to upload files here.';
$string['nopermissiontoviewcontenthubcache'] = 'You do not have permission to view the metadata for the content hub.';
$string['nopermissiontoviewcontenttypes'] = 'You do not have permission to view the content types.';
$string['nopermissiontoviewresult'] = 'You do not have permission to view results for this content.';

/**
 * Editor translations.
 */
$string['addedandupdatedpp'] = 'Added {$a->%new} new H5P libraries and updated {$a->%old} old ones.';
$string['addedandupdatedps'] = 'Added {$a->%new} new H5P libraries and updated {$a->%old} old one.';
$string['addedandupdatedsp'] = 'Added {$a->%new} new H5P library and updated {$a->%old} old ones.';
$string['addedandupdatedss'] = 'Added {$a->%new} new H5P library and updated {$a->%old} old one.';
$string['addednewlibraries'] = 'Added {$a->%new} new H5P libraries.';
$string['addednewlibrary'] = 'Added {$a->%new} new H5P library.';
$string['couldnotcopy'] = 'Could not copy file.';
$string['couldnotsave'] = 'Could not save file.';
$string['filenotimage'] = 'File is not an image.';
$string['filetypenotallowed'] = 'File type isn\'t allowed.';
$string['invalidaudioformat'] = 'Invalid audio file format. Use mp3 or wav.';
$string['invalidcontentfolder'] = 'Invalid content folder';
$string['invalidfieldtype'] = 'Invalid field type.';
$string['invalidfile'] = 'File "{$a->%filename}" not allowed. Only files with the following extensions are allowed: {$a->%files-allowed}.';
$string['invalidimageformat'] = 'Invalid image file format. Use jpg, png or gif.';
$string['invalidlanguagefile'] = 'Invalid language file {$a->%file} in library {$a->%library}';
$string['invalidlanguagefile2'] = 'Invalid language file {$a->%languageFile} has been included in the library {$a->%name}';
$string['invalidlibrarydata'] = 'Invalid data provided for {$a->%property} in {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Invalid data provided for {$a->%property} in {$a->%library}. Boolean expected.';
$string['invalidlibraryname'] = 'Invalid library name: {$a->%name}';
$string['invalidlibraryoption'] = 'Illegal option {$a->%option} in {$a->%library}';
$string['invalidlibraryproperty'] = 'Can\'t read the property {$a->%property} in {$a->%library}';
$string['invalidmainjson'] = 'A valid main h5p.json file is missing';
$string['invalidmultiselectoption'] = 'Invalid selected option in multi-select.';
$string['invalidselectoption'] = 'Invalid selected option in select.';
$string['invalidsemanticsjson'] = 'Invalid semantics.json file has been included in the library {$a->%name}';
$string['invalidsemanticstype'] = 'H5P internal error: unknown content type "{$a->@type}" in semantics. Removing content!';
$string['invalidstring'] = 'Provided string is not valid according to regexp in semantics. (value: \"{$a->%value}\", regexp: \"{$a->%regexp}\")';
$string['invalidvideoformat'] = 'Invalid video file format. Use mp4 or webm.';
$string['librarydirectoryerror'] = 'Library directory name must match machineName or machineName-majorVersion.minorVersion (from library.json). (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarynotselected'] = 'You must select a content type.';
$string['missingcontentfolder'] = 'A valid content folder is missing';
$string['missingcoreversion'] = 'The system was unable to install the <em>{$a->%component}</em> component from the package, it requires a newer version of the H5P plugin. This site is currently running version {$a->%current}, whereas the required version is {$a->%required} or higher. You should consider upgrading and then try again.';
$string['missingdependency'] = 'Missing dependency {$a->@dep} required by {$a->@lib}.';
$string['missinglibrary'] = 'Missing required library {$a->@library}';
$string['missinglibraryfile'] = 'The file "{$a->%file}" is missing from library: "{$a->%name}"';
$string['missinglibraryjson'] = 'Could not find library.json file with valid json format for library {$a->%name}';
$string['missinglibraryproperty'] = 'The required property {$a->%property} is missing from {$a->%library}';
$string['missinguploadpermissions'] = "Note that the libraries may exist in the file you uploaded, but you're not allowed to upload new libraries. Contact the site administrator about this.";
$string['nocontent'] = 'Could not find or parse the content.json file';
$string['noextension'] = 'The file you uploaded is not a valid HTML5 Package (It does not have the .h5p file extension)';
$string['nojson'] = 'The main h5p.json file is not valid';
$string['noparse'] = 'Could not parse the main h5p.json file';
$string['nounzip'] = 'The file you uploaded is not a valid HTML5 Package (We are unable to unzip it)';
$string['noziparchive'] = 'Your PHP version does not support ZipArchive.';
$string['unabletocreatedir'] = 'Unable to create directory.';
$string['unabletogetfieldtype'] = 'Unable to get field type.';
$string['updatedlibraries'] = 'Updated {$a->%old} H5P libraries.';
$string['updatedlibrary'] = 'Updated {$a->%old} H5P library.';

/**
 * Welcome messages.
 */
$string['invalidlibrarynamed'] = 'The H5P library {$a->%library} used in the content is not valid';
$string['missingmbstring'] = 'The mbstring PHP extension is not loaded. H5P need this to function properly';
$string['welcomecommunity'] = 'We hope you will enjoy H5P and get engaged in our growing community through our <a {$a->forums}>forums</a>.';
$string['welcomecontactus'] = 'If you have any feedback, don\'t hesitate to <a {$a}>contact us</a>. We take feedback very seriously and are dedicated to making H5P better every day!';
$string['welcomegettingstarted'] = 'To get started with H5P and Torara take a look at our <a {$a->totara_tutorial}>tutorial</a> and check out the <a {$a->example_content}>example content</a> at H5P.org for inspiration.';
$string['welcomeheader'] = 'Welcome to the world of H5P!';
$string['wrongversion'] = 'The version of the H5P library {$a->%machineName} used in this content is not valid. Content contains {$a->%contentLibrary}, but it should be {$a->%semanticsLibrary}.';

/**
 * Setup errors.
 */
$string['disablehubconfirmationmsg'] = 'Do you still want to enable the hub ?';
$string['hubcommunicationdisabled'] = 'H5P hub communication has been disabled because one or more H5P requirements failed.';
$string['hubisdisableduploadlibraries'] = 'The H5P Hub has been disabled until this problem can be resolved. You may still upload libraries through the "H5P Libraries" page.';
$string['maxpostsizetoosmall'] = 'Your PHP max post size is quite small. With your current setup, you may not upload files larger than {$a->%number} MB. This might be a problem when trying to upload H5Ps, images and videos. Please consider to increase it to more than 5MB';
$string['maxuploadsizetoosmall'] = 'Your PHP max upload size is quite small. With your current setup, you may not upload files larger than {$a->%number} MB. This might be a problem when trying to upload H5Ps, images and videos. Please consider to increase it to more than 5MB.';
$string['nowriteaccess'] = 'A problem with the server write access was detected. Please make sure that your server can write to your data folder.';
$string['oldphpversion'] = 'Your PHP version is outdated. H5P requires version 5.2 to function properly. Version 5.6 or later is recommended.';
$string['reviseserversetupandretry'] = 'When you have revised your server setup you may re-enable H5P hub communication in H5P Settings.';
$string['sitecouldnotberegistered'] = 'Site could not be registered with the hub. Please contact your site administrator.';
$string['sitekeyregistered'] = 'You have been provided a unique key that identifies you with the Hub when receiving new updates. The key is available for viewing in the "H5P Settings" page.';
$string['sslnotenabled'] = 'Your server does not have SSL enabled. SSL should be enabled to ensure a secure connection with the H5P hub.';
$string['successfullyregisteredwithhub'] = 'Your site was successfully registered with the H5P Hub.';
$string['uploadsizelargerthanpostsize'] = 'Your PHP max upload size is bigger than your max post size. This is known to cause issues in some installations.';

/**
 * Ajax messages.
 */
$string['failedtodownloadh5p'] = 'Failed to download the requested H5P.';
$string['filenotfoundonserver'] = 'File not found on server. Check file upload settings.';
$string['hubisdisabled'] = 'The hub is disabled. You can re-enable it in the H5P settings.';
$string['invalidh5ppost'] = 'Could not get posted H5P.';
$string['postmessagerequired'] = 'A post message is required to access the given endpoint';

/**
 * Licensing.
 */
$string['additionalinfo'] = 'Additional Information';
$string['additionallicenseinfo'] = 'Any additional information about the license';
$string['attribution'] = 'Attribution 4.0';
$string['attributionnc'] = 'Attribution-NonCommercial 4.0';
$string['attributionncnd'] = 'Attribution-NonCommercial-NoDerivs 4.0';
$string['attributionncsa'] = 'Attribution-NonCommercial-ShareAlike 4.0';
$string['attributionnd'] = 'Attribution-NoDerivs 4.0';
$string['attributionsa'] = 'Attribution-ShareAlike 4.0';
$string['authorcomments'] = 'Author comments';
$string['authorcommentsdescription'] = 'Comments for the editor of the content (This text will not be published as a part of copyright info)';
$string['authorname'] = "Author's name";
$string['authorrole'] = "Author's role";
$string['by'] = 'by';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution-NonCommercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribution-NonCommercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribution-NonCommercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribution-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['ccpdm'] = 'Public Domain Mark (PDM)';
$string['changedby'] = 'Changed by';
$string['changedescription'] = 'Description of change';
$string['changelog'] = 'Changelog';
$string['changeplaceholder'] = 'Photo cropped, text changed, etc.';
$string['contenttype'] = 'Content Type';
$string['copyrightinfo'] = 'Copyright information';
$string['copyrightstring'] = 'Copyright';
$string['creativecommons'] = 'Creative Commons';
$string['date'] = 'Date';
$string['editor'] = 'Editor';
$string['gpl'] = 'General Public License v3';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licensee'] = 'Licensee';
$string['licenseextras'] = 'License Extras';
$string['licenseversion'] = 'License Version';
$string['noversionattribution'] = 'Attribution';
$string['noversionattributionnc'] = 'Attribution-NonCommercial';
$string['noversionattributionncnd'] = 'Attribution-NonCommercial-NoDerivs';
$string['noversionattributionncsa'] = 'Attribution-NonCommercial-ShareAlike';
$string['noversionattributionnd'] = 'Attribution-NoDerivs';
$string['noversionattributionsa'] = 'Attribution-ShareAlike';
$string['originator'] = 'Originator';
$string['pd'] = 'Public Domain';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'Public Domain Mark';
$string['question'] = 'Question';
$string['showless'] = 'Show less';
$string['showmore'] = 'Show more';
$string['sublevel'] = 'Sublevel';
$string['undisclosed'] = 'Undisclosed';
$string['years'] = 'Year(s)';
$string['yearsfrom'] = 'Years (from)';
$string['yearsto'] = 'Years (to)';

/**
 * Embed.
 */
$string['embedloginfailed'] = 'You do not have access to this content. Try logging in.';

/**
 * Privacy.
 */
$string['privacy:metadata:core_files'] = 'The H5P activity stores files which have been uploaded as part of H5P content.';
$string['privacy:metadata:core_grades'] = 'The H5P activity stores grades of users that have answered H5P content.';
$string['privacy:metadata:hvp_content_user_data'] = 'Describes the current state that content is in for a user. Used to restore content to a previous state.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'User data that was stored.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Data type identifier.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Flag determining if data should be deleted when content changes.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'The ID of the H5P content that the data belongs to.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'The ID of the content user data relationship.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Flag determining if data should be pre-loaded into content.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Sub-content of H5P, 0 if this is not sub-content.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'The ID of the user that the data belongs to.';
$string['privacy:metadata:hvp_events'] = 'Keeps track of logged H5P events.';
$string['privacy:metadata:hvp_events:content_id'] = 'The content ID that the action was performed on, 0 if new or no content.';
$string['privacy:metadata:hvp_events:content_title'] = 'Title of the content.';
$string['privacy:metadata:hvp_events:created_at'] = 'The time that the event was created.';
$string['privacy:metadata:hvp_events:id'] = 'The unique ID of the event.';
$string['privacy:metadata:hvp_events:library_name'] = 'The library the event affected.';
$string['privacy:metadata:hvp_events:library_version'] = 'The library version the event affected.';
$string['privacy:metadata:hvp_events:sub_type'] = 'The sub-type of event, or action of event.';
$string['privacy:metadata:hvp_events:type'] = 'The type of event.';
$string['privacy:metadata:hvp_events:user_id'] = 'The ID of the user that performed the action.';
$string['privacy:metadata:hvp_xapi_results'] = 'Stores xAPI events in H5P content.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Additional information that the H5P can send in.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'The ID of the content the event was performed on.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'The correct answer pattern.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'The description, task or question of the content that action was performed on.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'The unique ID of the xAPI event.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'The type of interaction.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Max achievable score for the event.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'The ID of the parent of the content that this event was performed on. Null if it has no parent.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Achieved score for the event.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'The response the user sent in.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'The ID of the user that performed the action.';

/**
 * Reuse.
 */
$string['contentcopied'] = 'Content is copied to the clipboard';
$string['reuse'] = 'Reuse';
$string['reusecontent'] = 'Reuse Content';
$string['reusedescription'] = 'Reuse this content.';

/**
 * Offline.
 */
$string['connectionlost'] = 'Connection lost. Results will be stored and sent when you regain connection.';
$string['connectionreestablished'] = 'Connection reestablished.';
$string['offlinedialogbody'] = 'We were unable to send information about your completion of this task. Please check your internet connection.';
$string['offlinedialogheader'] = 'Your connection to the server was lost';
$string['offlinedialogretrybuttonlabel'] = 'Retry now';
$string['offlinedialogretrymessage'] = 'Retrying in :num....';
$string['offlinesuccessfulsubmit'] = 'Successfully submitted results.';
$string['resubmitscores'] = 'Attempting to submit stored results.';

/**
 * Error messages.
 */
$string['contentnotshared'] = 'H5P activity cannot be shared. Please check your H5P hub registration';
$string['couldnotparsejsonfromzip'] = 'Unable to parse JSON from the package: %fileName';
$string['couldnotparsepostdata'] = 'Could not parse post data.';
$string['couldnotreadfilefromzip'] = 'Unable to read file from the package: %fileName';
$string['fileexceedsmaxsize'] = 'One of the files inside the package exceeds the maximum file size allowed. (%file %used > %max)';
$string['invalidhvp'] = 'Invalid H5P activity';
$string['invalidtoken'] = 'H5P has received an invalid token. Refresh the page and try again';
$string['nohubregistration'] = 'Not registered with H5P Hub';
$string['nombstringexteension'] = 'The mbstring PHP extension is not loaded. H5P needs this to function properly';
$string['unpackedfilesexceedsmaxsize'] = 'The total size of the unpacked files exceeds the maximum size allowed. (%used > %max)';
$string['virusdetected'] = 'A potential virus was detected while saving the H5P package';

/**
 * Messaging api.
 */
$string['assistivetechnologieslabel'] = 'Assistive Technologies label';
$string['completionpass'] = 'Require passing grade';
$string['completionpass_help'] = 'If enabled, this activity is considered complete when the student receives a pass grade (as specified in the Grade section of the H5P activity settings) or higher.';
$string['completionpassdesc'] = 'Student must achieve a passing grade to complete this activity';
$string['emailconfirmbody'] = 'Hi {$a->username},

Thank you for submitting your answers to \'{$a->hvpname}\' in course \'{$a->coursename}\'.

This message confirms that your answers have been saved.

You can access this H5P at {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Thank you for submitting your answers to \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Submission confirmation: {$a->hvpname}';
$string['emailnotifybody'] = 'Hi {$a->username},

{$a->studentname} has completed \'{$a->hvpname}\' ({$a->hvpurl}) in course \'{$a->coursename}\'.

You can review this attempt at {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} has completed {$a->hvpname}. See {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} has completed {$a->hvpname}';
$string['gradeheading'] = 'Results for {$a}';
$string['gradetopassmustbeset'] = 'Grade to pass cannot be zero as this H5P activity has its completion method set to require passing grade. Please set a non-zero value.';
$string['gradetopassnotset'] = 'This H5P activity does not yet have a grade to pass set. It may be set in the Grade section of the H5P activity settings.';
$string['messageprovider:confirmation'] = 'Confirmation of your own H5P submissions';
$string['messageprovider:submission'] = 'Notification of H5P submissions';

/**
 * Content hub.
 */
$string['acceptterms'] = 'I accept the <a href=":url" target="_blank">terms of use</a>';
$string['accountdetailslinktext'] = 'here';
$string['add'] = 'Add';
$string['address'] = 'Address';
$string['alttext'] = 'Alt text';
$string['back'] = 'Back';
$string['cancel'] = 'Cancel';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'No';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Yes';
$string['cancelpublishconfirmationdialogdescription'] = 'Are you sure you want to cancel the sharing process?';
$string['cancelpublishconfirmationdialogtitle'] = 'Cancel sharing';
$string['changehasbeensubmitted'] = 'A change has been submited for';
$string['city'] = 'City';
$string['contactperson'] = 'Contact Person';
$string['contentavailable'] = 'Your content will normally be available in the Hub within one business day.';
$string['contenthub:changesettings'] = 'Change account settings <a href="{$a}">here</a>';
$string['contenthub:licenseagreementdescription'] = 'Please read the following agreement before proceeding with the ';
$string['contenthub:licenseagreementmaintext'] = 'TODO';
$string['contenthub:licenseagreementtitle'] = 'End User License Agreement (EULA)';
$string['contenthub:nopermissions'] = 'You do not have permission to register the site with the content hub.';
$string['contenthub:register'] = 'Register an account on the H5P Hub <a href="{$a}">here</a>';
$string['contenthub:settings:box'] = 'Content Hub Account';
$string['contenthub:settings:heading'] = 'H5P Hub Account Settings';
$string['contenthubeditsharing'] = 'Edit sharing info';
$string['contenthuboptions'] = 'H5P OER Hub Options';
$string['contenthubshare'] = 'Share on H5P Hub';
$string['contenthubsharinginprogress'] = 'Sharing...';
$string['contenthubsyncchanges'] = 'Sync changes';
$string['contenthubunshare'] = 'Unshare';
$string['contentissyncing'] = 'Content is being synced.';
$string['contentlicensetitle'] = 'Content License Info';
$string['contentnotshared'] = 'Content is not shared on the Hub.';
$string['contentupdatesoon'] = 'Your content will update soon';
$string['country'] = 'Country';
$string['currentstep'] = 'Step :step of :total';
$string['description'] = 'Description';
$string['disciplinedescription'] = 'You can select multiple disciplines';
$string['disciplinelabel'] = 'Disciplines';
$string['disciplinelimitreachedmessage'] = 'You can select up to :numDisciplines disciplines';
$string['disciplines'] = 'Disciplines';
$string['dropdownbutton'] = 'Dropdown button';
$string['editinfotitle'] = 'Edit info for <strong>:title</strong>';
$string['editingfailed'] = 'Editing failed.';
$string['emailaddress'] = 'Email Address';
$string['helpchoosinglicense'] = 'Help me choose a license';
$string['icon'] = 'Icon';
$string['icondescription'] = '640x480px. If not selected content will use category icon';
$string['in'] = 'in';
$string['isnowsubmitted'] = 'Is now submitted to H5P Hub';
$string['keywordexists'] = 'Keyword already exists!';
$string['keywords'] = 'Keywords';
$string['keywordsdescription'] = 'You can add multiple keywords separated by commas. Press "Enter" or "Add" to confirm keywords';
$string['keywordsplaceholder'] = 'Add keywords';
$string['language'] = 'Language';
$string['level'] = 'Level';
$string['licensedescription'] = 'Select a license for your content';
$string['licensedetails'] = 'License details';
$string['licensedialogdescription'] = 'Click on a specific license to get info about proper usage';
$string['licenseversiondescription'] = 'Select a license version';
$string['logouploadtext'] = 'Organization logo or avatar';
$string['longdescription'] = 'Long description';
$string['longdescriptionplaceholder'] = 'Long description of your content';
$string['maintitle'] = 'Sharing <strong>:title</strong>';
$string['maxlength'] = ':length is the maximum number of characters';
$string['next'] = 'Next';
$string['noexport'] = 'Missing export file.';
$string['optionalinfo'] = 'Optional Info';
$string['phone'] = 'Phone';
$string['pleasewait'] = 'Please wait...';
$string['publisherdescription'] = 'Publisher description';
$string['publisherdescriptiontext'] = 'This will be displayed under "Publisher info" on shared content';
$string['publisherfielddescription'] = 'This will display as the "Publisher name" on shared content';
$string['publisherfieldtitle'] = 'Publisher';
$string['registeronhub'] = 'Register on the H5P Hub';
$string['registrationfailed'] = 'An error occurred';
$string['registrationfaileddescription'] = 'We were not able to create an account at this point. Something went wrong. Try again later.';
$string['registrationtitle'] = 'H5P Hub Registration';
$string['remove'] = 'Remove';
$string['removechip'] = 'Remove :chip from the list';
$string['removeimage'] = 'Remove image';
$string['requiredinfo'] = 'Required Info';
$string['reviewandsave'] = 'Review & Save';
$string['reviewandshare'] = 'Review & Share';
$string['reviewinfo'] = 'Review info';
$string['reviewmessage'] = 'Please review the info below before you share';
$string['savechanges'] = 'Save changes';
$string['screenshots'] = 'Screenshots';
$string['screenshotsdescription'] = 'Add up to five screenshots of your content';
$string['searchplaceholder'] = 'Type to search for disciplines';
$string['share'] = 'Share';
$string['shared'] = 'Shared';
$string['sharefailed'] = 'Share failed.';
$string['sharetryagain'] = 'Something went wrong, please try to share again.';
$string['sharingnote'] = 'All content details can be edited after sharing';
$string['shortdescription'] = 'Short description';
$string['shortdescriptionplaceholder'] = 'Short description of your content';
$string['subcontentwarning'] = 'Sub-content (images, questions etc.) will be shared under :license unless otherwise specified in the authoring tool';
$string['submitted'] = 'Submitted!';
$string['successfullyregistred'] = 'You have successfully registered an account on the H5P Hub';
$string['successfullyregistreddescription'] = 'Your account details can be changed';
$string['successfullyupdated'] = 'Your H5P Hub account settings have successfully been changed';
$string['updateregistrationonhub'] = 'Save account settings';
$string['zip'] = 'Zip';

/**
 * Content hub.
 */
$string['age'] = 'Typical age';
$string['agedescription'] = 'The target audience of this content. Possible input formats separated by commas: "1,34-45,-50,59-".';
$string['contactpersondescription'] = 'H5P will reach out to the contact person in case there are any issues with the content shared by the publisher. The contact person\'s name or other information will not be published or shared with third parties';
$string['copyrightwarning'] = 'Copyrighted material cannot be shared in the H5P Content Hub. If the content is licensed with a OER friendly license like Creative Commons, please choose the appropriate license. If not this content cannot be shared.';
$string['emailaddressdescription'] = 'The email address will be used by H5P to reach out to the publisher in case of any issues with the content or in case the publisher needs to recover their account. It will not be published or shared with any third parties';
$string['invalidage'] = 'Invalid input format for Typical age. Possible input formats separated by commas: "1, 34-45, -50, -59-".';
$string['keywordsexists'] = 'Keywords already exists!';
$string['somekeywordsexists'] = 'Some of these keywords already exist';

/**
 * Deprecated since Totara 18.0
 */
$string['modulename_link'] = 'https://totara.help/18/docs/h5p-activity';
