<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTDvs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author  Murali Nair <murali.nair@totaralearning.com>
 * @package mod_perform
 */

namespace mod_perform\webapi\resolver\mutation;

use core\webapi\execution_context;
use core\webapi\mutation_resolver;
use core\webapi\middleware\require_advanced_feature;

use mod_perform\models\activity\activity_setting;
use mod_perform\webapi\middleware\require_activity;
use mod_perform\webapi\middleware\require_manage_capability;

/**
 * Handles the "mod_perform_toggle_activity_close_on_completion_setting" GraphQL mutation.
 * @deprecated since Totara 16.0 Use update_activity_workflow_settings instead.
 */
class toggle_activity_close_on_completion_setting extends mutation_resolver {

    /**
     * {@inheritdoc}
     */
    public static function resolve(array $args, execution_context $ec) {
        debugging(
            "The mutation 'toggle_activity_close_on_completion_setting' had been deprecated, please use mod_perform_update_activity_workflow_settings instead",
            DEBUG_DEVELOPER
        );
        // The require_activity middleware loads the activity and passes it along via the args
        $activity = $args['activity'];

        $value = $args['input']['setting'] ?? null;
        if (is_null($value)) {
            throw new \invalid_parameter_exception('close on completion setting not specified');
        }

        return $activity
            ->settings
            ->update([activity_setting::CLOSE_ON_COMPLETION => (bool)$value])
            ->get_activity();
    }

    /**
     * {@inheritdoc}
     */
    public static function get_middleware(): array {
        return [
            new require_advanced_feature('performance_activities'),
            require_activity::by_activity_id('input.activity_id', true),
            require_manage_capability::class
        ];
    }
}
