<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Marco Song <marco.song@totaralearning.com>
 * @package mod_perform
 */

use mod_perform\hook\pre_section_element_deleted;

class mod_perform_pre_section_element_deleted_hook_test extends \core_phpunit\testcase {

    public function test_hook_is_triggered() {
        $hook_sink = $this->redirectHooks();

        $hook_sink->clear();
        $hooks = $hook_sink->get_hooks();
        $this->assertCount(0, $hooks);

        $hook = new pre_section_element_deleted(1);
        $hook->execute();

        $hooks = $hook_sink->get_hooks();
        $this->assertCount(1, $hooks);

        $hook = reset($hooks);
        $this->assertTrue($hook instanceof pre_section_element_deleted);
    }
}