<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2024 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Qingyang Liu <qingyang.liu@totara.com>
 * @package theme_inspire
 */

namespace theme_inspire\usagedata;

use tool_usagedata\export;

class inherited implements export {
    /**
     * @inheritDoc
     */
    public function get_summary(): string {
        return get_string('inspire_inherited_usagedata_summary', 'theme_inspire');
    }

    /**
     * @inheritDoc
     */
    public function get_type(): int {
        return export::TYPE_OBJECT;
    }

    /**
     * @inheritDoc
     */
    public function export(): array {
        global $CFG;
        $theme_config = \theme_config::load($CFG->theme);
        return [
            'themes' => $CFG->theme === 'inspire' ? 'directly' : (in_array('inspire', $theme_config->parents) ? 'inherited' : 'no')
        ];
    }
}