<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2024 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Angela Kuznetsova <angela.kuznetsova@totara.com>
 * @package totara_cohort
 */

namespace totara_cohort\hook;

use totara_core\hook\base;

/**
 * This hook contains information about cohort to check if we can delete it
 *
 * @package totara_cohort
 */
class pre_delete_cohort_check extends base {

    /**
     * @param int $id
     */
    protected int $id;

    /**
     * Reasons the cohort is prevented from being deleted.
     *
     * @param string[] $reasons
     */
    protected array $reasons = [];

    /**
     * @param int $id
     */
    public function __construct(int $id) {
        $this->id = $id;
    }

    /**
     * @return int $id
     */
    public function get_id(): int {
        return $this->id;
    }

    /**
     * Get reasons the cohort can not be deleted.
     *
     * @return array
     */
    public function get_reasons(): array {
        return $this->reasons;
    }

    /**
     * Add a reason not to delete the cohort.
     *
     * @param string $message
     * @return self
     */
    public function add_reason(string $message): self {
        $this->reasons[] = $message;
        return $this;
    }
}
