<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2019 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @note Automatically cleaned: 2024-09-24
 * @author Brendan Cox <brendan.cox@totaralearning.com>
 * @author Riana Rossouw <riana.rossouw@totaralearning.com>
 * @package totara_competency
 */


$string['a11y_competency_crumbtrail'] = 'Crumbtrail for current competencies:';
$string['a11y_competency_parents'] = 'Parent competencies:';
$string['a11y_filter_competencies'] = 'Filters competency';
$string['achieved_n_out_of_n'] = '{$a->current} / {$a->target}';
$string['achieved_on'] = 'Achieved on {$a->date}';
$string['achievement_add_pathway'] = 'Add achievement path';
$string['achievement_add_pathway_sr_only'] = 'added';
$string['achievement_level'] = 'Achievement level';
$string['achievement_path_group_label_single'] = 'Criteria fulfilment';
$string['achievement_paths'] = 'Achievement paths';
$string['achievement_paths_label'] = 'Achievement paths:';
$string['achievement_paths_need_review'] = 'Achievement paths need review';
$string['achievement_paths_need_review_completely'] = 'The achievement paths were successfully scheduled to be applied to {$a->count} competencies. All of them contain criteria-based paths that will need to be reviewed. These changes might take a while to be reflected throughout the site.';
$string['achievement_paths_need_review_completely_one'] = 'The achievement paths were successfully scheduled to be applied to {$a->count} competency. It contains criteria-based paths that will need to be reviewed. These changes might take a while to be reflected throughout the site.';
$string['achievement_paths_need_review_framework'] = 'Some achievement paths need review';
$string['achievement_paths_need_review_framework_long'] = 'Some of these competencies have achievement paths which need to be reviewed. Competencies cannot be rated without a valid achievement path.';
$string['achievement_paths_need_review_long'] = 'The achievement paths for this competency need review. Competencies cannot be rated without a valid achievement path.';
$string['achievement_paths_need_review_partially_many_many'] = 'The achievement paths were successfully scheduled to be applied to {$a->count} competencies. There are {$a->review_count} competencies containing criteria-based paths that will need to be reviewed. These changes might take a while to be reflected throughout the site.';
$string['achievement_paths_need_review_partially_many_one'] = 'The achievement paths were successfully scheduled to be applied to {$a->count} competencies. There is {$a->review_count} competency containing criteria-based paths that will need to be reviewed. These changes might take a while to be reflected throughout the site.';
$string['achievement_paths_need_review_partially_one_many'] = 'The achievement paths were successfully scheduled to be applied to {$a->count} competency. There are {$a->review_count} competencies containing criteria-based paths that will need to be reviewed. These changes might take a while to be reflected throughout the site.';
$string['achievement_paths_need_review_partially_one_one'] = 'The achievement paths were successfully scheduled to be applied to {$a->count} competency. There is {$a->review_count} competency containing criteria-based paths that will need to be reviewed. These changes might take a while to be reflected throughout the site.';
$string['achievement_pathway_remove'] = 'Remove pathway';
$string['achievement_pathway_remove_item'] = 'Remove item';
$string['achievement_pathway_remove_undo'] = 'Undo remove pathway';
$string['achievement_priority_edit'] = 'Edit prioritised achievement paths';
$string['achievement_priority_move'] = 'Move prioritised achievement paths';
$string['action_activate'] = 'Activate assignment';
$string['action_activate_bulk_modal'] = '<p>Competency records will be created for all assigned users and their progress against the achievement criteria for these competencies will begin to be tracked.</p><p>Only draft assignments will be activated (active and archived assignments will be ignored).</p><p>Do you want to proceed with activation?</p>';
$string['action_activate_bulk_modal_header'] = 'Confirm bulk assignment activation';
$string['action_activate_individual_modal'] = '<p>A competency record will be created for the assigned user, and their progress against the achievement criteria for this competency will begin to be tracked.</p><p>Do you want to proceed with activation?</p>';
$string['action_activate_individual_modal_header'] = 'Confirm assignment activation';
$string['action_activate_modal'] = '<p>Competency records will be created for all assigned users, and their progress against the achievement criteria for this competency will begin to be tracked.</p><p>Do you want to proceed with activation?</p>';
$string['action_activate_modal_header'] = 'Confirm assignment activation';
$string['action_add_user_groups'] = 'Add user groups';
$string['action_archive'] = 'Archive assignment';
$string['action_archive_bulk_modal_1'] = 'All assigned users will be unassigned, and their assignments and records archived. Their progress against the achievement criteria for these competencies will no longer be tracked.';
$string['action_archive_bulk_modal_2'] = 'Only active assignments will be archived (draft and archived assignments will be ignored).';
$string['action_archive_bulk_modal_confirm'] = 'Enable continuous achievement tracking for <strong>users in group-based</strong> assignments who have no other active assignments to the competency from which they are being unassigned';
$string['action_archive_bulk_modal_header'] = 'Confirm bulk archiving of assignments';
$string['action_archive_bulk_modal_question'] = 'Do you want to proceed with archiving?';
$string['action_archive_group_modal'] = 'All assigned users will be unassigned, and their assignments and records archived. Their progress against the achievement criteria for these competencies will no longer be tracked.';
$string['action_archive_group_modal_confirm'] = 'Enable continuous achievement tracking for users who have no other active assignments to the competency from which they are being unassigned.';
$string['action_archive_group_modal_header'] = 'Confirm archiving of assignment';
$string['action_archive_modal_header'] = 'Confirm archiving of assignment';
$string['action_archive_modal_question'] = 'Do you want to proceed with archiving?';
$string['action_archive_this'] = 'Archive this assignment';
$string['action_archive_user_assignment_modal'] = 'This assignment and associated achievement record will be archived. If there are no other active assignments remaining after this one is archived, it means that progress against the achievement criteria for this competency will no longer be tracked.';
$string['action_archive_user_modal'] = 'The assigned user will be unassigned, and their assignment and record archived. Their progress against the achievement criteria for this competency will no longer be tracked.';
$string['action_archive_user_modal_header'] = 'Confirm archiving of assignment';
$string['action_confirm_activate_bulk'] = '{$a->affected} competency assignments successfully activated.';
$string['action_confirm_activate_bulk_skipped'] = '{$a->affected} competency assignments successfully activated. {$a->skipped} competency assignments ignored.';
$string['action_confirm_activate_error'] = 'Activation could not be completed due to a change in the assignment\'s status. The list has been updated.';
$string['action_confirm_activate_success'] = 'Competency assignment successfully activated.';
$string['action_confirm_archive_bulk'] = '{$a->affected} competency assignments successfully archived.';
$string['action_confirm_archive_bulk_skipped'] = '{$a->affected} competency assignments successfully archived. {$a->skipped} competency assignments ignored.';
$string['action_confirm_archive_error'] = 'Archiving could not be completed due to a change in the assignment\'s status. The list has been updated.';
$string['action_confirm_archive_success'] = 'Competency assignment successfully archived.';
$string['action_confirm_delete_bulk'] = '{$a->affected} competency assignments successfully deleted.';
$string['action_confirm_delete_bulk_skipped'] = '{$a->affected} competency assignments successfully deleted. {$a->skipped} competency assignments ignored.';
$string['action_confirm_delete_error'] = 'Deletion could not be completed due to a change in the assignment\'s status. The list has been updated.';
$string['action_confirm_delete_success'] = 'Competency assignment successfully deleted.';
$string['action_delete'] = 'Delete assignment';
$string['action_delete_archived_individual_modal'] = '<p>The associated user assignment and record will be deleted.</p><p>Do you want to proceed with deletion?</p>';
$string['action_delete_archived_individual_modal_header'] = 'Confirm archived assignment deletion';
$string['action_delete_archived_modal'] = '<p>All associated user assignments and records will be deleted.</p><p>Do you want to proceed with deletion?</p>';
$string['action_delete_archived_modal_header'] = 'Confirm archived assignment deletion';
$string['action_delete_bulk_modal'] = '<p>All selected draft assignments will be deleted – this will have no impact on users, as they have not yet been assigned to the competency.</p><p>All selected active assignments will be ignored (only draft and archived competencies can be deleted).</p><p><strong>All selected archived assignments will be deleted – all associated user assignments and records will be deleted.</strong></p><p>Do you want to proceed with deletion?</p>';
$string['action_delete_bulk_modal_header'] = 'Confirm bulk assignment deletion';
$string['action_delete_draft_individual_modal'] = '<p>This will have no impact on the associated user, as they have not yet been assigned to the competency.</p><p>Do you want to proceed with deletion?</p>';
$string['action_delete_draft_individual_modal_header'] = 'Confirm draft assignment deletion';
$string['action_delete_draft_modal'] = '<p>This will have no impact on users, as they have not yet been assigned to the competency.</p><p>Do you want to proceed with deletion?</p>';
$string['action_delete_draft_modal_header'] = 'Confirm draft assignment deletion';
$string['active'] = 'Active';
$string['activity_log'] = 'Activity log';
$string['activity_log_aggregation_changed'] = 'Overall rating calculation change';
$string['activity_log_assigned_admin'] = 'Assigned: {$a->assigner_name} (Admin)';
$string['activity_log_assigned_audience'] = 'Assigned: {$a->audience_name} (Audience)';
$string['activity_log_assigned_continuous'] = 'Assignment transferred for continuous tracking';
$string['activity_log_assigned_organisation'] = 'Assigned: {$a->organisation_name} (Organisation)';
$string['activity_log_assigned_other'] = 'Assigned: {$a->assigner_name}';
$string['activity_log_assigned_position'] = 'Assigned: {$a->position_name} (Position)';
$string['activity_log_assigned_self'] = 'Assigned: Self-assigned';
$string['activity_log_comment'] = 'Comment:';
$string['activity_log_competency_aggregation_changed'] = 'Aggregation method on the competency changed';
$string['activity_log_criteria_change'] = 'Criteria change';
$string['activity_log_criteria_met'] = 'Criteria met: {$a->criteria_met}. Achieved \'{$a->scale_value_name}\' rating.';
$string['activity_log_criteria_met_multi_divider'] = '{$a->critera_met_one}; {$a->critera_met_two}';
$string['activity_log_filter'] = 'Filter activity log';
$string['activity_log_minprof_changed'] = 'Minimum required proficiency value changed to \'{$a->scale_value_name}\'';
$string['activity_log_minprof_override'] = 'Minimum required proficiency value for assignment set to \'{$a->scale_value_name}\'';
$string['activity_log_minprof_override_cancelled'] = 'Minimum required proficiency value for assignment removed';
$string['activity_log_no_rating'] = 'Rating: None';
$string['activity_log_rating'] = 'Rating: {$a->scale_value_name}';
$string['activity_log_rating_value_reset'] = 'Rating value reset';
$string['activity_log_tracking_started'] = 'Competency active: Achievement tracking started';
$string['activity_log_tracking_stopped'] = 'Competency archived: Achievement tracking stopped';
$string['activity_log_unassigned_admin'] = 'Unassigned: {$a->assigner_name} (Admin)';
$string['activity_log_unassigned_audience'] = 'Unassigned: {$a->audience_name} (Audience)';
$string['activity_log_unassigned_continuous'] = 'Unassigned: Continuous tracking';
$string['activity_log_unassigned_organisation'] = 'Unassigned: {$a->organisation_name} (Organisation)';
$string['activity_log_unassigned_other'] = 'Unassigned: {$a->assigner_name}';
$string['activity_log_unassigned_position'] = 'Unassigned: {$a->position_name} (Position)';
$string['activity_log_unassigned_self'] = 'Unassigned: Self-assigned';
$string['add_competencies'] = 'Add competencies';
$string['add_criteria_group'] = 'Add criteria group';
$string['add_linked_courses'] = 'Add linked courses';
$string['aggregate_all_competencies_task'] = 'Aggregate competency achievements for all users with active competency assignments';
$string['aggregate_queued_competencies_task'] = 'Aggregate competency achievements for queued aggregation only';
$string['all'] = 'All';
$string['all_assignments'] = 'All assignments';
$string['all_categories'] = 'All categories';
$string['all_competencies'] = 'All competencies';
$string['all_competencies_framework'] = 'Framework home';
$string['and'] = 'and';
$string['any'] = 'Any';
$string['any_scale_value'] = 'Any scale value';
$string['apply_changes'] = 'Apply changes';
$string['apply_copy_pathways'] = 'Apply';
$string['apply_copy_pathways_confirmation_title'] = 'Apply achievement paths';
$string['apply_success'] = 'Changes applied successfully';
$string['archived'] = 'Archived';
$string['archived_assignments'] = 'Archived assignments';
$string['assign_competencies'] = 'Assign competencies';
$string['assigned'] = 'Assigned';
$string['assigned_type_detail'] = 'Detail';
$string['assigned_user_groups'] = 'Assigned user groups';
$string['assigner_role_admin'] = 'Admin';
$string['assigner_role_manager'] = 'Manager';
$string['assignment'] = 'Assignment';
$string['assignment_archived_at'] = 'Assignment archived {$a}';
$string['assignment_back_to_assignments'] = '« Back to Manage competency assignments';
$string['assignment_create_new'] = 'Create assignments';
$string['assignment_creation_availability'] = 'Assignment creation availability';
$string['assignment_date_archived'] = 'Date archived';
$string['assignment_reason'] = '{$a->assignment} ({$a->type})';
$string['assignment_reason_self'] = 'Self-assigned';
$string['assignment_reason_system'] = 'Continuous tracking';
$string['assignment_type_admin'] = 'Individual (Admin)';
$string['assignment_type_legacy'] = 'Legacy Assignment';
$string['assignment_type_other'] = 'Directly assigned';
$string['assignment_type_self'] = 'Self-assigned';
$string['assignment_type_system'] = 'Individual (System)';
$string['assignment_view_current'] = 'Currently assigned user report';
$string['awaiting_selection_text'] = 'Awaiting competency selection from a {$a}.';
$string['back'] = 'Back';
$string['back_to'] = '« Back to {$a}';
$string['back_to_all_competencies'] = 'Back to all competencies';
$string['back_to_competency'] = 'Back to {$a}';
$string['back_to_competency_profile'] = 'Back to competency profile';
$string['back_to_competency_profile_self'] = 'Back to your competency profile';
$string['basket_clear_selection'] = 'Clear selection';
$string['basket_empty_basket_can_not_proceed_creating_assignment'] = 'You need to select at least one competency before you can proceed with assignment creation';
$string['basket_view_selected'] = 'View selected';
$string['browse_selected_user_groups'] = 'Users in selected groups';
$string['browse_users'] = 'Browse users';
$string['button_sync_users'] = 'Sync assigned users';
$string['cancel'] = 'Cancel';
$string['cannot_copy_achievement_path'] = 'Cannot copy achievement paths';
$string['cannot_copy_achievement_path_details'] = 'This competency has no achievement paths. To copy it, achievement paths must be added.';
$string['change_competency_selection'] = 'Edit competency selection';
$string['chart_label_proficient'] = 'proficient';
$string['charts'] = 'Charts';
$string['competencies'] = '{$a} competencies';
$string['competencies_selected'] = 'Creating assignments for <strong>{$a} competencies</strong>';
$string['competency'] = 'Competency';
$string['competency:assign_other'] = 'Assign competency to other users';
$string['competency:assign_self'] = 'Assign competency to yourself';
$string['competency:manage_assignments'] = 'Manage competency assignments';
$string['competency:rate_other_competencies'] = 'Rate competencies of other users';
$string['competency:rate_own_competencies'] = 'Rate own competencies';
$string['competency:view_assignments'] = 'View competency assignments';
$string['competency:view_other_profile'] = 'View profile of other users';
$string['competency:view_own_profile'] = 'View own competency profile';
$string['competency_achievement_path_list_separator'] = ', ';
$string['competency_assign_availability_other_simple'] = 'Other users';
$string['competency_assign_availability_self_simple'] = 'Self';
$string['competency_does_not_exist'] = 'The requested competency does not exist.';
$string['competency_generic_display_name'] = 'competency';
$string['competency_parent_list_separator'] = ' / ';
$string['competency_profile'] = 'Competency profile';
$string['complete_criteria'] = 'Complete the following criteria';
$string['completed'] = 'completed';
$string['confirm_assignment_creation_active_plural'] = '{$a->created} active competency assignments were successfully created.';
$string['confirm_assignment_creation_active_singular'] = '{$a->created} active competency assignment was successfully created.';
$string['confirm_assignment_creation_draft_plural'] = '{$a->created} draft competency assignments were successfully created.';
$string['confirm_assignment_creation_draft_singular'] = '{$a->created} draft competency assignment was successfully created.';
$string['confirm_assignment_creation_none_plural'] = 'No new competency assignments were created, as they already exist.';
$string['confirm_assignment_creation_none_singular'] = 'No new competency assignment was created, as it already exists.';
$string['confirm_assignment_creation_plural_skipped_plural'] = '{$a->created} competency assignments were successfully created. {$a->skipped} competency assignments were not created, as they already exist.';
$string['confirm_assignment_creation_plural_skipped_singular'] = '{$a->created} competency assignments were successfully created. {$a->skipped} competency assignment was not created, as it already exists.';
$string['confirm_assignment_creation_singular_skipped_plural'] = '{$a->created} competency assignment was successfully created. {$a->skipped} competency assignments were not created, as they already exist.';
$string['confirm_assignment_creation_singular_skipped_singular'] = '{$a->created} competency assignment was successfully created. {$a->skipped} competency assignment was not created, as it already exists.';
$string['confirm_copy_path_continue'] = 'Do you want to continue?';
$string['confirm_copy_path_overwrite_all_middle'] = 'All of them already have achievement paths. Replacing the existing achievement paths may result in changes to users’ proficiency.';
$string['confirm_copy_path_overwrite_bottom'] = 'Do you want to continue and replace the existing achievement paths?';
$string['confirm_copy_path_overwrite_some_middle'] = '{$a} of them already have achievement paths. Replacing the existing achievement paths may result in changes to users’ proficiency.';
$string['confirm_copy_path_top'] = 'The copied achievement paths will be applied to the {$a} competencies selected.';
$string['confirm_generic'] = 'Do you want to continue?';
$string['continue_copying_paths'] = 'Continue';
$string['continuous_tracking'] = 'Continuous tracking';
$string['copy_achievement_paths_title'] = 'Copy achievement paths from: ‘{$a}’';
$string['copy_to_other_competency'] = 'Copy to other competencies in the same framework';
$string['copying_achievement_paths_success'] = 'The achievement paths were successfully scheduled to be applied to {$a->count} competencies. These changes might take a while to be reflected throughout the site.';
$string['copying_achievement_paths_success_one'] = 'The achievement paths were successfully scheduled to be applied to {$a->count} competency. These changes might take a while to be reflected throughout the site.';
$string['copying_achievement_paths_warning'] = 'There is a task scheduled to update this competency, which may result in a change to proficiency';
$string['coursefullname'] = 'Full Name';
$string['criteria_based_content_wont_be_copied'] = 'All associated courses and competencies will not be copied over in criteria-based paths.';
$string['criteria_fulfilled'] =  'Criteria fulfilled';
$string['criteriatype'] = 'Criteria type';
$string['crumbtrail_separator'] = ' / ';
$string['current_assignment_details'] = 'Current assignment details';
$string['current_assignment_progress'] = 'Current assignment progress';
$string['currently_assigned'] = 'Currently assigned';
$string['default_proficiency_value_override_header'] = 'Default override';
$string['deleted_audience'] = '(audience deleted)';
$string['deleted_organisation'] = '(organisation deleted)';
$string['deleted_position'] = '(position deleted)';
$string['deleted_user'] = '(user deleted)';
$string['description'] = 'Description';
$string['directly_assigned'] = 'Directly assigned';
$string['disabled'] = 'Disabled';
$string['display_achievement_level'] = 'Display achievement level and proficiency';
$string['done'] = 'Done';
$string['edit_competency'] = 'Edit competency: {$a}';
$string['edit_competency_title'] = '{$a->header} ({$a->tab})';
$string['edit_proficiency_bulk_action_label'] = 'Edit';
$string['edit_proficiency_bulk_modal_title'] = 'Edit proficiency value for {$a} assignment(s)';
$string['edit_proficiency_change_framework_warning'] = 'You can only edit proficiency value by assignment for competencies in the same framework. If you change the framework, all competencies you have selected will be removed.';
$string['edit_proficiency_default_indicator'] = '(Default)';
$string['edit_proficiency_remove_assignment_specific'] = 'Remove assignment-specific proficiency value';
$string['edit_proficiency_value_by_assignment'] = 'Edit proficiency value by assignment';
$string['edit_proficiency_value_by_assignment_help'] = 'The **Minimum required proficiency value** is the lowest value a user has to achieve to become proficient using this scale. All higher scale values are automatically classified as proficient values. The value set for the framework will be the default value, however assignment-specific proficiency values can be set here to override the default. ';
$string['edit_proficiency_value_by_assignment_updated'] = 'The proficiency value for {$a} assignments has been updated.';
$string['edit_proficiency_value_by_assignment_updated_single'] = 'The proficiency value for 1 assignment has been updated.';
$string['enable_performance_rating'] = 'Enable Performance activity rating';
$string['enable_performance_rating_help'] = 'Any competencies which participants can select must have \'Performance activity rating\' set as an achievement path.
If this hasn\'t been set, participants will be able to provide a \'final rating\', but it won\'t be submitted to the competency.';
$string['enable_performance_rating_participant'] = 'Rating participant';
$string['enable_performance_rating_participant_help'] = 'Only one performance activity rating will be collected and submitted to the competency. If there are multiple people in the participant role, the first rating submitted will be applied.';
$string['enablecompetency_assignment'] = 'Enable Competency Assignment';
$string['enablecompetency_assignment_desc'] = 'This option will let you: Enable(show)/Disable Competency Assignment feature on this site.';
$string['enabled'] = 'Enabled';
$string['error_archive_user_assignment'] = "You do not have the capability to archive this assignment.";
$string['error_cannot_queue_task'] = 'Unable to create adhoc task: {$a->task}';
$string['error_cant_undo_single_use'] = 'This pathway can only be used once per competency. To be able to restore this pathway, first remove the one added after removing this one.';
$string['error_competencies_out_of_sync'] = 'An error occurred with your selection. {$a} competencies were removed from your selection due to no longer being available for assignment.';
$string['error_copy_pathway_source_has_no_pathways'] = 'Achievement paths cannot be applied to your selected competencies, because the competency you are copying from has been modified. Please review the competency you want to copy from to see what has changed';
$string['error_copy_pathway_source_unknown'] = 'Source competency for pathway copying no longer exists';
$string['error_create_assignments'] = 'An error occurred during assignment creation, due to modifications to the competencies or user groups after you selected them. Your selection has been updated to reflect these changes – please verify before proceeding.';
$string['error_filter_assignment_not_supported'] = 'Filtering by "{$a}" is currently not supported';
$string['error_generic_mutation'] = 'An error occurred while saving.';
$string['error_invalid_assignment'] = 'Invalid assignment';
$string['error_invalid_configuration'] = 'The pathway configuration is invalid';
$string['error_missing_selected_competencies_plural'] = 'There are {$a->count} selected competencies that no longer exist';
$string['error_missing_selected_competencies_single'] = 'There is one selected competency that no longer exists';
$string['error_missing_selected_frameworks_plural'] = 'There are {$a->count} selected competency frameworks that no longer exist';
$string['error_missing_selected_frameworks_single'] = 'There is one selected competency framework that no longer exists';
$string['error_no_selected_competencies'] = 'No selected target competencies';
$string['error_processing_exception'] = 'Processing failed: {$a->message}';
$string['error_selected_competencies_not_in_frameworks_plural'] = '{$a->count} selected competencies are not in expected frameworks';
$string['error_selected_competencies_not_in_frameworks_single'] = '1 selected competency is not in expected framework';
$string['event_assignment_activated'] = 'Competency assignment activated';
$string['event_assignment_archived'] = 'Competency assignment archived';
$string['event_assignment_created'] = 'Competency assignment created';
$string['event_assignment_deleted'] = 'Competency assignment deleted';
$string['event_assignment_min_proficiency_override_updated'] = 'Competency assignment minimum proficiency override updated';
$string['event_assignment_user_archived'] = 'User competency assignment archived';
$string['event_assignment_user_assigned'] = 'User competency assignment assigned';
$string['event_assignment_user_unassigned'] = 'User competency assignment unassigned';
$string['event_linked_courses_updated'] = 'Linked courses updated';
$string['event_pathways_copied'] = 'Pathways copied';
$string['example_competency_description'] = 'This is an example of how a competency will display after a participant has selected it.';
$string['example_competency_title'] = 'Competency example';
$string['expand_assignments_task'] = 'Expand competencies to users relation for competency assignment';
$string['expand_task_notification_body'] = 'All users assigned to competencies have been synced.';
$string['expand_task_notification_subject'] = 'Competency assignments: Sync assigned users task is complete';
$string['filter'] = 'Filter';
$string['filter_assignment_status'] = 'Assignment status';
$string['filter_assignment_status_assigned'] = 'Assigned';
$string['filter_assignment_status_unassigned'] = 'Unassigned';
$string['filter_assignment_type_all'] = 'All types';
$string['filter_competencies'] = 'Filter competencies';
$string['filter_competencies_search_label'] = 'Filter items by search';
$string['filter_competency_type'] = 'Competency type';
$string['filter_framework'] = 'Competency framework';
$string['filter_framework_all'] = 'All frameworks';
$string['filter_framework_all_frameworks'] = 'All competency frameworks';
$string['filter_select_competency_framework'] = 'Select competency framework';
$string['filter_status'] = 'Activation status';
$string['filter_status_active'] = 'Active competency assignments';
$string['filter_status_all'] = 'All competency assignments';
$string['filter_status_archived'] = 'Archived competency assignments';
$string['filter_status_draft'] = 'Draft competency assignments';
$string['filter_user_group_cohort'] = 'Audience';
$string['filter_user_group_organisation'] = 'Organisation';
$string['filter_user_group_position'] = 'Position';
$string['filter_viewing_by_assignment'] = 'Select an assignment to Filter the list';
$string['framework'] = 'Framework';
$string['fullname'] = 'Full name';
$string['general'] = 'General';
$string['header_archived_date'] = 'Archived date';
$string['header_assignment_reasons'] = 'Reason assigned';
$string['header_assignment_status'] = 'Status';
$string['header_assignment_type'] = 'Assignment type';
$string['header_competencies'] = 'Competencies';
$string['header_competency'] = 'Competency';
$string['header_competency_name'] = 'Competency name';
$string['header_pathway_warning_message'] = '';
$string['header_reason_assigned'] = 'Reason assigned';
$string['header_status'] = 'Status';
$string['idnumber'] = 'ID number';
$string['individual'] = 'Individual';
$string['invalid_section'] = 'Invalid section {$a}';
$string['is_not_proficient_value'] = 'This value is not proficient.';
$string['is_proficient_value'] = 'This value is proficient.';
$string['latest_achievement'] = 'Latest achievement';
$string['legacy_assignment_rating_description'] = 'These include learning plans, course completion, or proficiency in child competencies, in previous versions of the system.';
$string['legacy_assignment_rating_discontinued'] = 'This rating was determined through methods which have been discontinued.';
$string['link_default_preset'] = 'Link default preset';
$string['linked_courses'] = 'Linked courses';
$string['linked_courses_saved'] = 'Linked courses have been saved';
$string['linkedcourses_mustsavechange'] = 'Changes must be saved before they will be applied';
$string['load_more'] = 'Load more';
$string['loading'] = 'Loading...';
$string['mandatory'] = 'Mandatory';
$string['menu_title_my_competencies'] = 'Competencies';
$string['messageprovider:expand_task_finished'] = 'Sync assigned users finished';
$string['messageprovider:no_longer_proficient'] = 'No longer proficient';
$string['min_required_proficiency_value'] = 'Minimum required proficiency value';
$string['more_information'] = 'More information';
$string['my_competency_profile'] = '{$a} Competency profile';
$string['n_competencies_selected'] = 'You have selected {$a} competencies to assign.';
$string['next'] = 'Next';
$string['no_achievement_criteria'] = "No achievement criteria have been set for this competency";
$string['no_active_assignments'] = 'There are no active assignments';
$string['no_competencies_assigned'] = 'There are no competencies currently assigned.';
$string['no_competencies_found'] = 'No competencies found';
$string['no_competency_to_assign'] = 'There are no competencies available to assign.';
$string['no_courses_linked_yet'] = 'No courses linked yet';
$string['no_current_assignments_other'] = 'This user has no current assignments';
$string['no_current_assignments_self'] = 'You have no current assignments';
$string['no_description'] = 'No description';
$string['no_longer_proficient_notification_html_body'] = 'There has been a change on the competency "{$a->competency_name}" and you are no longer considered proficient in it. This could be because of a change to your overall achievement level (currently "{$a->current_rating}"), or to settings on the competency itself. For more information, view the <a href="{$a->link_to_competency_activity_log}">competency\'s activity log</a>.';
$string['no_longer_proficient_notification_subject'] = 'You are no longer proficient in the competency {$a}';
$string['no_longer_proficient_notification_text_body'] = 'There has been a change on the competency "{$a->competency_name}" and you are no longer considered proficient in it. This could be because of a change to your overall achievement level (currently "{$a->current_rating}"), or to settings on the competency itself. For more information, view the competency\'s activity log: {$a->link_to_competency_activity_log}';
$string['no_paths'] = 'No achievement paths added';
$string['no_pathways_for_copying'] = 'There are no achievement paths for the selected competency. To add achievement paths, go to the <a href="{$a->competency}">competency</a>';
$string['no_such_user_error_message'] = 'The requested user does not exist.';
$string['no_user_groups'] = 'No assignments';
$string['no_value_achieved'] = 'No value achieved';
$string['none'] = 'None';
$string['not_assigned'] = 'Not assigned';
$string['not_proficient'] = 'Not proficient';
$string['notification_self_assignment_successful_plural'] = '{$a} competencies have been assigned.';
$string['notification_self_assignment_successful_singular'] = '1 competency has been assigned.';
$string['off'] = 'Off';
$string['one_competency_selected'] = 'You have selected 1 competency to assign.';
$string['optional'] = 'Optional';
$string['or'] = 'or';
$string['overall_rating_calc'] = 'Overall rating calculation';
$string['overview'] = 'Overview';
$string['pathtype'] = 'Path type';
$string['perform_overview_last_update_description'] = 'Competency achievement level was updated to \'{$a->scale_value_name}\'.';
$string['perform_overview_last_update_description_not_started'] = 'Competency achievement level was updated to \'not started\'.';
$string['perform_overview_not_started'] = 'Not started';
$string['perform_rating_label'] = 'Final rating to be submitted for the competency';
$string['perform_rating_label_help'] = 'Only one performance activity rating will be collected and submitted to the competency. If there are multiple people in this role, the first rating submitted will be applied.';
$string['perform_review_competency_assignment_missing'] = 'The assignment for this competency no longer exists';
$string['perform_review_competency_missing'] = 'This competency no longer exists';
$string['pluginname'] = 'Competencies';
$string['proficiency_level'] = 'Proficiency level';
$string['proficiency_not_achieved'] = 'Proficiency not achieved';
$string['proficiency_status'] = 'Proficiency status';
$string['proficient'] = 'Proficient';
$string['proficient_level'] = 'Proficient level';
$string['proficient_on'] = 'Proficient {$a}';
$string['progress_name_by_user'] = '{$a->progress_name} by {$a->user_fullname_role}';
$string['rate_others_competencies'] = 'Rate others\' competencies';
$string['rating_none'] = 'None';
$string['rating_scale'] = 'Rating scale';
$string['rating_to_be_submitted'] = 'Final rating to be submitted for the competency';
$string['rating_value'] = 'Rating value {$a}';
$string['reason_assigned'] = 'Reason assigned';
$string['remove_competency'] = 'Remove competency';
$string['remove_condition_failed:already_rated'] = 'Cannot remove review item; already rated';
$string['remove_linked_course'] = 'Remove linked course';
$string['removed_linked_course'] = 'Removed linked course';
$string['replace_all_competency_paths'] = 'Replace all';
$string['save_activate_assignments'] = 'Activate assignments on creation';
$string['save_create_assignments'] = 'Create assignments';
$string['save_modal_body'] = '{$a} competency assignments will be created.';
$string['save_modal_header'] = 'Confirm competency assignment creation';
$string['save_modal_question'] = 'Do you want to proceed with competency assignment creation?';
$string['savechanges'] = 'Save changes';
$string['scale_description_dummy_text'] = 'Scale description {$a}';
$string['search_competencies_by_name'] = 'Search competencies by name';
$string['search_competencies_descriptive'] = 'Search for competencies to self-assign';
$string['search_courses'] = 'Search courses';
$string['search_results'] = 'Search results';
$string['select_competencies'] = 'Select competencies';
$string['select_courses'] = 'Select courses';
$string['select_target_competencies'] = 'Select target competencies';
$string['selected_competencies'] = 'Selected competencies';
$string['selected_competency'] = 'Competency: {$a}';
$string['selected_items_label'] = 'Selected: {$a}';
$string['self_assign_competencies'] = 'Self-assign competencies';
$string['settings_continuous_tracking'] = 'Continuous achievement tracking';
$string['settings_continuous_tracking_description'] = 'Users\' achievement progress, rating and proficiency status are only tracked while they are assigned to a competency, and tracking ceases once they are unassigned. Enabling continuous achievement tracking will ensure that unassigned users who have no other active assignments to the competency can continue to be tracked after unassignment via a new individual assignment generated for them by the system.';
$string['settings_continuous_tracking_disabled'] = 'Disabled';
$string['settings_continuous_tracking_enabled'] = 'Enabled';
$string['settings_legacy_aggregation_method'] = 'Competency status behaviour';
$string['settings_legacy_aggregation_method_description'] = 'When \'Highest value\' is selected, if proficiency has been achieved through course completion or proficiency in child competencies, any subsequent manual ratings awarding a lower scale value will be overruled, returning competency status to the minimum proficient value on the next cron run.<br /><br />When \'Latest value\' is selected, the user\'s competency status will always reflect the latest change – equal to the minimum proficient value if triggered by course completion or proficiency in child competencies, or the specific scale value selected by a manual rater.<br /><br />Changes to this setting will be applied to existing competency statuses, which could result in updated values and proficiency statuses.';
$string['settings_legacy_aggregation_method_highest'] = 'Highest value';
$string['settings_legacy_aggregation_method_latest'] = 'Latest value';
$string['settings_unassign_behaviour'] = 'User assignment and record';
$string['settings_unassign_behaviour_delete'] = 'Delete always (regardless of whether user has achieved a rating or not)';
$string['settings_unassign_behaviour_description'] = '<p><strong>"Archive"</strong> means that a record that the user was assigned to the competency will be kept, as well as any achievement, rating and proficiency status recorded for them while assigned. Once archived, achievement progress on the competency will no longer be tracked.</p><p><strong>"Delete"</strong> means that all data about their assignment, and related achievement, rating and proficiency status will be deleted permanently.</p>';
$string['settings_unassign_behaviour_keep'] = 'Archive always (regardless of whether user has achieved a rating or not)';
$string['settings_unassign_behaviour_keep_not_null'] = 'Archive ONLY IF user has achieved a rating in the competency (otherwise delete)';
$string['settings_unassignment_header'] = 'Automatic user unassignment behaviour';
$string['settings_unassignment_text'] = 'Configuration for determining the consequences of a user being unassigned from a competency due to them losing membership of an assigned audience, being removed from an assigned position or organisation, or their assigned audience, position or organisation being deleted.';
$string['single_value_paths'] = 'Criteria-based paths';
$string['single_value_proficient_mark'] = 'Proficient';
$string['single_value_proficient_mark_help'] = 'Proficient values marked with';
$string['sort'] = 'Sort by';
$string['sort_alphabetical'] = 'Alphabetical';
$string['sort_competency_name'] = 'Competency name';
$string['sort_framework_hierarchy'] = 'Framework hierarchy';
$string['sort_most_recently_updated'] = 'Most recently updated';
$string['sort_recently_archived'] = 'Recently archived';
$string['sort_recently_assigned'] = 'Recently assigned';
$string['sort_user_group_name'] = 'User group name';
$string['status_0'] = 'Active';
$string['status_1'] = 'Draft';
$string['status_2'] = 'Deleted';
$string['status_active'] = 'Active';
$string['status_active_alt'] = 'Current assignments';
$string['status_archived'] = 'Archived';
$string['status_archived_alt'] = 'Archived assignments';
$string['status_draft'] = 'Draft';
$string['superseded'] = 'Superseded';
$string['sync_is_scheduled'] = 'The sync task has already been scheduled – it is running in the background, and you will be notified once it is finished. You will be able to schedule a new sync task once the current one is complete.';
$string['sync_success'] = 'Sync was successfully initiated. It is running in the background, and you will be notified once it is finished.';
$string['table'] = 'Table';
$string['title_create'] = 'Create assignments';
$string['title_index'] = 'Manage competency assignments';
$string['title_tool_menu'] = 'Competency assignments';
$string['title_users'] = 'Currently assigned users';
$string['toast_error_generic_update'] = 'An error occurred, and your latest changes have not been saved.';
$string['toggle_charts'] = 'Show charts';
$string['toggle_competency_view_format'] = 'Display formats';
$string['toggle_table'] = 'Show tables';
$string['type'] = 'Type';
$string['unassigned'] = 'Unassigned';
$string['undo_remove_linked_course'] = 'Undo remove linked course';
$string['unsaved_changes_warning'] = 'Your unsaved changes will be lost.';
$string['user_assignment_page_heading_other'] = 'Assign competencies';
$string['user_assignment_page_heading_self'] = 'Self-assign competencies';
$string['user_assignment_page_title_other'] = 'Competency assignment';
$string['user_assignment_page_title_self'] = 'Self assignment';
$string['user_competency_profile'] = '{$a}\' competency profile';
$string['user_group_name'] = 'Assigned user group';
$string['user_group_type_cohort'] = 'Audience';
$string['user_group_type_organisation'] = 'Organisation';
$string['user_group_type_position'] = 'Position';
$string['user_groups_empty'] = 'No user groups added';
$string['user_groups_selected'] = 'user groups';
$string['userdataitemachievement'] = 'Achievement records';
$string['userdataitemachievement_help'] = 'When purging, the user\'s achievement data will be removed. However, after purging is complete, the records may be added back again if they still meet the criteria. For instance, if a user has completed a course that is linked to a competency, then an achievement record will be created again despite being purged previously.';
$string['userdataitemassignment_user'] = 'Competency assignments';
$string['userdataitemassignment_user_help'] = 'This includes individual assignments and assignments due to the user being a member of an audience, being in a position or in an organisation. When purging, any achievement data associated with the assignments will also be purged (even if these data items are not selected). After purging, group-based assignments may be dynamically created again, if they user still meets the criteria for the assignment (by being a member of a group).';
$string['users_to_assign'] = 'Users to assign';
$string['view_child_competencies'] = 'View child competencies';
$string['view_child_competencies_of_x'] = 'View child competencies of ‘{$a}’';
$string['view_selected_competencies'] = 'View selected competencies';
$string['viewing'] = 'Viewing';
$string['viewing_by_assignment'] = 'Viewing by assignment';
$string['warning_pending_aggregation_detail'] = 'There is a task scheduled to update this competency, which may result in a change to proficiency.';
$string['warning_pending_aggregation_profile'] = 'There is a task scheduled to update one or more of these competencies. This may result in a change to proficiency.';
$string['ways_to_achieve_proficiency'] = 'Ways to achieve proficiency in this competency';
$string['without_achievement_paths'] = 'Without achievement paths';
$string['work_towards_level'] = 'Work towards level';
$string['yes_short'] = 'Y';
