<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2021 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author  Kian Nguyen <kian.nguyen@totaralearning.com>
 * @package contentmarketplace_linkedin
 */
namespace contentmarketplace_linkedin\event;

use coding_exception;
use context_system;
use core\entity\user;
use core\event\base;

abstract class base_import_event extends base {
    /**
     * @return void
     */
    protected function init(): void {
        $this->data['edulevel'] = self::LEVEL_TEACHING;
        $this->data['crud'] = 'c';

        $this->context = context_system::instance();
    }

    /**
     * @param int|null $user_id
     * @return int
     */
    protected static function get_user_id(?int $user_id): int {
        if (!empty($user_id)) {
            return $user_id;
        }

        $user = user::logged_in();
        if (null === $user) {
            throw new coding_exception("There is no user in the session");
        }

        return $user->id;
    }
}