<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package totara
 * @subpackage totara_core
 *
 * totara_core specific language strings.
 * these should be called like get_string('key', 'totara_core');
 * @note Automatically cleaned: 2024-09-24

 */
$string['a11y_achievedrequiredgoal'] = 'Achieved required goal';
$string['a11y_achievement_target_with_status'] = 'Achievement target. Status: {$a}';
$string['a11y_active_filter_type'] = '{$a} active filter type';
$string['a11y_active_filter_type_plural'] = '{$a} active filter types';
$string['a11y_additional_filters'] = 'Additional filters: {$a} applied';
$string['a11y_click_to'] = 'click to';
$string['a11y_filter_panel_desc'] = 'The following options are used to filter the result data';
$string['a11y_hide_filters'] = 'Hide filters. {$a} applied';
$string['a11y_more_filters'] = 'More filter options';
$string['a11y_reset_all_filters'] = 'Reset all filters';
$string['a11y_row_details'] = '{$a} details';
$string['a11y_select_tree_button_label'] = 'Select a {$a->title}: {$a->selected} is selected';
$string['a11y_show_filters'] = 'Show filters. {$a} applied';
$string['a11y_skip_to_main_content'] = 'Skip to main content';
$string['a11y_toggle_view'] = 'Toggle between narrow and wide view';
$string['a11y_tree_region_summary'] = '{$a->label} {$a->position} of {$a->siblings} in level {$a->depth}';
$string['a11y_treeview_collapse_item'] = 'Hide children of {$a}';
$string['a11y_treeview_expand_item'] = 'Show children of {$a}';
$string['a11y_treeview_select_item'] = 'Select {$a}';
$string['a11y_treeview_deselect_item'] = 'Deselect {$a}';
$string['a11yachievedrequiredgoal'] = 'Achieved required goal';
$string['a11yachievementtarget'] = 'Achievement target';
$string['accordion:accordionitem'] = 'Accordion Item';
$string['accordion_aria_expand'] = 'Expand {$a}';
$string['activate'] = 'Activate';
$string['activeusercountstr'] = '{$a->activeusers} users have logged in to this site in the last year ({$a->activeusers3mth} in the last 3 months)';
$string['activitycompletionunlockednoresettext'] = 'Completion has been unlocked without deleting activity completion data. After this change different users may have received their completion status for different reasons.';
$string['activitycompletionunlockedtext'] = 'When you save changes, completion state for all learners who have completed this activity will be erased. If you change your mind about this, do not save the form.';
$string['add'] = 'Add';
$string['add_audiences'] = 'Add audiences';
$string['add_individuals'] = 'Add individuals';
$string['add_learning'] = 'Add learning';
$string['add_organisation'] = 'Add organisation';
$string['add_position'] = 'Add position';
$string['addanothercolumn'] = 'Add another column...';
$string['adder_browse'] = 'Browse all';
$string['adder_selection'] = 'Selected';
$string['adder_selection_with_count'] = 'Selected {$a->count}';
$string['addextended'] = 'Add {$a}';
$string['all'] = 'All';
$string['allchildren'] = 'All children';
$string['allf2fbookings'] = 'All Seminar Bookings';
$string['alllearningrecords'] = 'All Learning Records';
$string['allmycourses'] = 'All My Courses';
$string['allteammembers'] = 'All Team Members';
$string['ally_status_with_value'] = 'Status: {$a}.';
$string['alreadyselected'] = '(already selected)';
$string['alttext'] = 'Logo alternative text';
$string['alttextdesc'] = 'The text that is displayed when an image can\'t be. This text is also read by a screen reader.';
$string['ampersand'] = 'and';
$string['analyzetabletask'] = 'Execute analyze table command to analyse context and context_map tables';
$string['and_separator'] = 'And';
$string['archive'] = 'Archive';
$string['archivecompletionrecords'] = 'Archive completion records';
$string['assessments'] = 'Assessments';
$string['assessmenttype'] = 'Assessment Type';
$string['assessor'] = 'Assessor';
$string['assessorname'] = 'Assessor Name';
$string['assigneduser'] = 'Assigned users';
$string['assignedvia'] = 'Assigned Via';
$string['assigngroup'] = 'Assign User Group';
$string['assigngrouptype'] = 'Assignment Type';
$string['assignincludechildren'] = ' and all below';
$string['assignincludechildrengroups'] = 'Include Child Groups?';
$string['assignnumusers'] = 'Assigned Users';
$string['assignsourcename'] = 'Assigned Group';
$string['assignuser'] = 'Individual assignment';
$string['audionotsupported'] = 'Your browser does not support audio';
$string['authdeleteusers'] = 'User deletion';
$string['authdeleteusers_desc'] = 'Select what happens when user account is deleted. During full delete username, email and ID number are discarded - this means that accounts cannot be undeleted later. Please note that any user delete operation discards settings and user information.';
$string['authdeleteusersfull'] = 'Full (legacy)';
$string['authdeleteusersfullproper'] = 'Full with random username';
$string['authdeleteuserspartial'] = 'Keep username, email and ID number (legacy)';
$string['awaiting_selection_text'] = 'Awaiting learning selection from a {$a}';
$string['basket_error_limit'] = 'The items cannot be added to the basket as you would exceed the limit of {$a} items allowed.';
$string['bi'] = 'Business intelligence';
$string['blended'] = 'Blended';
$string['bookings'] = 'Bookings';
$string['bookingsforheading'] = 'Bookings for {$a}';
$string['browse'] = 'Browse';
$string['browsecategories'] = 'Browse Categories';
$string['button_loading_text'] = '{$a} (loading)';
$string['cachedef_completion_progressinfo'] = 'Completion progressinfo cache';
$string['cachedef_flex_icons'] = 'Flex icons';
$string['cachedef_hookwatchers'] = 'Hook watchers';
$string['cachedef_quickaccessmenu'] = 'Admin menu preferences cache';
$string['cachedef_quickaccessmenu_complete'] = 'Quick access menu item cache';
$string['cachedef_totara_course_is_viewable'] = 'Totara course is viewable request cache';
$string['cachedef_visible_content'] = 'Visible category, course, program and certification cache';
$string['calendar'] = 'Calendar';
$string['cannotdownloadtotaralanguageupdatelist'] = 'Cannot download list of language updates from download.totaralms.com';
$string['cannotundeleteuser'] = 'Cannot undelete user';
$string['clear_search_term'] = 'Clear this search term';
$string['clearall'] = 'Clear all';
$string['clearselection'] = 'Clear selection';
$string['clickfordetail'] = 'Click here for more details';
$string['close'] = 'Close';
$string['cloudconfigoverride'] = 'This setting is not available on Totara cloud.';
$string['collapseall_with_title'] = 'Collapse all {$a}';
$string['collapsible_sections'] = 'Collapsible sections';
$string['collapsible_sections_collapse_all'] = 'Include an expand/collapse all link';
$string['collapsible_sections_help'] = 'Enable collapsable sections within the course.';
$string['column'] = 'Column';
$string['competency_typeicon'] = 'Competency type icon';
$string['completed'] = 'Completed';
$string['completedwarningtext'] = 'Modifying activity completion criteria after some users have already completed the activity is not recommended as it can lead to different users being marked as completed for different reasons.<br />
At this point you can choose to delete all completion records for users who have achieved completion in either this activity or this course. Their completion status for both this activity and this course will be recalculated next time cron runs and they may be marked as complete again.<br />
Alternatively you can choose to keep all existing completion records and accept that different users may have received their status for different accomplishments.';
$string['completionexcludefailuresoff'] = 'Users may complete activities in any way, failures are acceptable.';
$string['completionexcludefailureson'] = 'Users have to complete activities without failures.';
$string['configdynamicappraisals'] = 'When enabled this allows you to specify whether appraisals lock on activation and no longer update assignments and roles or continue to update after activation';
$string['configdynamicappraisalsautoprogress'] = 'When legacy dynamic appraisals is enabled, this setting allows you to specify whether appraisals will automatically progress to the next stage if one or more roles are empty (assuming all filled roles are complete and there is at least one role filled). When Dynamic Appraisals is not enabled, appraisals will automatically progress.';
$string['configforcelogintotara'] = 'Normally, the entire site is only available to logged in users. If you would like to make the front page and the course listings (but not the course contents) available without logging in, then you should uncheck this setting.';
$string['copy_all'] = 'Copy all';
$string['core:appearance'] = 'Configure site appearance settings';
$string['core:archiveenrolledcourseprogress'] = 'Archive completion and progress for all enrolled users in a course';
$string['core:archivemycourseprogress'] = 'Archive my completion and progress in a course';
$string['core:archiveusercourseprogress'] = 'Archive a user\'s completion and progress in a course';
$string['core:coursemanagecustomfield'] = 'Manage a course custom field';
$string['core:delegateownmanager'] = 'Assign a temporary manager to yourself';
$string['core:delegateusersmanager'] = 'Assign a temporary manager to other users';
$string['core:editmainmenu'] = 'Edit Main menu';
$string['core:editownquickaccessmenu'] = 'Edit your own quick access menu';
$string['core:langconfig'] = 'Edit language settings';
$string['core:manageprofilefields'] = 'Manage profile fields';
$string['core:markusercoursecomplete'] = 'Mark another user\'s courses as complete';
$string['core:modconfig'] = 'Configure activity modules';
$string['core:programmanagecustomfield'] = 'Manage a program custom field';
$string['core:seedeletedusers'] = 'See deleted users';
$string['core:undeleteuser'] = 'Undelete user';
$string['core:updateuseridnumber'] = 'Update user ID number';
$string['core:viewrecordoflearning'] = 'View a learners Record of Learning';
$string['couldntreaddataforblockid'] = 'Could not read data for blockid={$a}';
$string['couldntreaddataforcourseid'] = 'Could not ready data for courseid={$a}';
$string['count'] = '( {$a} )';
$string['course_regrade_needed'] = "Grades are now being re-aggregated due to the additional activity.";
$string['course_regrade_not_complete'] = 'This report shows partial results while we re-aggregate activity grades. Please refresh the page in a few minutes. If this problem persists, contact the site administrators for help.';
$string['coursecategoryicon'] = 'Category icon';
$string['coursecompletion'] = 'Course completion';
$string['coursecompletionsfor'] = 'Course Completions for ';
$string['courseduedate_fixed'] = 'Fixed date:';
$string['courseduedate_relative'] = 'Relative date:';
$string['courseduedate_relative_error'] = 'Relative date must be at least 1 day';
$string['courseduex'] = 'Course due {$a}';
$string['courseicon'] = 'Course icon';
$string['coursename'] = 'Course name';
$string['courses'] = 'Courses';
$string['coursetype'] = 'Course Type';
$string['cronscheduleregularity'] = 'Your cron is not run very regularly. We recommend configuring the cron to run every minute, this way scheduled tasks will run as configured below and system load will be minimised.';
$string['csvdateformat'] = 'CSV Import date format';
$string['csvdateformatconfig'] = 'Date format to be used in CSV imports like user uploads with date custom profile fields, or HR Import.

The date format should be compatible with the formats defined in the <a target="_blank" href="http://www.php.net/manual/en/datetime.createfromformat.php">PHP DateTime class</a>

Examples:
<ul>
<li>d/m/Y if the dates in the CSV are of the form 21/03/2012</li>
<li>d/m/y if the dates in the CSV have 2-digit years 21/03/12</li>
<li>m/d/Y if the dates in the CSV are in US form 03/21/2012</li>
<li>Y-m-d if the dates in the CSV are in ISO form 2012-03-21</li>
</ul>';
$string['csvdateformatdefault'] = 'd/m/Y';
$string['currenticon'] = 'Current icon';
$string['currentlyselected'] = 'Currently selected';
$string['customicons'] = 'Custom icons';
$string['dailyat'] = 'Daily at';
$string['datatable:oPaginate:sFirst'] = 'First';
$string['datatable:oPaginate:sLast'] = 'Last';
$string['datatable:oPaginate:sNext'] = 'Next';
$string['datatable:oPaginate:sPrevious'] = 'Previous';
$string['datatable:sEmptyTable'] = 'No data available in table';
$string['datatable:sInfo'] = 'Showing _START_ to _END_ of _TOTAL_ entries';
$string['datatable:sInfoEmpty'] = 'Showing 0 to 0 of 0 entries';
$string['datatable:sInfoFiltered'] = '(filtered from _MAX_ total entries)';
$string['datatable:sInfoPostFix'] = '';
$string['datatable:sInfoThousands'] = ',';
$string['datatable:sLengthMenu'] = 'Show _MENU_ entries';
$string['datatable:sLoadingRecords'] = 'Loading...';
$string['datatable:sProcessing'] = 'Processing...';
$string['datatable:sSearch'] = 'Search:';
$string['datatable:sZeroRecords'] = 'No matching records found';
$string['date_range_after_date'] = '{$a->value} {$a->range} after date';
$string['date_range_before_date'] = '{$a->value} {$a->range} before date';
$string['date_range_days'] = 'days';
$string['date_range_type_input'] = 'Date range type';
$string['date_range_weeks'] = 'weeks';
$string['datepickerattime'] = 'at';

/**
 * The following date picker strings should only be used in relation to date pickers! If you want the particular format that one
 */

/**
 * of them is using, you should probably use something from langconfig.php or define your own string.
 */
$string['datepickerlongyeardisplayformat'] = 'dd/mm/yy';
$string['datepickerlongyearparseformat'] = 'd/m/Y';
$string['datepickerlongyearphpuserdate'] = '%d/%m/%Y';
$string['datepickerlongyearplaceholder'] = 'dd/mm/yyyy';
$string['datepickerlongyearregexjs'] = '[0-3][0-9]/(0|1)[0-9]/[0-9]{4}';
$string['datepickerlongyearregexphp'] = '@^(0?[1-9]|[12][0-9]|3[01])/(0?[1-9]|1[0-2])/([0-9]{4})$@';
$string['day'] = 'Day';
$string['days'] = 'Day(s)';
$string['days_before'] = '{$a} days before';
$string['dbmemoizeinfo'] = 'Database memoization disabled';
$string['dbmemoizerestrictedpg'] = 'The enable_memoize PostgreSQL database configuration setting must be off.';
$string['dbversionunsupported'] = 'Unsupported DB version';
$string['debugstatus'] = 'Debug status';
$string['default_collapse_state'] = 'Default collapse state';
$string['default_collapse_state_auto'] = 'Auto (collapsed unless first)';
$string['default_collapse_state_collapsed'] = 'Collapsed';
$string['default_collapse_state_expanded'] = 'Expanded';
$string['delete'] = 'Delete';
$string['deletecompletionlogs'] = 'Delete course completion logs after';
$string['deletecompletionlogs_help'] = 'Use this setting if you wish to reduce database size. Once deleted, these logs will no longer show as transaction history in course completion editor.';
$string['deletecompletionorphanstask'] = 'Cleanup orphaned course completion data';
$string['deletecoursestask'] = 'Course delete task';
$string['deleted'] = 'Deleted';
$string['deleteextended'] = 'Delete {$a}';
$string['deleteusercheckfull'] = 'Are you absolutely sure you want to completely delete {$a} ?<br />All associated data, including but not limited to the following, will be deleted and is not recoverable:
<ul>
<li>appraisals where the user is in the learner role</li>
<li>grades</li>
<li>tags</li>
<li>roles</li>
<li>preferences</li>
<li>user custom fields</li>
<li>private keys</li>
<li>customised pages</li>
<li>facetoface signups</li>
<li>feedback360 assignments and responses</li>
<li>position assignments</li>
<li>programs & certifications</li>
<li>goals</li>
<li>evidence items</li>
<li>scheduled reports</li>
<li>reminders</li>
<li>will be unenroled from courses</li>
<li>will be unassigned from manager, appraiser and temp manager positions</li>
<li>will be removed from audiences</li>
<li>will be removed from groups</li>
<li>messages will be marked as read</li>
</ul>
If you wish to retain any data you may wish to consider suspending the user instead.';
$string['details'] = 'Details';
$string['directchildren'] = 'Direct children';
$string['disablefeature'] = 'Disable';
$string['download_attachment'] = 'Download attachment';
$string['downloaderrorlog'] = 'Download error log';
$string['downloadregistrationdata'] = 'Download encrypted registration data';
$string['dragdrop_announce_drop_cancel'] = 'Movement cancelled. The item has returned to its original position of {$a->from_position}.';
$string['dragdrop_announce_drop_other'] = 'You have dropped the item. It has moved from position {$a->from_position} in list {$a->from_source_name} to list position {$a->to_position} in {$a->to_source_name}.';
$string['dragdrop_announce_drop_same'] = 'You have dropped the item. It has moved from position {$a->from_position} to position {$a->to_position}.';
$string['dragdrop_announce_drop_unknown'] = 'You have dropped the item. It has moved from position {$a->from_position} in a list to position {$a->to_position} in a different list.';
$string['dragdrop_announce_lift'] = 'You have lifted an item at position {$a->from_position}.';
$string['dragdrop_announce_move_null'] = 'You have restored the item at position {$a->from_position}.';
$string['dragdrop_announce_move_other'] = 'You have moved the item from position {$a->from_position} in list {$a->from_source_name} to list position {$a->to_position} in {$a->to_source_name}.';
$string['dragdrop_announce_move_same'] = 'You have moved the item from position {$a->from_position} to position {$a->to_position}.';
$string['dragdrop_announce_move_unknown'] = 'You have moved the item from position {$a->from_position} in a list to position {$a->to_position} in a different list.';
$string['dragdrop_announce_no_drop'] = 'The item cannot be dropped here.';
$string['dragdrop_draggable_description'] = 'Draggable item';
$string['dragdrop_draggable_instructions'] = 'Press space bar to start a drag. When dragging you can use the arrow keys to move the item around, escape to cancel, and space bar again to drop.';
$string['duedate'] = 'Due date';
$string['duedate_help'] = 'Use due dates to assign each learner a date by which they are expected to complete this course, and keep them engaged with due date notifications.

- **None:** No due date notifications will be sent
- **Relative date:** Individual due dates for every learner, based on course completion tracking
- **Fixed date:** One due date for all learners in this course.

Learners are able to enter the course after the due date. To manage due date notifications go to Course administration: Notifications.';
$string['dynamicappraisals'] = 'Legacy dynamic appraisals';
$string['dynamicappraisalsautoprogress'] = 'Legacy dynamic appraisals automatic progression';
$string['editheading'] = 'Edit the Report Heading Block';
$string['edition'] = 'Edition';
$string['edittheme'] = 'Edit {$a} theme';
$string['editthemetenant'] = 'Tenant branding - {$a}';
$string['elearning'] = 'E-learning';
$string['elementlibrary'] = 'Element Library';
$string['emptyassignments'] = 'No assignments';
$string['enabled'] = 'Enabled';
$string['enabledisabletotarasync'] = 'Select Enable or Disable and then click continue to update HR Import for {$a}';
$string['enablefeature'] = 'Enable';
$string['enableflexiconsinfo'] = 'Enable rendering of icons using Flexible Icons API where possible.';
$string['enableprogramextensionrequests'] = 'Enable program extension requests';
$string['enableprogramextensionrequests_help'] = 'When enabled extension requests can be turned on for individual programs. This allows the program assignee to request an extension to the due date for a program. This extension can then be accepted or denied by the assignees manager.';
$string['enableteam'] = 'Enable Team';
$string['enableteam_desc'] = 'When enabled, all links, menus, tabs, and options related to Team will be accessible.';
$string['enrolled'] = 'Enrolled';
$string['error:ajax'] = 'An unexpected error occurred while attempting to contact the server.';
$string['error:assigncannotdeletegrouptypex'] = 'You cannot delete groups of type {$a}';
$string['error:assignmentbadparameters'] = 'Bad parameter array passed to dialog set_parameters';
$string['error:assignmentgroupnotallowed'] = 'You cannot assign groups of type {$a->grouptype} to {$a->module}';
$string['error:assignmentmoduleinstancelocked'] = 'You cannot make changes to an assignment module instance which is locked';
$string['error:assignmentprefixnotfound'] = 'Assignment class for group type {$a} not found';
$string['error:assigntablenotexist'] = 'Assignment table {$a} does not exist!';
$string['error:autoupdatedisabled'] = 'Automatic checking for updates is currently disabled in Totara';
$string['error:cannotmanagereminders'] = 'You do not have permission to manage reminders';
$string['error:cannotupgradefromnewermoodle'] = 'You cannot upgrade to Totara {$a->newtotaraversion} from this version of Moodle. Please use a newer version of Totara which is based on Moodle core {$a->oldversion} or above.';
$string['error:cannotupgradefromnewertotara_specific'] = 'You cannot downgrade from {$a->oldversion} (Version: {$a->oldcfgversion}) to {$a->newversion} (Version: {$a->newcfgversion}).';
$string['error:categoryidincorrect'] = 'Category ID was incorrect';
$string['error:columntypenotfound'] = 'The column type \'{$a}\' was defined but is not a valid option. This can happen if you have deleted a custom field or hierarchy depth level. The best course of action is to delete this column by pressing the red cross to the right.';
$string['error:columntypenotfound11'] = 'The column type \'{$a}\' was defined but is not a valid option. This can happen if you have deleted a custom field or hierarchy type. The best course of action is to delete this column by pressing the red cross to the right.';
$string['error:couldnotcreatedefaultfields'] = 'Could not create default fields';
$string['error:couldnotupdatereport'] = 'Could not update report';
$string['error:courseidincorrect'] = 'Course id is incorrect.';
$string['error:dashboardnotfound'] = 'Cannot fully initialize page - could not retrieve dashboard details';
$string['error:dialoggenericerror'] = 'An error has occurred';
$string['error:dialognotreeitems'] = 'No items available';
$string['error:duplicaterecordsdeleted'] = 'Duplicate {$a} record deleted: ';
$string['error:duplicaterecordsfound'] = '{$a->count} duplicate record(s) found in the {$a->tablename} table...fixing (see error log for details)';
$string['error:emptyidnumberwithsync'] = 'HR Import is enabled but the ID number field is empty. Either disable HR Import for this user or provide a valid ID number.';
$string['error:findingmenuitem'] = 'Error finding the menu item';
$string['error:hidden'] = 'An error occurred';
$string['error:importtimezonesfailed'] = 'Failed to update timezone information.';
$string['error:itemhasdescendants'] = 'You cannot move this item to the selected parent because it has descendants. Please move this item\'s descendants first.';
$string['error:itemnotselected'] = 'Please select an item';
$string['error:menuitemcannotberemoved'] = '"{$a}" item can not be removed, please review your settings.';
$string['error:menuitemcannotremove'] = '"{$a}" has the children which can not be removed, please review your settings.';
$string['error:menuitemcannotremovechild'] = ' - can not delete this item';
$string['error:menuitemclassnametoolong'] = 'Class name too long';
$string['error:menuitemruleaudiencerequired'] = 'At least one audience must be selected';
$string['error:menuitemrulepresetrequired'] = 'At least one preset must be selected';
$string['error:menuitemrulerequired'] = 'At least one restriction type must be selected';
$string['error:menuitemrulerolerequired'] = 'At least one role must be selected';
$string['error:menuitemtargetattrtoolong'] = 'Menu target attribute too long';
$string['error:menuitemtitlerequired'] = 'Menu title required';
$string['error:menuitemtitletoolong'] = 'Menu title too long';
$string['error:menuitemurlinvalid'] = 'Menu url address is invalid. Use "/" for a relative link of your domain name or full address for external link, i.e. http://extdomain.com';
$string['error:menuitemurltoolong'] = 'Menu url address too long';
$string['error:morethanxitemsatthislevel'] = 'There are more than {$a} items at this level.';
$string['error:norolesfound'] = 'No roles found';
$string['error:notificationsparamtypewrong'] = 'Incorrect param type sent to Totara notifications';
$string['error:pagepermissions'] = 'You do not have permission to view this page';
$string['error:pagerender'] = 'An error occurred while rendering the page.';
$string['error:parentnotexists'] = '"{$a}" parent item does not exists, please check your settings';
$string['error:sesskey_expired_login_button'] = 'Login';
$string['error:sesskey_expired_login_message'] = 'You\'ve been logged out for security reasons due to inactivity. Please log in again to continue.';
$string['error:sesskey_expired_refresh_button'] = 'Refresh page';
$string['error:sesskey_expired_refresh_message'] = 'You need to refresh the page to continue. Any unsaved data will be lost.';
$string['error:sesskey_expired_title'] = 'Your session has expired';
$string['error:staffmanagerroleexists'] = 'A role "staffmanager" already exists. This role must be renamed before the upgrade can proceed.';
$string['error:unexpected'] = 'An unexpected error occurred.';
$string['error:unknownbuttonclicked'] = 'Unknown button clicked';
$string['error:upload_failed'] = 'Sorry, the file failed to upload. Please try again';
$string['error:useridincorrect'] = 'User id is incorrect.';
$string['error:usernotfound'] = 'User not found';
$string['error:userprofilecapability'] = 'You do not have permission to edit the user profile. Please contact the site administrator.';
$string['errorfindingcategory'] = 'Error finding the category';
$string['errorfindingprogram'] = 'Error finding the program';
$string['eventbulkenrolmentsfinished'] = 'Bulk enrolments finished';
$string['eventbulkenrolmentsstarted'] = 'Bulk enrolments started';
$string['eventbulkroleassignmentsfinished'] = 'Bulk role assignments finished';
$string['eventbulkroleassignmentsstarted'] = 'Bulk role assignments started';
$string['eventcoursearchived'] = 'Course was archived';
$string['eventcoursecompletionreset'] = 'Course completion was reset';
$string['eventcoursecompletionunlocked'] = 'Course completion was unlocked without reset';
$string['eventcourseinprogress'] = 'User was marked in progress for course';
$string['eventmenuadminviewed'] = 'Main menu administration viewed';
$string['eventmenuitemcreated'] = 'Menu item created';
$string['eventmenuitemdeleted'] = 'Menu item deleted';
$string['eventmenuitemupdated'] = 'Menu item updated';
$string['eventmodulecompletion'] = 'Activity completion';
$string['eventmodulecompletioncriteriaupdated'] = 'Module completion criteria updated';
$string['eventmodulecompletionreset'] = 'Module completion reset';
$string['eventmodulecompletionunlocked'] = 'Module completion unlocked';
$string['eventmyreportviewed'] = 'User viewed their reports';
$string['eventremindercreated'] = "Reminder was created";
$string['eventreminderdeleted'] = "Reminder was deleted";
$string['eventreminderupdated'] = "Reminder was updated";
$string['eventundeleted'] = 'User undeleted';
$string['eventupdateadmin'] = 'Admin user group updated';
$string['eventupdateauth'] = 'Authentication methods updated';
$string['eventuserconfirmed'] = 'User confirmed';
$string['eventusersuspended'] = 'User suspended';
$string['eventuserunsuspended'] = 'User unsuspended';
$string['example_learning_description'] = 'This is an example of how a Course, Certification or Program will display in a performance activity.';
$string['example_learning_fullname'] = 'Learning example';
$string['execpathnotallowed'] = 'This setting is currently disabled. To enable, add<br />$CFG->preventexecpath = 0;<br /> to config.php';
$string['expandall_with_title'] = 'Expand all {$a}';
$string['exportformat'] = 'Export format';
$string['facetoface'] = 'Seminar';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Select or upload the image file to be used as the site\'s favicon, the icon must be *.ico format';
$string['feature_not_available'] = 'Feature {$a} is not available.';
$string['file_extension'] = '.{$a}';
$string['filesize'] = '{$a->size} {$a->unit}';
$string['filewithname'] = 'File {$a}';
$string['filter_audiences'] = 'Filter audiences';
$string['filter_audiences_search_label'] = 'Filter items by search';
$string['filter_clear_active'] = 'Clear all active filters';
$string['filter_individuals'] = 'Filter individuals';
$string['filter_individuals_search_label'] = 'Filter items by search';
$string['filter_learning'] = 'Filter learning';
$string['filter_learning_search_label'] = 'Filter items by search';
$string['filter_organisation'] = 'Filter organisations';
$string['filter_position'] = 'Filter positions';
$string['filter_x_taglist'] = 'Filter {$a}';
$string['filters'] = 'Filters';
$string['filters_count'] = 'Filters ({$a})';
$string['filtershide'] = 'Hide filters';
$string['filtersshow'] = 'Show filters';
$string['findcourses'] = 'Find Courses';
$string['findlearning'] = 'Find Learning';
$string['flexibleicons'] = 'Flexible icons';
$string['fontdefault'] = 'Appropriate default';
$string['formfield_defaults'] = 'Default:';
$string['four_byte_characterset_info'] = 'Missing four-byte character support';
$string['four_byte_characterset_info_with_current'] = 'Missing four-byte character support (Currently: {$a})';
$string['four_byte_characterset_warning'] = 'UTF-8 requires 4 bytes in order to store the extended characters. The database is configured to use a charset that appears to be limited to less than 4 bytes. We strongly recommend migrating the database charset to a 4 byte UTF-8 charset. Presently if your users attempt to create content using extended characters including emojis they may experience database errors, data corruption, or both.';
$string['framework'] = 'Framework';
$string['gobacktoall'] = 'Go back to all';
$string['gotopage'] = "Go to page";
$string['hashtag'] = 'Hashtag';
$string['header_learning_name'] = 'Name';
$string['header_learning_progress'] = 'Progress';
$string['header_learning_type'] = 'Learning type';
$string['heading'] = 'Heading';
$string['headingcolumnsdescription'] = 'The fields below define which data appear in the Report Heading Block. This block contains information about a specific user, and can appear in many locations throughout the site.';
$string['headingmissingvalue'] = 'Value to display if no data found';
$string['hide_filters'] = 'Hide filters';
$string['hide_filters_count'] = 'Hide filters ({$a})';
$string['hidefeature'] = 'Hide';
$string['hierarchies'] = 'Hierarchies';
$string['hierarchy_framework'] = 'Framework';
$string['home'] = 'Home';
$string['hourlyon'] = 'Hourly on';
$string['icon'] = 'Icon';
$string['idnumberduplicates'] = 'Table: "{$a->table}". ID numbers: {$a->idnumbers}.';
$string['idnumberexists'] = 'Record with this ID number already exists';
$string['importtimezonesskipped'] = 'Skipped updating timezone information.';
$string['importtimezonessuccess'] = 'Timezone information updated from source {$a}.';
$string['incompatiblerepository'] = 'File download is disabled for security reasons, repository "{$a}" needs to be updated by developer';
$string['individualplural'] = 'Individual users';
$string['inforesizecustomicons'] = 'Any file with width and height greater than 35x35 will be resized.';
$string['inlineedit:instructions'] = 'Escape to cancel, Enter when finished';
$string['inlineedit:maxlength'] = 'Length limit reached';
$string['inlineedit:noempty'] = 'Revert to previous item name?';
$string['inprogress'] = 'In Progress';
$string['input_label_in_currency'] = '{$a->label} in {$a->currency}';
$string['installdemoquestion'] = 'Do you want to include demo data with this installation?<br /><br />(This will take a long time.)';
$string['installingdemodata'] = 'Installing Demo Data';
$string['invalidsearchtable'] = 'Invalid search table';
$string['issupporteddbwarning'] = 'You are running an unsupported version of the DB on your site. Migrating to a supported database will improve your site\'s stability.';
$string['itemselected'] = 'Item selected: {$a}';
$string['itemsperpage'] = 'Items per page';
$string['itemsselected'] = 'Items selected: {$a}';
$string['itemstoadd'] = 'Items to add';
$string['language_options'] = 'Language options';
$string['lasterroroccuredat'] = 'Last error occurred at {$a}';
$string['learn'] = 'Learn';
$string['learning'] = 'Learning';
$string['learning_generic_display_name'] = 'learning';
$string['learning_removed'] = 'This learning item no longer exists';
$string['learning_type_certification'] = 'Certification';
$string['learning_type_course'] = 'Course';
$string['learning_type_program'] = 'Program';
$string['learning_type_unknown'] = 'Unknown';
$string['learningplans'] = 'Learning Plans';
$string['learningrecords'] = 'Learning Records';
$string['listitem'] = '{$a} item';
$string['listitemplural'] = '{$a} items';
$string['loading'] = 'Loading';
$string['loadmore'] = 'Load more';
$string['localpostinstfailed'] = 'There was a problem setting up local modifications to this installation.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Select or upload the image file to be used as the site\'s logo';
$string['makehomepage'] = 'Make home page';
$string['managecertifications'] = 'Manage certifications';
$string['managecustomicons'] = 'Manage custom icons';
$string['managers'] = 'Manager\'s ';
$string['manageuserlogin'] = 'Manage user login';
$string['manageuserloginaction'] = 'Manage login of {$a}';
$string['mariadb_compressed_rows_support'] = "innodb_read_only_compressed configuration check";
$string['mariadb_needs_innodb_read_only_compressed_off'] = "MariaDB versions >=10.6 requires innodb_read_only_compressed configuration set to OFF. Add innodb_read_only_compressed=OFF to the MariaDB configuration file or run SET GLOBAL innodb_read_only_compressed=OFF";
$string['mentionbody:comment'] = '<strong>{$a->fullname}</strong> has commented on the {$a->title}.';
$string['mentiontitle:comment'] = '{$a} has mentioned you in a comment';
$string['mentionview:comment'] = 'View comment';
$string['menu_title_perform'] = 'Develop';
$string['menuitem:accessbyaudience'] = 'Restrict access by audience';
$string['menuitem:accessbypreset'] = 'Restrict access by preset rule';
$string['menuitem:accessbyrole'] = 'Restrict access by role';
$string['menuitem:accesscontrols'] = 'Access Controls';
$string['menuitem:accessmode'] = 'Access Mode';
$string['menuitem:accessmode_help'] = 'Access controls are used to restrict which users can view the menu item.

**Restrict access** determines how the following criteria are applied.

When set to **any**, users will be able to see this menu item if they meet **any one** of the enabled criteria below.

When set to **all**, users will only be able to see this menu item if they meet **all** the enabled criteria below.';
$string['menuitem:accessnotenabled'] = 'The settings below are not currently active because this item\'s visibility is not set to "Use custom access settings".';
$string['menuitem:addcohorts'] = 'Add audiences';
$string['menuitem:addnew'] = 'Add new menu item';
$string['menuitem:anycontext'] = 'Users may have role in any context';
$string['menuitem:audienceaggregation'] = 'Audience aggregation';
$string['menuitem:audienceaggregation_help'] = 'Determines whether the user must be a member of all of the selected audiences, or any of the selected audiences.';
$string['menuitem:context'] = 'Context';
$string['menuitem:context_help'] = '**Context** allows you to specify where a user must have a role assigned in order to view the menu item.

A user can be assigned a role at the system level giving them site wide access or just within a particular context. For instance a trainer may only be assigned the role at the course level.

When **Users must have role in the system context** is selected the user must be assigned the role at a system level (i.e. at a site-wide level) to be able to view the menu item.

When **User may have role in any context** is selected a user can view the report when they have been assigned the selected role anywhere in the system.';
$string['menuitem:delete'] = 'Are you sure you want to delete the "{$a}" item?';
$string['menuitem:deletechildren'] = 'All children of "{$a}" will be deleted:';
$string['menuitem:deletesuccess'] = 'Menu item has been deleted';
$string['menuitem:edit'] = 'Edit menu item';
$string['menuitem:editaccess'] = 'Access';
$string['menuitem:editingx'] = 'Editing menu item "{$a}"';
$string['menuitem:formitemcustomclass'] = 'Custom CSS class';
$string['menuitem:formitemcustomclass_error'] = 'Classname is already used, please choose another classname.';
$string['menuitem:formitemcustomclass_help'] = "Add a custom CSS class to this item to style it differently from the others. To prevent unintended styling issues you cannot use a class name that is already in use by this item's parent or child items.";
$string['menuitem:formitemcustomtitle'] = 'Override menu title';
$string['menuitem:formitemicon'] = 'Icon';
$string['menuitem:formitemicon_help'] = 'For themes that support menu icons, upload a correctly formatted SVG image. Icons will only show when enabled, and only on top level menu items.';
$string['menuitem:formitemparent'] = 'Parent item';
$string['menuitem:formitemtargetattr'] = 'Open link in new window';
$string['menuitem:formitemtargetattr_help'] = 'If selected, clicking this menu item will open the page in a new browser window instead of the current window.';
$string['menuitem:formitemtitle'] = 'Menu title';
$string['menuitem:formitemtitle_help'] = 'The name of this menu item. This field supports the multi-language content filter.';
$string['menuitem:formitemurl'] = 'Menu url address';
$string['menuitem:formitemurl_help'] = 'Start the URL with a **/** to make the link relative to your site URL. Otherwise start the URL with http:// or https://, i.e. http://extdomain.com

You can also use following placeholders:

* ##userid## : Current user ID.
* ##username## : Current username.
* ##useremail## : Current user email.
* ##courseid## : Current course ID.';
$string['menuitem:formitemvisibility'] = 'Visibility';
$string['menuitem:hiddentoodeep'] = 'Hidden: menu limit exceeded';
$string['menuitem:hiddentoodeep_help'] = 'The menu does not show items which are nested deeper than 2 levels.';
$string['menuitem:hide'] = 'Hide';
$string['menuitem:mainmenu'] = 'Main menu';
$string['menuitem:movesuccess'] = 'The item was moved successfully';
$string['menuitem:navigationsettings'] = 'Navigation settings';
$string['menuitem:norolesfound'] = 'No roles found';
$string['menuitem:nourlwithchildren'] = 'No URL';
$string['menuitem:presetaggregation'] = 'Preset rule aggregation';
$string['menuitem:presetaggregation_help'] = 'Determines whether the user must meet all of the selected preset rules, or any of the selected preset rules.';
$string['menuitem:presetwithaccess'] = 'Condition required to view';
$string['menuitem:presetwithaccess_help'] = 'This criteria allows you to restrict access to the menu item using one or more predefined rules.

How these rules are required is determined by the **Preset rule aggregation** setting. If it is set to **all** then the user must meet all of the selected criteria. If it is set to **any** the user must meet only one of the selected criteria.';
$string['menuitem:resetbackupcustom'] = 'hidden from menu and available in menu settings';
$string['menuitem:resetcustomoption'] = 'All custom items will be';
$string['menuitem:resetdeletecustom'] = 'permanently deleted';
$string['menuitem:resettodefault'] = 'Reset menu to default configuration';
$string['menuitem:resettodefaultcomplete'] = 'Main menu has been reset to default configuration.';
$string['menuitem:resetwarnign'] = 'You are about to reset the Main menu to its default configuration.';
$string['menuitem:restrictaccess'] = 'Restrict access';
$string['menuitem:restrictaccessbyaudience'] = 'Restrict access by audience';
$string['menuitem:roleaggregation'] = 'Role aggregation';
$string['menuitem:roleaggregation_help'] = 'Determines whether the user must have all of the selected roles, or any of the selected roles.';
$string['menuitem:roleswithaccess'] = 'Roles with permission to view';
$string['menuitem:roleswithaccess_help'] = 'This criteria allows you to restrict access to the menu item based upon the roles a user has been assigned. You can select as many roles as you like and use the other supporting settings to determine how Totara checks those roles.

Whether they need to have any of the selected roles or all of the selected roles is determined by the **Role aggregation** setting.

The **Context** setting can be used to control whether the role is assigned to the user as a system wide role or whether it can occur in any other context.';
$string['menuitem:rulepreset_can_view_allappraisals'] = 'User can view All Appraisals menu item';
$string['menuitem:rulepreset_can_view_appraisal'] = 'User can view Performance menu item';
$string['menuitem:rulepreset_can_view_certifications'] = 'User can view Certifications menu item';
$string['menuitem:rulepreset_can_view_feedback_360s'] = 'User can view 360&deg; Feedback menu item';
$string['menuitem:rulepreset_can_view_latest_appraisal'] = 'User can view Latest Appraisal menu item';
$string['menuitem:rulepreset_can_view_learning_plans'] = 'User can view Learning Plans menu item';
$string['menuitem:rulepreset_can_view_my_goals'] = 'User can view Goals menu item';
$string['menuitem:rulepreset_can_view_my_reports'] = 'User can view Reports menu item';
$string['menuitem:rulepreset_can_view_my_team'] = 'User can view Team menu item';
$string['menuitem:rulepreset_can_view_programs'] = 'User can view Programs menu item';
$string['menuitem:rulepreset_can_view_required_learning'] = 'User can view Required Learning menu item';
$string['menuitem:rulepreset_is_guest'] = 'User is logged in as guest';
$string['menuitem:rulepreset_is_logged_in'] = 'User is logged in';
$string['menuitem:rulepreset_is_not_guest'] = 'User is <b>not</b> logged in as guest';
$string['menuitem:rulepreset_is_not_logged_in'] = 'User is <b>not</b> logged in';
$string['menuitem:rulepreset_is_site_admin'] = 'User is site administrator';
$string['menuitem:show'] = 'Show';
$string['menuitem:showcustom'] = 'Use custom access rules';
$string['menuitem:showwhenrequired'] = 'Show when accessible';
$string['menuitem:systemcontext'] = 'Users must have role in the system context';
$string['menuitem:title'] = 'Item title';
$string['menuitem:type'] = 'Type';
$string['menuitem:typedisabled'] = 'Feature disabled';
$string['menuitem:typeparent'] = 'Parent';
$string['menuitem:typeurl'] = 'URL';
$string['menuitem:updateaccesssuccess'] = 'Access rules updated successfully';
$string['menuitem:updatesuccess'] = 'Main menu has been updated successfully';
$string['menuitem:url'] = 'URL address';
$string['menuitem:visibility'] = 'Visibility';
$string['menuitem:withrestrictionall'] = 'Users matching <strong>all</strong> of the criteria below can view this menu item.';
$string['menuitem:withrestrictionany'] = 'Users matching <strong>any</strong> of the criteria below can view this menu item.';
$string['menulifetime'] = 'Main menu cache life time';
$string['menulifetime_desc'] = 'Higher values improve performance but some changes in menu structure may be delayed.';
$string['messageprovider:mention'] = 'Notifications on mentions';
$string['minutelyon'] = 'Minutely on';
$string['mnetremoval'] = 'MNET functionality was removed from Totara 14.0';
$string['mnetremovalblocked'] = 'MNET users were detected, site cannot be upgraded to Totara 14';
$string['modulearchive'] = 'Activity archives';
$string['month'] = 'Month';
$string['month_april'] = 'April';
$string['month_april_short'] = 'Apr';
$string['month_august'] = 'August';
$string['month_august_short'] = 'Aug';
$string['month_december'] = 'December';
$string['month_december_short'] = 'Dec';
$string['month_february'] = 'February';
$string['month_february_short'] = 'Feb';
$string['month_january'] = 'January';
$string['month_january_short'] = 'Jan';
$string['month_july'] = 'July';
$string['month_july_short'] = 'Jul';
$string['month_june'] = 'June';
$string['month_june_short'] = 'Jun';
$string['month_march'] = 'March';
$string['month_march_short'] = 'Mar';
$string['month_may'] = 'May';
$string['month_may_short'] = 'May';
$string['month_november'] = 'November';
$string['month_november_short'] = 'Nov';
$string['month_october'] = 'October';
$string['month_october_short'] = 'Oct';
$string['month_september'] = 'September';
$string['month_september_short'] = 'Sep';
$string['monthlyon'] = 'Monthly on';
$string['months'] = 'Month(s)';
$string['moodlecore'] = 'Moodle core';
$string['moreitems'] = 'More items';
$string['move_to_list'] = 'Move to list';
$string['movedown'] = 'Move Down';
$string['moveup'] = 'Move Up';
$string['mssqlgroupconcatfail'] = 'Automatic update failed with reason "{$a}". Please, copy code from textarea below and execute it in MSSQL Server as Administrator. Afterwards refresh this page.';
$string['mybookings'] = 'My Bookings';
$string['mycoursecompletions'] = 'My Course Completions';
$string['mycurrentprogress'] = 'My Current Courses';
$string['mydevelopmentplans'] = 'My development plans';
$string['myfuturebookings'] = 'My Future Bookings';
$string['mylearning'] = 'My Learning';
$string['mypastbookings'] = 'My Past Bookings';
$string['myprofile'] = 'My Profile';
$string['myrecordoflearning'] = 'My Record of Learning';
$string['mysqlneedsinnodb'] = 'The current database engine "{$a}" may not be compatible with Totara, it is strongly recommended to use InnoDB or XtraDB engine.';
$string['myteaminstructionaltext'] = 'Choose a team member from the table on the right.';
$string['n_more'] = '{$a} more';
$string['navigation_menu_summary'] = 'Navigation menu usage data.';
$string['navigate_down'] = 'Go into {$a}';
$string['navigate_up'] = 'Go back';
$string['nextpage'] = 'Next page';
$string['ngramcheckinfo'] = 'NGRAM check';
$string['ngramenvironmentmsg'] = "NGRAM plugin for MySQL is missing. It is highly recommended to install NGRAM plugin in order to optimise full text search on MySQL database.";
$string['noassessors'] = 'No assessors found';
$string['nogroupassignments'] = 'No groups assigned';
$string['noitems'] = 'No items to display';
$string['noitemselected'] = 'No item selected';
$string['none'] = 'None';
$string['noresultsfor'] = 'No results found for "{$a->query}".';
$string['nostaffassigned'] = 'You currently do not have a team.';
$string['notapplicable'] = 'Not applicable';
$string['notavailable'] = 'Not available';
$string['notenrolled'] = '<em>You are not currently enrolled in any courses.</em>';
$string['notfound'] = 'Not found';
$string['notimplementedtotara'] = 'Sorry, this feature is only implemented on MySQL, MSSQL and PostgreSQL databases.';
$string['number'] = 'Number';
$string['numberofstaff'] = '({$a} staff)';
$string['options'] = 'Options';
$string['or_separator'] = 'Or';
$string['organisation_name'] = 'Organisation';
$string['organisation_typeicon'] = 'Organisation type icon';
$string['organisationatcompletion'] = 'Organisation at completion';
$string['organisationsarrow'] = 'Organisations > ';
$string['participant'] = 'Participant';
$string['pastbookingsforheading'] = 'Past Bookings for {$a}';
$string['pathtowkhtmltopdf'] = 'Path to wkhtmltopdf';
$string['pathtowkhtmltopdf_help'] = 'Specify location of the wkhtmltopdf executable file. wkhtmltopdf is used for creation of PDF snapshots.';
$string['performinglocalpostinst'] = 'Local Post-installation setup';
$string['permittedcrossdomainpolicies'] = 'Permitted cross domain policies';
$string['permittedcrossdomainpolicies_desc'] = 'If set to "none" browsers are instructed to prevent embedding of content from this server in extenal Flash or PDF files. If set to "master-only" the policies can be defined in main crossdomain.xml file.';
$string['persistentloginenable'] = 'Persistent login';
$string['persistentloginenable_desc'] = 'If enabled \'Remember my login\' replaces the \'Remember username\' option on the login page.';
$string['persistentloginlabel'] = 'Remember my login';
$string['persistentlogintask'] = 'Persistent login clean up';
$string['phpjitinfo'] = 'PHP Just-In-Time compilation check';
$string['phpjitinforestricted'] = 'PHP Just-In-Time must be disabled.';
$string['pluginname'] = 'Totara core';
$string['pluginnamewithkey'] = 'Self enrolment with key';
$string['plugintype_virtualmeetings'] = 'Virtual meetings';
$string['pos_description'] = 'Description';
$string['pos_description_help'] = 'Description of the position.';
$string['position_name'] = 'Position';
$string['position_typeicon'] = 'Position type icon';
$string['positiona'] = 'Position {$a}';
$string['positionatcompletion'] = 'Position at completion';
$string['positionsarrow'] = 'Positions > ';
$string['poweredbyx'] = 'Powered by {$a->totaralearn}';
$string['poweredbyxhtml'] = 'Powered by <a href="{$a->url}">{$a->totaralearn}</a>';
$string['previouspage'] = 'Previous page';
$string['primarynavigation'] = 'Primary navigation';
$string['proficiency'] = 'Proficiency';
$string['progdoesntbelongcat'] = 'The program doesn\'t belong to this category';
$string['programicon'] = 'Program icon';
$string['queryerror'] = 'Query error. No results found.';
$string['quickaccessmenu:addgroup'] = 'Add a new group';
$string['quickaccessmenu:addmenuitem'] = 'Add menu item...';
$string['quickaccessmenu:addtomenu'] = 'Add to admin menu';
$string['quickaccessmenu:createnewgroup'] = 'Create new group';
$string['quickaccessmenu:empty-message'] = 'This is your administration menu. <br /><a href="{$a}">Click here to customise it</a>';
$string['quickaccessmenu:empty-message-noedit'] = 'This is your administration menu.<br /> To start using it contact your system administrator.';
$string['quickaccessmenu:error:emptyitemlabel'] = 'Menu item labels cannot be empty';
$string['quickaccessmenu:error:invalidaction'] = 'Invalid action "{$a}"';
$string['quickaccessmenu:error:invalidgroup'] = 'Invalid menu group {$a}';
$string['quickaccessmenu:error:invaliditem'] = 'Invalid menu group item {$a}';
$string['quickaccessmenu:hidemenuwindow'] = 'Hide admin menu window';
$string['quickaccessmenu:menuheading'] = 'Administration Menu';
$string['quickaccessmenu:menusettings'] = 'Menu settings';
$string['quickaccessmenu:menuwindow'] = 'Admin menu window';
$string['quickaccessmenu:removefrommenu'] = 'Remove from admin menu';
$string['quickaccessmenu:reset'] = 'Reset admin menu';
$string['quickaccessmenu:resetcomplete'] = 'Your administration navigation preferences have been reset to default configuration.';
$string['quickaccessmenu:resetconfirm'] = 'Are you sure that you want to reset your administration navigation preferences to their default configuration? This will permanently erase your customisations.';
$string['quickaccessmenu:search'] = 'Search administration';
$string['quickaccessmenu:settingsheading'] = 'Administration navigation settings';
$string['quickaccessmenu:showmenuwindow'] = 'Show admin menu window';
$string['quickaccessmenu:success:itemadded'] = 'Page added to the admin menu';
$string['quickaccessmenu:success:itemremoved'] = 'Page removed from the admin menu';
$string['quickaccessmenu:untitledgroup'] = 'Untitled';
$string['quickaccesssettings:deletegroup'] = 'Delete group';
$string['quickaccesssettings:deleteitem'] = 'Delete item';
$string['quickaccesssettings:editgroupname'] = 'Edit group name';
$string['quickaccesssettings:edititemname'] = 'Edit item name';
$string['quickaccesssettings:groupactions'] = 'Group Actions';
$string['quickaccesssettings:itemlabel'] = 'Item Label:';
$string['quickaccesssettings:itemname'] = 'Item Target Page:';
$string['quickaccesssettings:reordergroup-down'] = 'Reorder group lower';
$string['quickaccesssettings:reordergroup-up'] = 'Reorder group higher';
$string['quickaccesssettings:reorderitem-down'] = 'Reorder item lower';
$string['quickaccesssettings:reorderitem-up'] = 'Reorder item higher';
$string['recordnotcreated'] = 'Record could not be created';
$string['recordnotupdated'] = 'Record could not be updated';
$string['recordoflearning'] = 'Record of learning';
$string['recordoflearningforname'] = 'Record of Learning for {$a}';
$string['registrationcode'] = 'Registration code';
$string['registrationcode_help'] = 'Production sites require a unique registration code, it can be obtained from your Totara Partner.';
$string['registrationcodeinvalid'] = 'Invalid registration code format';
$string['relationship_name_appraiser'] = 'Appraiser';
$string['relationship_name_direct_report'] = 'Direct report';
$string['relationship_name_manager'] = 'Manager';
$string['relationship_name_managers_manager'] = 'Manager\'s manager';
$string['relationship_name_plural_appraiser'] = 'Appraisers';
$string['relationship_name_plural_direct_report'] = 'Direct reports';
$string['relationship_name_plural_manager'] = 'Managers';
$string['relationship_name_plural_managers_manager'] = 'Manager\'s managers';
$string['relationship_name_plural_subject'] = 'Subjects';
$string['relationship_name_subject'] = 'Subject';
$string['relative_time_days'] = '{$a} days ago';
$string['relative_time_five_minutes'] = 'Within the last five minutes';
$string['relative_time_half_hour'] = 'Within the last half-hour';
$string['relative_time_hour'] = 'Within the last hour';
$string['relative_time_month'] = 'A month ago';
$string['relative_time_months'] = '{$a} months ago';
$string['relative_time_years'] = '{$a} years ago';
$string['remotetotaralangnotavailable'] = 'Because Totara can not connect to download.totaralms.com, we are unable to do language pack installation automatically. Please download the appropriate zip file(s) from https://download.totaralms.com/lang/T{$a->totaraversion}/, copy them to your {$a->langdir} directory and unzip them manually.';
$string['remove_learning'] = 'Remove learning';
$string['removesearchtext'] = 'Remove search text filter';
$string['replaceareyousure'] = 'Are you sure you want to replace \'{$a->search}\' with \'{$a->replace}\'? (y/n)';
$string['replacedevdebuggingrequired'] = 'Error, you must have developer debugging enabled to run this script.';
$string['replacedonotrunlive'] = 'DO NOT RUN THIS ON A LIVE SITE.';
$string['replaceenterfindstring'] = 'Enter string to find:';
$string['replaceenternewstring'] = 'Enter new string:';
$string['replacemissingparam'] = 'Missing either Search or Replace parameters.';
$string['replacereallysure'] = 'Are you really sure? This will replace all instances of \'{$a->search}\' with \'{$a->replace}\' and may break your database! (y/n)';
$string['report'] = 'Report';
$string['reportedat'] = 'Reported at';
$string['reports'] = 'Reports';
$string['reports_with_errors'] = 'Some reports contain errors; please contact your administrator';
$string['required_fields'] = 'Required fields';
$string['requiresjs'] = 'This {$a} requires Javascript to be enabled.';
$string['reset'] = 'Reset';
$string['reset_all'] = 'Reset all';
$string['reset_filters'] = 'Reset filters';
$string['retry'] = 'Retry';
$string['returntocourse'] = 'Return to the course';
$string['roleassignmentsnum'] = 'Assignments';
$string['roledefaults'] = 'Default role settings';
$string['roledefaultsnochanges'] = 'No role changes detected';
$string['save'] = 'Save';
$string['saveextended'] = 'Save {$a}';
$string['schedule'] = 'Schedule';
$string['scheduleadvanced'] = 'The current schedule is too complex for the basic interface please, visit {$a} to edit it.';
$string['scheduleadvancedlink'] = 'here';
$string['scheduleadvancednopermission'] = 'The current schedule is too complex for the basic interface, please contact an administrator to change it.';
$string['scheduledaily'] = 'Daily';
$string['scheduleddaily'] = 'Daily at {$a}';
$string['scheduledhourly'] = 'Every {$a} hour(s) from midnight';
$string['scheduledminutely'] = 'Every {$a} minute(s) from the start of the hour';
$string['scheduledmonthly'] = 'Monthly on the {$a}';
$string['scheduledweekly'] = 'Weekly on {$a}';
$string['schedulehourly'] = 'Every X hours';
$string['scheduleminutely'] = 'Every X minutes';
$string['schedulemonthly'] = 'Monthly';
$string['scheduleweekly'] = 'Weekly';
$string['search'] = 'Search';
$string['search_hierarchy'] = 'Search hierarchy';
$string['searchcourses'] = 'Search Courses';
$string['searchx'] = 'Search {$a}';
$string['securereferrers'] = 'Secure referrers';
$string['securereferrers_desc'] = 'When enabled browsers are instructed to not send script names and page parameters to external sites which improves security and privacy. This may affect functionality of browsers that do not fully implement referrer policy.';
$string['select_a_tab'] = 'Select a tab';
$string['select_audiences'] = 'Select audiences';
$string['select_filter'] = 'Select {$a} filter.';
$string['select_individuals'] = 'Select individuals';
$string['select_learning'] = "Select learning";
$string['select_organisation'] = 'Select organisations';
$string['select_position'] = 'Select positions';
$string['selectacourse'] = 'Select a course';
$string['selectallpageitems'] = 'Select all items on page';
$string['selectallpageselected'] = 'All {$a->count} rows on this page are selected.';
$string['selectallrows'] = 'Select all rows';
$string['selectanassessor'] = 'Select an assessor...';
$string['selectaproficiency'] = 'Select a proficiency...';
$string['selected'] = 'Selected';
$string['selected_tag_list_name'] = 'Selected {$a}';
$string['selectentireresult']  = 'Select entire result';
$string['selectentireresultselected'] = 'All rows in this result are selected.';
$string['selectionlimited'] = 'There is a maximum limit of {$a} selected managers';
$string['selectrow'] = 'Select row';
$string['selectrows'] = 'Select rows';
$string['selectuserplural'] = 'Select users';
$string['sendregistrationdatatask'] = 'Send site registration data';
$string['sendremindermessagestask'] = 'Send reminder messages';
$string['server_timezone'] = '{$a} (Server timezone)';
$string['settings'] = 'Settings';
$string['sharedsrcinfo'] = 'Web server document root check';
$string['sharedsrcwarning'] = 'For security reasons only /server/ subdirectory should be accessible through the web server, it means that $CFG->wwwroot cannot end with /server.';
$string['show_filters'] = 'Show filters';
$string['show_filters_count'] = 'Show filters ({$a})';
$string['show_help_for_x'] = 'Show help for {$a}';
$string['show_less'] = 'Show less';
$string['show_more'] = 'Show more';
$string['showfeature'] = 'Show';
$string['sidepanel'] = 'Side panel';
$string['sitemanager'] = 'Site Manager';
$string['siteregistrationemailbody'] = 'Site {$a} was not able to register itself automatically. Access to push data to our registrations site is probably blocked by a firewall.';
$string['sitetype'] = 'Type of site';
$string['sitetype_help'] = 'Select the type of site that matches its use.';
$string['sitetypedemo'] = 'Demo';
$string['sitetypedevelopment'] = 'Development';
$string['sitetypeproduction'] = 'Production';
$string['sitetypeqa'] = 'QA / Staging';
$string['sitetypetrial'] = 'Trial';
$string['staffmanager'] = 'Staff Manager';
$string['startdate'] = 'Start Date';
$string['started'] = 'Started';
$string['strftimedateshortmonth'] = '%d %b %Y';
$string['stricttransportsecurity'] = 'HTTP Strict transport security (HSTS)';
$string['stricttransportsecurity_desc'] = 'When enabled, browsers are instructed to always use https:// protocol when accessing the server and users cannot ignore SSL negotiation warnings. Please note that if enabled, browsers will remember this setting for six months and will prevent access via http:// even if this setting is later disabled. Activating this setting will result in the header \'Strict-Transport-Security: max-age=16070400\' being used. If you need a custom version of this header (to enable \'preload\' or a different max-age), please keep this setting disabled and configure the header in your web server.';
$string['subject'] = 'Subject';
$string['subnavigation'] = 'Secondary navigation';
$string['subplugintype_tabexport'] = 'Tabular export plugin';
$string['subplugintype_tabexport_plural'] = 'Tabular exports';
$string['successuploadicon'] = 'Icon(s) successfully saved';
$string['system_error'] = 'System Error';
$string['tab:futurebookings'] = 'Future Bookings';
$string['tab:pastbookings'] = 'Past Bookings';
$string['tabexports'] = 'Tabular exports';
$string['tag_list'] = 'Tag list';
$string['tag_list_placeholder'] = 'Start typing name(s)...';
$string['tag_list_x'] = 'Tag list {$a}';
$string['tag_remove'] = 'Remove {$a}';
$string['tag_remove_from'] = 'Remove {$a->name} from {$a->taglist}';
$string['tags_selected'] = 'Selected tags';
$string['task_visibility_map_regenerate_all'] = 'Regenerates all visibility maps used to optimise visibility checks';
$string['task_visibility_map_regenerate_certification'] = 'Regenerates the certification visibility map used to optimise course visibility checks';
$string['task_visibility_map_regenerate_course'] = 'Regenerates the course visibility map used to optimise course visibility checks';
$string['task_visibility_map_regenerate_program'] = 'Regenerates the program visibility map used to optimise course visibility checks';
$string['team'] = 'Team';
$string['teammembers'] = 'Team Members';
$string['teammembers_text'] = 'All members of your team are shown below.';
$string['technical_details'] = 'Technical details';
$string['template'] = 'Template';
$string['tempmanager'] = 'Temporary manager';
$string['test_email_notification'] = 'Test email notification';
$string['test_email_notification_help'] = 'Send yourself a test notification. Then check your inbox.';
$string['test_email_notification_message'] = 'Body of the email';
$string['test_email_notification_subject'] = 'This is a test';
$string['time_zone'] = 'Time zone';
$string['timezoneinvalid'] = 'Invalid timezone: {$a}';
$string['timezoneuser'] = 'User timezone';
$string['toggletotarasync'] = 'Toggle HR Import';
$string['toggletotarasyncerror'] = 'Could not enable/disable the HR Import field for user {$a}';
$string['toggletotarasyncerror:noidnumber'] = 'The ID Number field is empty and so HR Import cannot be enabled for these users: {$a}';
$string['tooltotarasynctask'] = 'Import HR elements from external sources';
$string['topic_css_classes'] = 'CSS classes';
$string['topic_css_classes_help'] = 'Adding Cascading Style Sheet classes to a Topic heading allows a Theme to apply custom styling to Topic header. Add a space between each CSS class name to use more than one class.';
$string['topic_header_bg_color'] = 'Header background colour';
$string['topic_header_color'] = 'Header colour';
$string['topic_header_color_help'] = 'Display topic with a background colour behind the header. When enabled, leave background and text colour inputs blank to use default colours from the theme.';
$string['topic_header_text_color'] = 'Header text colour';
$string['totara'] = 'Totara';
$string['totarabuild'] = 'Totara build number';
$string['totaracopyright'] = '<p>Copyright &copy; 2010 onwards, Totara Learning Solutions Limited.</p>
<p><a href="https://www.totaralearning.com">{$a}</a> is a fully supported Open Source learning platform specifically designed for the requirements of corporate, industry and vocational training.</p>
<p><a href="http://www.gnu.org/licenses/gpl-3.0.en.html">GNU General Public License</a></p>';
$string['totaracopyrightacknowledge'] = '<p>{$a} utilises the following copyrighted material:</p>';
$string['totaracore'] = 'Totara core';
$string['totarafeatures'] = 'Totara features';
$string['totaralearn'] = 'Totara';
$string['totaralearnlink'] = '<a href="{$a->url}">{$a->totaralearn}</a>';
$string['totaralogin'] = 'Totara Login';
$string['totaralogo'] = 'Totara Logo';
$string['totaramenu'] = 'Totara Menu';
$string['totararegistration'] = 'Totara registration';
$string['totararegistration_desc'] = '<p>To register Totara software you must include your registration code.</p>
<p>Registering your software is not an End User Licensing Agreement. Registration establishes the subscriber\'s right to receive Totara’s software update service,
technical support of your product and access to associated customer services such as access
to the <a href="https://totara.academy/" target="_blank">Totara Academy</a> and <a href="https://totara.community/" target="_blank">Community</a>.
Registration also enables a limited set of diagnostics such as software version and operating system
to assist when examining and resolving support queries.</p>
<p>If you do not have your registration code or are experiencing problems,
your Totara Partner will be able to help, or please contact <a href="mailto:subscriptions@totaralearning.com">subscriptions@totaralearning.com</a>.</p>
<p><a href="https://www.totaralearning.com/privacy-policy" target="_blank">Totara Learning Privacy Policy</a></p>';
$string['totararegistrationinfo'] = '<p>This page configures registration updates which are sent to totaralearning.com.
These updates allow Totara to know what versions of {$a} and support software you are running.
This information will allow Totara to better examine and resolve any support issues you face in the future.</p>
<p>This information will be securely transmitted and held in confidence.</p>';
$string['totararegistrationlastsent'] = 'Data last sent to Totara';
$string['totararegistrationsaved'] = 'Totara registration was updated';
$string['totararelease'] = 'Totara release identifier';
$string['totarauniqueidnumbercheckfail'] = 'The following tables contain non-unique values in the column idnumber:<br/><br/>
{$a}
<br/>
Please fix these records before attempting the upgrade.';
$string['totaraunsupportedupgradepath'] = 'You cannot upgrade directly to {$a->attemptedversion} from {$a->currentversion}. Please upgrade to at least {$a->required} before attempting the upgrade to {$a->attemptedversion}.';
$string['totaraupgradecheckduplicateidnumbers'] = 'Check duplicate ID numbers';
$string['totaraupgradesetstandardtheme'] = 'Enable Standard Totara theme';
$string['totaraversion'] = 'Totara version number';
$string['trysearchinginstead'] = 'Try searching instead.';
$string['type'] = 'Type';
$string['typeicon'] = 'Type icon';
$string['unassignall'] = 'Unassign all';
$string['undelete'] = 'Undelete';
$string['undeletecheckfull'] = 'Are you sure you want to undelete {$a}?';
$string['undeletednotx'] = 'Could not undelete {$a} !';
$string['undeletedx'] = 'Undeleted {$a}';
$string['undeleteuser'] = 'Undelete User';
$string['undeleteusernoperm'] = 'You do not have the required permission to undelete a user';
$string['unexpected_installer_result'] = 'Unspecified component install error: {$a}';
$string['unknown_relationship_name'] = 'Unknown relationship name';
$string['unlockcompletion'] = 'Unlock completion and delete completion data';
$string['unlockcompletionnoreset'] = 'Unlock completion and keep completion data';
$string['unused'] = 'Unused';
$string['updated_recently'] = 'Updated recently';
$string['upgradenonlinear'] = 'Upgrades must be to a higher version built on or after the date of the current version {$a}';
$string['uploadcompletionrecords'] = 'Upload completion records';
$string['userdataitemcourse_enrolments'] = 'Course enrolments';
$string['userdataitemexternal_services_users'] = 'External service user assignments';
$string['userdataitemexternal_tokens'] = 'External tokens';
$string['userdataitemexternal_tokens_help'] = 'All access tokens for webservices created by or for the user.';
$string['userdataitemportfolios'] = 'Portfolio exports';
$string['userdataitemportfolios_help'] = 'Records of exports a user has made to portfolios. This does not include or affect the actual data that was exported to the portfolio.';
$string['userdataitemquickaccess_preferences'] = 'Quick access menu user preferences';
$string['userdataitemvirtualmeetings'] = 'Virtual meetings';
$string['userdoesnotexist'] = 'User does not exist';
$string['userlearningdueonx'] = 'Due on {$a}';
$string['userlearningoverduesincex'] = 'Overdue since {$a}';
$string['userlearningoverduesincextooltip'] = 'Overdue since {$a}';
$string['users'] = 'Users';
$string['validation_invalid_color_value_hex'] = 'Value should begin with # followed by 6 valid hexadecimal code characters';
$string['validation_invalid_integer'] = 'Please enter a valid whole number';
$string['validation_invalid_max'] = 'Number must be {$a->max} or less';
$string['validation_invalid_max_length'] = 'Please enter no more than {$a->len} characters';
$string['validation_invalid_min'] = 'Number must be {$a->min} or more';
$string['validation_invalid_min_length'] = 'Please enter at least {$a->len} characters';
$string['validation_invalid_number'] = 'Please enter a valid number';
$string['versionspecific'] = 'Early access';
$string['viewallx'] = 'View all {$a}';
$string['viewchildren'] = 'View children';
$string['viewmyteam'] = 'View My Team';
$string['viewselected'] = 'View selected';
$string['weeklyon'] = 'Weekly on';
$string['weeks'] = 'Week(s)';
$string['xofy'] = '{$a->count} / {$a->total}';
$string['xpercent'] = '{$a}%';
$string['xpercentcomplete'] = '{$a}% complete';
$string['xpositions'] = '{$a}\'s Positions';
$string['xresultsfory'] = '<strong>{$a->count}</strong> results found for "{$a->query}"';
$string['year'] = 'Year';
$string['yesdelete'] = 'Yes, delete';

/**
 * Deprecated in 12
 */
$string['configenhancedcatalog'] = 'This setting allows you to specify if the enhanced catalog appears when clicking on \'Find Learning\' or any of the menu options under \'Find Learning\'.
    The enhanced catalog supports faceted search by multiple criteria using custom fields instead of relying on a single category.
    When disabled, the standard catalog (i.e., the hierarchical category system configured in the \'Manage categories\' administration area) appears when clicking on \'Find Learning\' or any of the menu options under \'Find Learning\'.
    Note: When enabled, the standard catalog remains available for Admins to manage course and program/certification administration in the "backend" (e.g., to assign Instructors to courses and course categories).';
$string['enhancedcatalog'] = 'Enhanced catalog';
$string['error:itemhaschildren'] = 'You cannot change the parent of this item while it has children. Please move this items children first.';
$string['error:menuitemurlrequired'] = 'Menu url address required';
$string['menuitem:resettodefaultconfirm'] = 'Are you absolutely sure that you want to reset the top navigation to its default configuration? This will permanently erase all customisations.';
$string['menuitem:topnavigation'] = 'Top navigation';
$string['numberofactiveusers'] = '{$a} users have logged in to this site in the last year';
$string['totaranavigation'] = 'Main menu';

/**
 * Deprecated in 13
 */
$string['bookingsfor'] = 'Bookings for ';
$string['pastbookingsfor'] = 'Past Bookings for ';
$string['strftimedateshortmonth'] = '%d %b %Y';

/**
 * Deprecated in 19
 */
$string['error:cannotupgradefromnewertotara'] = 'You cannot downgrade from {$a->oldversion} to {$a->newversion}.';
$string['old_release_security_text_plural'] = ' (including [[SECURITY_COUNT]] new security releases)';
$string['old_release_security_text_singular'] = ' (including 1 new security release)';
$string['old_release_text_plural'] = 'You are not using the most recent release available for this version. There are [[ALLTYPES_COUNT]] new releases available ';
$string['old_release_text_singular'] = 'You are not using the most recent release available for this version. There is 1 new release available ';
$string['supported_branch_old_release_text'] = 'You may also want to consider upgrading from {$a} to the most recent version ([[CURRENT_MAJOR_VERSION]]) to benefit from the latest features. ';
$string['supported_branch_text'] = 'You may want to consider upgrading from {$a} to the most recent version ([[CURRENT_MAJOR_VERSION]]) to benefit from the latest features. ';
$string['totarareleaselink'] = 'See the <a href="https://totara.community/mod/forum/view.php?id=7038" target=\"_blank\">release notes</a> for more details.';
$string['totararequiredupgradeversion'] = 'Totara 2.2.13';
$string['unsupported_branch_text'] = 'The version you are using ({$a})  is no longer supported. That means that bugs and security issues are no longer being fixed. You should upgrade to a supported version (such as [[CURRENT_MAJOR_VERSION]]) as soon as possible';
