<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2016 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author  Joby Harding <joby.harding@totaralms.com>
 * @author  Petr Skoda <petr.skoda@totaralms.com>
 * @package totara_core
 */

/* Developer documentation is in /pix/flex_icons.php file. */
$icons = array(
    'totara_core|accordion-expanded' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-chevron-up',
                ),
        ),
    'totara_core|accordion-collapsed' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-chevron-down',
                ),
        ),
    'totara_core|home' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-house-door',
                ),
        ),
    'totara_core|archive_file' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-file-earmark-zip'
                )
        ),
    'totara_core|pdf_file' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-file_pdf'
                )
        ),
    'totara_core|image_file' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-file_image'
                )
        ),
    'totara_core|word_file' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-file_w'
                )
        ),
    'totara_core|excel_file' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-file_x'
                )
        ),
    'totara_core|file' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-file-earmark'
                )
        ),
    'totara_core|video_file' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-file_camera'
                )
        ),
    'totara_core|powerpoint_file' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-file_p'
                )
        ),
    'totara_core|audio_file' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-file_audio',
                )
        ),

    'totara_core|bookmark-active' =>
        array (
            'data' =>
                array (
                    'classes' => 'tfont-var-bookmark-fill'
                )
        ),

    'totara_core|like' =>
        array(
            'data' =>
                array(
                    'classes' => 'tfont-var-hand-thumbs-up'
                )
        ),

    'totara_core|like-active' =>
        array(
            'data' =>
                array (
                    'classes' => 'tfont-var-hand-thumbs-up-fill'
                )
        ),
);

$aliases = array(
    'totara_core|bookings' => 'calendar',
    'totara_core|comment-point-blue' => 'caret-left-info',
    'totara_core|comment-point-blue-rtl' => 'caret-right-info',
    'totara_core|comment-point-grey' => 'caret-right-disabled',
    'totara_core|comment-point-grey-rtl' => 'caret-left-disabled',
    'totara_core|i/bullet_delete' => 'times-danger',
    'totara_core|i/completion-rpl-n' => 'completion-rpl-n',
    'totara_core|i/completion-rpl-y' => 'completion-rpl-y',
    'totara_core|i/delete_grey' => 'delete-disabled',
    'totara_core|jquery_treeview/folder' => 'folder-open',
    'totara_core|jquery_treeview/folder-closed' => 'folder',
    'totara_core|loading' => 'loading',
    'totara_core|loading_small' => 'loading',
    'totara_core|msgicons/blended-add' => 'plus-circle-info',
    'totara_core|msgicons/blended-approve' => 'thumbs-up-success',
    'totara_core|msgicons/blended-complete' => 'check-circle-success',
    'totara_core|msgicons/blended-deadline' => 'alarm',
    'totara_core|msgicons/blended-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/blended-due' => 'alarm-warning',
    'totara_core|msgicons/blended-fail' => 'times-circle-danger',
    'totara_core|msgicons/blended-newcomment' => 'commenting-info',
    'totara_core|msgicons/blended-overdue' => 'alarm-danger',
    'totara_core|msgicons/blended-regular' => 'blended',
    'totara_core|msgicons/blended-remove' => 'times-danger',
    'totara_core|msgicons/blended-request' => 'question-circle-warning',
    'totara_core|msgicons/blended-update' => 'pencil-square-info',
    'totara_core|msgicons/competency-add' => 'plus-circle-info',
    'totara_core|msgicons/competency-approve' => 'thumbs-up-success',
    'totara_core|msgicons/competency-complete' => 'check-circle-success',
    'totara_core|msgicons/competency-deadline' => 'alarm',
    'totara_core|msgicons/competency-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/competency-due' => 'alarm-warning',
    'totara_core|msgicons/competency-fail' => 'times-circle-danger',
    'totara_core|msgicons/competency-newcomment' => 'commenting-info',
    'totara_core|msgicons/competency-overdue' => 'alarm-danger',
    'totara_core|msgicons/competency-regular' => 'competency',
    'totara_core|msgicons/competency-remove' => 'times-danger',
    'totara_core|msgicons/competency-request' => 'question-circle-warning',
    'totara_core|msgicons/competency-update' => 'pencil-square-info',
    'totara_core|msgicons/course-add' => 'plus-circle-info',
    'totara_core|msgicons/course-approve' => 'thumbs-up-success',
    'totara_core|msgicons/course-complete' => 'check-circle-success',
    'totara_core|msgicons/course-deadline' => 'alarm',
    'totara_core|msgicons/course-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/course-due' => 'alarm-warning',
    'totara_core|msgicons/course-fail' => 'times-circle-danger',
    'totara_core|msgicons/course-newcomment' => 'commenting-info',
    'totara_core|msgicons/course-overdue' => 'alarm-danger',
    'totara_core|msgicons/course-regular' => 'course',
    'totara_core|msgicons/course-remove' => 'times-danger',
    'totara_core|msgicons/course-request' => 'question-circle-warning',
    'totara_core|msgicons/course-update' => 'pencil-square-info',
    'totara_core|msgicons/default' => 'laptop',
    'totara_core|msgicons/elearning-add' => 'plus-circle-info',
    'totara_core|msgicons/elearning-approve' => 'thumbs-up-success',
    'totara_core|msgicons/elearning-complete' => 'check-circle-success',
    'totara_core|msgicons/elearning-deadline' => 'alarm',
    'totara_core|msgicons/elearning-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/elearning-due' => 'alarm-warning',
    'totara_core|msgicons/elearning-fail' => 'times-circle-danger',
    'totara_core|msgicons/elearning-newcomment' => 'commenting-info',
    'totara_core|msgicons/elearning-overdue' => 'alarm-danger',
    'totara_core|msgicons/elearning-regular' => 'laptop',
    'totara_core|msgicons/elearning-remove' => 'times-danger',
    'totara_core|msgicons/elearning-request' => 'question-circle-warning',
    'totara_core|msgicons/elearning-update' => 'pencil-square-info',
    'totara_core|msgicons/evidence-add' => 'plus-circle-info',
    'totara_core|msgicons/evidence-approve' => 'thumbs-up-success',
    'totara_core|msgicons/evidence-complete' => 'check-circle-success',
    'totara_core|msgicons/evidence-deadline' => 'alarm',
    'totara_core|msgicons/evidence-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/evidence-due' => 'alarm-warning',
    'totara_core|msgicons/evidence-fail' => 'times-circle-danger',
    'totara_core|msgicons/evidence-newcomment' => 'commenting-info',
    'totara_core|msgicons/evidence-overdue' => 'alarm-danger',
    'totara_core|msgicons/evidence-regular' => 'attachment',
    'totara_core|msgicons/evidence-remove' => 'times-danger',
    'totara_core|msgicons/evidence-request' => 'question-circle-warning',
    'totara_core|msgicons/evidence-update' => 'pencil-square-info',
    'totara_core|msgicons/facetoface-add' => 'plus-circle-info',
    'totara_core|msgicons/facetoface-approve' => 'thumbs-up-success',
    'totara_core|msgicons/facetoface-complete' => 'check-circle-success',
    'totara_core|msgicons/facetoface-deadline' => 'alarm',
    'totara_core|msgicons/facetoface-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/facetoface-due' => 'alarm-warning',
    'totara_core|msgicons/facetoface-fail' => 'times-circle-danger',
    'totara_core|msgicons/facetoface-newcomment' => 'commenting-info',
    'totara_core|msgicons/facetoface-overdue' => 'alarm-danger',
    'totara_core|msgicons/facetoface-regular' => 'mod_facetoface|icon',
    'totara_core|msgicons/facetoface-remove' => 'times-danger',
    'totara_core|msgicons/facetoface-request' => 'question-circle-warning',
    'totara_core|msgicons/facetoface-update' => 'pencil-square-info',
    'totara_core|msgicons/feedback360-cancel' => 'times-danger',
    'totara_core|msgicons/feedback360-remind' => 'alarm-warning',
    'totara_core|msgicons/feedback360-request' => 'question-circle-warning',
    'totara_core|msgicons/feedback360-update' => 'pencil-square-info',
    'totara_core|msgicons/learningplan-add' => 'plus-circle-info',
    'totara_core|msgicons/learningplan-approve' => 'thumbs-up-success',
    'totara_core|msgicons/learningplan-complete' => 'check-circle-success',
    'totara_core|msgicons/learningplan-deadline' => 'alarm',
    'totara_core|msgicons/learningplan-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/learningplan-due' => 'alarm-warning',
    'totara_core|msgicons/learningplan-fail' => 'times-circle-danger',
    'totara_core|msgicons/learningplan-newcomment' => 'commenting-info',
    'totara_core|msgicons/learningplan-overdue' => 'alarm-danger',
    'totara_core|msgicons/learningplan-regular' => 'learningplan',
    'totara_core|msgicons/learningplan-remove' => 'times-danger',
    'totara_core|msgicons/learningplan-request' => 'question-circle-warning',
    'totara_core|msgicons/learningplan-update' => 'pencil-square-info',
    'totara_core|msgicons/objective-add' => 'plus-circle-info',
    'totara_core|msgicons/objective-approve' => 'thumbs-up-success',
    'totara_core|msgicons/objective-complete' => 'check-circle-success',
    'totara_core|msgicons/objective-deadline' => 'alarm',
    'totara_core|msgicons/objective-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/objective-due' => 'alarm-warning',
    'totara_core|msgicons/objective-fail' => 'times-circle-danger',
    'totara_core|msgicons/objective-newcomment' => 'commenting-info',
    'totara_core|msgicons/objective-overdue' => 'alarm-danger',
    'totara_core|msgicons/objective-regular' => 'objective',
    'totara_core|msgicons/objective-remove' => 'times-danger',
    'totara_core|msgicons/objective-request' => 'question-circle-warning',
    'totara_core|msgicons/objective-update' => 'pencil-square-info',
    'totara_core|msgicons/program-add' => 'plus-circle-info',
    'totara_core|msgicons/program-approve' => 'thumbs-up-success',
    'totara_core|msgicons/program-complete' => 'check-circle-success',
    'totara_core|msgicons/program-deadline' => 'alarm',
    'totara_core|msgicons/program-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/program-due' => 'alarm-warning',
    'totara_core|msgicons/program-fail' => 'times-circle-danger',
    'totara_core|msgicons/program-newcomment' => 'commenting-info',
    'totara_core|msgicons/program-overdue' => 'alarm-danger',
    'totara_core|msgicons/program-regular' => 'program',
    'totara_core|msgicons/program-remove' => 'times-danger',
    'totara_core|msgicons/program-request' => 'question-circle-warning',
    'totara_core|msgicons/program-update' => 'pencil-square-info',
    'totara_core|msgicons/resource-add' => 'plus-circle-info',
    'totara_core|msgicons/resource-approve' => 'thumbs-up-success',
    'totara_core|msgicons/resource-complete' => 'check-circle-success',
    'totara_core|msgicons/resource-deadline' => 'alarm',
    'totara_core|msgicons/resource-decline' => 'thumbs-down-danger',
    'totara_core|msgicons/resource-due' => 'alarm-warning',
    'totara_core|msgicons/resource-fail' => 'times-circle-danger',
    'totara_core|msgicons/resource-newcomment' => 'commenting-info',
    'totara_core|msgicons/resource-overdue' => 'alarm-danger',
    'totara_core|msgicons/resource-regular' => 'books',
    'totara_core|msgicons/resource-remove' => 'times-danger',
    'totara_core|msgicons/resource-request' => 'question-circle-warning',
    'totara_core|msgicons/resource-update' => 'pencil-square-info',
    'totara_core|plan' => 'learningplan',
    'totara_core|record' => 'recordoflearning',
    'totara_core|t/calendar' => 'calendar',
    'totara_core|t/delete_grey' => 'delete-disabled',
    'totara_core|t/file' => 'file-text',
    'totara_core|t/minus' => 'minus-square-o',
    'totara_core|t/plus' => 'plus-square-o',
    'totara_core|teammembers' => 'users',
);

/* Pix only images are not supposed to be converted to flex icons. */
$pixonlyimages = array(
    'courseicons/achieving-success',
    'courseicons/advanced-accounting',
    'courseicons/advanced-business-process-improvement',
    'courseicons/advanced-project-management',
    'courseicons/advanced-selling-skills',
    'courseicons/advanced-strategic-planning',
    'courseicons/advertising-practice',
    'courseicons/assertiveness-skills',
    'courseicons/basic-accounting',
    'courseicons/basic-project-management',
    'courseicons/better-communications',
    'courseicons/budgeting',
    'courseicons/building-rapport-and-trust',
    'courseicons/business-administration',
    'courseicons/business-analysis',
    'courseicons/business-case-development',
    'courseicons/business-computing',
    'courseicons/business-law',
    'courseicons/business-modelling',
    'courseicons/business-skills-for-new-managers',
    'courseicons/business-strategy',
    'courseicons/business-writing-skills',
    'courseicons/buyer-behaviour',
    'courseicons/change-management',
    'courseicons/coaching-and-mentoring',
    'courseicons/communication-theory-and-concepts',
    'courseicons/company-valuations',
    'courseicons/conflict-management',
    'courseicons/contract-tendering',
    'courseicons/creating-a-successful-sales-proposal',
    'courseicons/creativity-and-innovation',
    'courseicons/critical-thinking',
    'courseicons/customer-attraction',
    'courseicons/data-analysis',
    'courseicons/default',
    'courseicons/delegation',
    'courseicons/design-led-thinking',
    'courseicons/developing-strengths-into-talents',
    'courseicons/digital-marketing',
    'courseicons/economics',
    'courseicons/effective-meetings',
    'courseicons/emotional-intelligence',
    'courseicons/empowering-individuals-and-teams',
    'courseicons/event-management',
    'courseicons/event-planning',
    'courseicons/facilitation',
    'courseicons/finance-for-managers',
    'courseicons/finance-for-the-public-sector',
    'courseicons/finance',
    'courseicons/forecasting-budgeting-and-strategic-planning',
    'courseicons/generating-sustainable-revenue-streams',
    'courseicons/getting-orientated',
    'courseicons/hospitality',
    'courseicons/human-centered-design',
    'courseicons/human-resources',
    'courseicons/induction',
    'courseicons/international-business',
    'courseicons/international-marketing',
    'courseicons/intranet-content-editors-training',
    'courseicons/introduction-to-banking-and-financial-services',
    'courseicons/inventory-management',
    'courseicons/key-account-management',
    'courseicons/knowing-my-computer',
    'courseicons/knowledge-management',
    'courseicons/law-of-business-entities',
    'courseicons/leadership',
    'courseicons/leading-strategically',
    'courseicons/learning-programs',
    'courseicons/managing-information-technology-projects',
    'courseicons/managing-resources',
    'courseicons/marketing-planning',
    'courseicons/media-training',
    'courseicons/mind-mapping',
    'courseicons/motivation-and-leadership',
    'courseicons/myers-briggs-for-personal-development',
    'courseicons/negotiating-contracts',
    'courseicons/netiquette',
    'courseicons/new-product-development',
    'courseicons/obtaining-feedback',
    'courseicons/operations-management',
    'courseicons/organisational-behaviour',
    'courseicons/outsourcing',
    'courseicons/pay-and-performance',
    'courseicons/people-and-communities',
    'courseicons/portfolio-and-programme-management',
    'courseicons/presentation-skills',
    'courseicons/pricing-strategies-and-tactics',
    'courseicons/principles-of-managerial-finance',
    'courseicons/procurement-management',
    'courseicons/professional-communication',
    'courseicons/public-relations',
    'courseicons/quality-management',
    'courseicons/rapid-reading-for-business',
    'courseicons/reducing-working-capital',
    'courseicons/research-methods',
    'courseicons/risk-management',
    'courseicons/sales-and-marketing',
    'courseicons/sales-skills',
    'courseicons/service-level-agreements',
    'courseicons/stakeholder-management',
    'courseicons/strategic-marketing',
    'courseicons/supply-chain-management',
    'courseicons/systematic-problem-solving',
    'courseicons/systems-thinking',
    'courseicons/tax-law',
    'courseicons/team-management',
    'courseicons/technical-writing',
    'courseicons/technical',
    'courseicons/the-business-environment',
    'courseicons/time-management',
    'courseicons/touch-typing',
    'courseicons/value-stream-mapping',
    'courseicons/web-conferencing',
    'courseicons/writing-contracts',
    'courseicons/writing-reports',
    'jquery_treeview/treeview-black-line',
    'jquery_treeview/treeview-black',
    'jquery_treeview/treeview-default-line-rtl',
    'jquery_treeview/treeview-default-line',
    'jquery_treeview/treeview-default-rtl',
    'jquery_treeview/treeview-default',
    'jquery_treeview/treeview-famfamfam-line',
    'jquery_treeview/treeview-famfamfam',
    'jquery_treeview/treeview-gray-line',
    'jquery_treeview/treeview-gray',
    'jquery_treeview/treeview-red-line',
    'jquery_treeview/treeview-red',
    'jquery_ui_dialog/ui-bg_flat_0_aaaaaa_40x100',
    'jquery_ui_dialog/ui-bg_flat_50_666666_40x100',
    'jquery_ui_dialog/ui-bg_flat_75_ffffff_40x100',
    'jquery_ui_dialog/ui-bg_glass_50_e6e6e6_1x400',
    'jquery_ui_dialog/ui-bg_glass_55_fbf9ee_1x400',
    'jquery_ui_dialog/ui-bg_glass_65_ffffff_1x400',
    'jquery_ui_dialog/ui-bg_glass_75_dadada_1x400',
    'jquery_ui_dialog/ui-bg_glass_95_fef1ec_1x400',
    'jquery_ui_dialog/ui-bg_highlight-hard_0_ffffff_1x100',
    'jquery_ui_dialog/ui-icons_000000_256x240',
    'jquery_ui_dialog/ui-icons_2e83ff_256x240',
    'jquery_ui_dialog/ui-icons_454545_256x240',
    'jquery_ui_dialog/ui-icons_888888_256x240',
    'jquery_ui_dialog/ui-icons_cd0a0a_256x240',
    'logo',
    'programicons/achieving-success',
    'programicons/advanced-accounting',
    'programicons/advanced-business-process-improvement',
    'programicons/advanced-project-management',
    'programicons/advanced-selling-skills',
    'programicons/advanced-strategic-planning',
    'programicons/advertising-practice',
    'programicons/assertiveness-skills',
    'programicons/basic-accounting',
    'programicons/basic-project-management',
    'programicons/better-communications',
    'programicons/budgeting',
    'programicons/building-rapport-and-trust',
    'programicons/business-administration',
    'programicons/business-analysis',
    'programicons/business-case-development',
    'programicons/business-computing',
    'programicons/business-law',
    'programicons/business-modelling',
    'programicons/business-skills-for-new-managers',
    'programicons/business-strategy',
    'programicons/business-writing-skills',
    'programicons/buyer-behaviour',
    'programicons/change-management',
    'programicons/coaching-and-mentoring',
    'programicons/communication-theory-and-concepts',
    'programicons/company-valuations',
    'programicons/conflict-management',
    'programicons/contract-tendering',
    'programicons/creating-a-successful-sales-proposal',
    'programicons/creativity-and-innovation',
    'programicons/critical-thinking',
    'programicons/customer-attraction',
    'programicons/data-analysis',
    'programicons/default',
    'programicons/delegation',
    'programicons/design-led-thinking',
    'programicons/developing-strengths-into-talents',
    'programicons/digital-marketing',
    'programicons/economics',
    'programicons/effective-meetings',
    'programicons/emotional-intelligence',
    'programicons/empowering-individuals-and-teams',
    'programicons/event-management',
    'programicons/event-planning',
    'programicons/facilitation',
    'programicons/finance-for-managers',
    'programicons/finance-for-the-public-sector',
    'programicons/finance',
    'programicons/forecasting-budgeting-and-strategic-planning',
    'programicons/generating-sustainable-revenue-streams',
    'programicons/getting-orientated',
    'programicons/hospitality',
    'programicons/human-centered-design',
    'programicons/human-resources',
    'programicons/induction',
    'programicons/international-business',
    'programicons/international-marketing',
    'programicons/intranet-content-editors-training',
    'programicons/introduction-to-banking-and-financial-services',
    'programicons/inventory-management',
    'programicons/key-account-management',
    'programicons/knowing-my-computer',
    'programicons/knowledge-management',
    'programicons/law-of-business-entities',
    'programicons/leadership',
    'programicons/leading-strategically',
    'programicons/learning-programs',
    'programicons/managing-information-technology-projects',
    'programicons/managing-resources',
    'programicons/marketing-planning',
    'programicons/media-training',
    'programicons/mind-mapping',
    'programicons/motivation-and-leadership',
    'programicons/myers-briggs-for-personal-development',
    'programicons/negotiating-contracts',
    'programicons/netiquette',
    'programicons/new-product-development',
    'programicons/obtaining-feedback',
    'programicons/operations-management',
    'programicons/organisational-behaviour',
    'programicons/outsourcing',
    'programicons/pay-and-performance',
    'programicons/people-and-communities',
    'programicons/portfolio-and-programme-management',
    'programicons/presentation-skills',
    'programicons/pricing-strategies-and-tactics',
    'programicons/principles-of-managerial-finance',
    'programicons/procurement-management',
    'programicons/professional-communication',
    'programicons/public-relations',
    'programicons/quality-management',
    'programicons/rapid-reading-for-business',
    'programicons/reducing-working-capital',
    'programicons/research-methods',
    'programicons/risk-management',
    'programicons/sales-and-marketing',
    'programicons/sales-skills',
    'programicons/service-level-agreements',
    'programicons/stakeholder-management',
    'programicons/strategic-marketing',
    'programicons/supply-chain-management',
    'programicons/systematic-problem-solving',
    'programicons/systems-thinking',
    'programicons/tax-law',
    'programicons/team-management',
    'programicons/technical-writing',
    'programicons/technical',
    'programicons/the-business-environment',
    'programicons/time-management',
    'programicons/touch-typing',
    'programicons/value-stream-mapping',
    'programicons/web-conferencing',
    'programicons/writing-contracts',
    'programicons/writing-reports',

    /* Following images are used from CSS only */
    'totara_core|t/comments' => 'comment',
    'totara_core|t/comments-none' => 'comment',
);
