<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author  Kian Nguyen <kian.nguyen@totaralearning.com>
 * @package totara_engage
 */
namespace totara_engage\formatter;

use core\webapi\formatter\field\string_field_formatter;
use core\webapi\formatter\formatter;
use stdClass;
use totara_engage\formatter\field\date_field_formatter;
use totara_engage\resource\resource_item;

/**
 * Class resource_formatter
 * @package totara_engage\formatter
 */
final class resource_formatter extends formatter {
    /**
     * resource_formatter constructor.
     * @param resource_item $item
     */
    public function __construct(resource_item $item) {
        $record = new stdClass();
        $record->id = $item->get_id();
        $record->instanceid = $item->get_instanceid();
        $record->name = $item->get_name(false);
        $record->access = $item->get_access_code();
        $record->context_id = $item->get_context_id();

        // Timestamp
        $record->timecreated = $item->get_timecreated();
        $record->timemodified = $item->get_timemodified();

        $context = $item->get_context();
        parent::__construct($record, $context);
    }

    /**
     * @param string $field
     * @return mixed|null
     */
    protected function get_field(string $field) {
        if ('time' === $field) {
            return $this->object->timecreated;
        }
        return parent::get_field($field);
    }

    /**
     * @param string $field
     * @return bool
     */
    protected function has_field(string $field): bool {
        if ('time' === $field) {
            return true;
        }

        return parent::has_field($field); // TODO: Change the autogenerated stub
    }

    /**
     * @return array
     */
    protected function get_map(): array {
        $that = $this;

        return [
            'id' => null,
            'instanceid' => null,
            'access' => null,
            'context_id' => null,
            'time' => function (?int $value, date_field_formatter $formatter) use ($that): string {
                if (null !== $that->object->timemodified && 0 !== $that->object->timemodified) {
                    $formatter->set_timemodified($that->object->timemodified);
                }

                return $formatter->format($value);
            },

            'name' => string_field_formatter::class,
        ];
    }
}