<?php
/**
 * This file is part of Totara LMS
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Nathan Lewis <nathan.lewis@totaralearning.com>
 * @package totara_job
 */

/**
 * Local database upgrade script
 *
 * @param   integer $oldversion Current (pre-upgrade) local db version timestamp
 * @return  boolean $result
 */
function xmldb_totara_job_upgrade($oldversion) {
    global $CFG, $DB;
    require_once("{$CFG->dirroot}/totara/job/db/upgradelib.php");

    $dbman = $DB->get_manager();

    if ($oldversion < 2021112500) {
        require_once($CFG->dirroot . '/totara/core/db/upgradelib.php');
        totara_core_upgrade_create_relationship('totara_job\relationship\resolvers\direct_report', 'direct_report', 8);

        upgrade_plugin_savepoint(true, 2021112500, 'totara', 'job');
    }

    if ($oldversion < 2022050500) {
        totara_job_fix_dangling_temp_manager_assignments();
        upgrade_plugin_savepoint(true, 2022050500, 'totara', 'job');
    }

    // Replay previous upgrades that might have been skipped due to TL-36528.
    if ($oldversion < 2023021300) {
        require_once($CFG->dirroot . '/totara/core/db/upgradelib.php');

        totara_core_upgrade_create_relationship(['totara_job\relationship\resolvers\manager'], 'manager', 2);
        totara_core_upgrade_create_relationship(['totara_job\relationship\resolvers\managers_manager'], 'managers_manager', 3);
        totara_core_upgrade_create_relationship(['totara_job\relationship\resolvers\appraiser'], 'appraiser', 4);
        totara_core_upgrade_create_relationship('totara_job\relationship\resolvers\direct_report', 'direct_report', 8);
        
        upgrade_plugin_savepoint(true, 2023021300, 'totara', 'job');
    }

    return true;
}
