<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2022 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author  Simon Player <simon.player@totara.com>
 * @package totara_program
 */

namespace totara_program\entity;

use core\orm\entity\repository;

class program_completion_repository extends repository {

    /**
     * @param int $program_id
     * @return $this
     */
    public function find_by_program_id(int $program_id): program_completion_repository  {
        $this->where('programid', $program_id);

        return $this;
    }

    /**
     * @param int $user_id
     */
    public function find_by_user_id(int $user_id): program_completion_repository {
        $this->where('userid', $user_id);

        return $this;
    }
}
