<?php
/*
 * This file is part of Totara Learn
 *
 * Copyright (C) 2018 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Simon Player <simon.player@totaralearning.com>
 * @package totara_reportbuilder
 */

namespace totara_reportbuilder\rb\display;

/**
 * Display class intended to convert IP address into a link to IP lookup page
 *
 * @author Simon Player <simon.player@totaralearning.com>
 * @package totara_reportbuilder
 */
class ip_lookup_link extends base {

    /**
     * Handles the display
     *
     * @param string $value
     * @param string $format
     * @param \stdClass $row
     * @param \rb_column $column
     * @param \reportbuilder $report
     * @return string
     */
    public static function display($value, $format, \stdClass $row, \rb_column $column, \reportbuilder $report) {
        global $CFG;
        if (!isset($value) || $value == '') {
            return '';
        }

        $isexport = ($format !== 'html');
        if ($isexport || !ip_is_public($value)) {
            return $value;
        }

        $extrafields = self::get_extrafields_row($row, $column);

        $params = array('ip' => $value);
        $target_user_id = null;
        if (isset($extrafields->user_id)) {
            $params['user'] = $extrafields->user_id;
            $target_user_id = $params['user'];
        }

        require_once $CFG->dirroot . '/iplookup/lib.php';
        if (!ip_lookup_enabled_for_user(null, $target_user_id)) {
            return $value;
        }

        $url = new \moodle_url('/iplookup/index.php', $params);
        return \html_writer::link($url, $value);
    }

    /**
     * Is this column graphable?
     *
     * @param \rb_column $column
     * @param \rb_column_option $option
     * @param \reportbuilder $report
     * @return bool
     */
    public static function is_graphable(\rb_column $column, \rb_column_option $option, \reportbuilder $report) {
        return true;
    }
}
