<?php
/*
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Simon Coggins <simon.coggins@totaralearning.com>
 * @package totara_topic
 */

namespace totara_topic;

use core\plugininfo\totara;
use core_tag\entity\tag_collection;
use core_tag\entity\tag_instance;
use core_tag\entity\tag;

defined('MOODLE_INTERNAL') || die();

class plugininfo extends totara {
    public function get_usage_for_registration_data() {
        $data = array();

        $engage_tag_collection_id = topic_helper::get_engage_tag_collection_id();

        $data['numtopics'] = tag::repository()->count_tags_for_collection_id($engage_tag_collection_id);
        $data['numtopicinstances'] = tag_instance::repository()->count_instances_for_collection_id(
            $engage_tag_collection_id,
            ['engage_article', 'engage_survey', 'totara_playlist']
        );

        return $data;
    }
}
