<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * @author Simon Chester <simon.chester@totaralearning.com>
 * @author Sam Hemelryk <sam.hemelryk@totaralearning.com>
 * @package totara_tui
 */

define('CLI_SCRIPT', true);
define('ABORT_AFTER_CONFIG', true);

require(__DIR__.'/../../../config.php');
require_once($CFG->libdir.'/clilib.php');

error_reporting(E_ALL | E_STRICT);
ini_set('display_errors', 1);

[$options, $unrecognized] = cli_get_params(
    [
        'write' => false,
    ],
    [
        'h' => 'help'
    ]
);

if ($unrecognized) {
    $unrecognized = implode("\n  ", $unrecognized);
    cli_error(get_string('cliunknowoption', 'admin', $unrecognized), 2);
}

if (!$options['write']) {
    $help = <<<OUT
Generate a graphql location map that can be used by frontend frameworks to find
graphql queries and mutations for core components and plugin types in a predictable way.

The component map is written to graphql_locations.json

Options:
-h, --help            Print out this help
--write               Write data to file

OUT;

    echo($help);
    exit(0);
}

$strip_srcroot = function(&$path): string {
    global $CFG;
    $pos = strpos($path, $CFG->srcroot);
    if ($pos === 0) {
        $path = substr($path, strlen($CFG->srcroot) + 1);
    }
    return $path;
};

$subsystems = array_filter(\core_component::get_core_subsystems());
array_walk($subsystems, $strip_srcroot);

$plugintypes = \core_component::get_plugin_types();
array_walk($plugintypes, $strip_srcroot);


$webapi_pattern = '/webapi/ajax/';
$components = [
    'core' => 'server/lib' . $webapi_pattern
];
foreach ($subsystems as $subsystem => $dir) {
    $components[$subsystem] = $dir . $webapi_pattern;
}
foreach ($plugintypes as $plugintype => $dir) {
    $components[$plugintype . '_([a-zA-Z0-9_]+)'] = $dir . DIRECTORY_SEPARATOR . '{$1}' . $webapi_pattern;
}
ksort($components);

$path = __FILE__;
$strip_srcroot($path);
$data = [
    '//' => 'Generated by ' . $path,
    'locations' => $components
];

$content = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES) . "\n";

file_put_contents($CFG->srcroot . '/graphql_locations.json', $content);
